/*********************************************************/
/* Packet struct with many definitions.                  */
/*********************************************************/
/* $Id: packet.h,v 1.5 2000/09/12 08:59:04 slay Exp $ */
/*********************************************************/
#ifndef __PACKET_H__
#define __PACKET_H__

#include "dev_struct.h"

 /* Linked list of Routers within an ICMP Router Advertisement */
struct router {
                u_long address; /* Router address */
                u_long pref; /* Router preference */
                struct router *next;
              };
              
struct my_pack { char *name_dst; /* Target host name */
                 FILE *logfile; /* Dump the log to a file */
                 struct sockaddr_in destino; /* Target host address */
                 u_long ip_spoof; /* IP spoof address */
                 char spoof; /* We'll use spoof? */
                 struct mi_ifaz iface2route; /* Packets will route throughout */
                 char *listen2dev; /* Listen on this dev (if spoof used) */
                 u_long gway; /* Redirect gway */
                 u_long dest_red; /* Redirect destination */
                 u_long orig; /* ICMP error */
                 int cod_icmp; /* ICMP code */
                 u_short tipo_icmp; /* ICMP type */
                 u_short protocol; /* Protocol (ICMP error) */
                 u_short p_origen; /* Source port (ICMP error) */
                 u_short p_destino; /* Destination Port (ICMP error) */
                 u_long maskaddr;  /* Not really used by now */
                 struct router *router; /* Router(s) Advertisements */
                 u_short lifetime; /* Advertisement Lifetime */
                 u_short num_routers; /* Routers on Advertisement */
                 char *pattern; /* Data pattern (Echo) */
                 int size_pattern; /* Data pattern size (Echo) */
                 int timeout; /* Timeout between packets (Information) */
                 int flood; /* Packets Preload (Information) */
                 u_char pointer; /* Pointer (Param Problem) */
                 u_long garbage; /* Garbage */
                 u_int mtu; /*  to fragment or no to fragment, ;) */
                 u_short rr; /* Record Routing? */
                 char *ipopt; /* IP Options header */
                 u_int len_ipopt; /* IP Options len */
                 u_short ttl; /* IP TTL */
                 u_short tos; /* IP TOS */
                 u_long count_rx; /* Packets received */
                 u_short info_id; /* ICMP Id */
                 u_short info_seq; /* ICMP Echo Sequence */
               };

#endif