#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command
# this file is copied to SDL_ttf.post_install and SDL_ttf.post_upgrade
# inside the .pkg bundle
echo "Running post-install script"
umask 022

ROOT=/Developer/Documentation/SDL

echo "Moving SDL_ttf.framework to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
mkdir -p ~/Library/Frameworks
/Developer/Tools/CpMac -r $ROOT/SDL_ttf.framework ~/Library/Frameworks
rm -rf $ROOT/SDL_ttf.framework

echo "Precompiling Header"
# precompile header for speedier compiles
/usr/bin/cc -I $HOME/Library/Frameworks/SDL.framework/Headers -precomp ~/Library/Frameworks/SDL_ttf.framework/Headers/SDL_ttf.h -o ~/Library/Frameworks/SDL_ttf.framework/Headers/SDL_ttf.p
