#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command
# this file is copied to SDL-mixer.post_install and SDL-mixer.post_upgrade
# inside the .pkg bundle
echo "Running post-install script"
umask 022

ROOT=/Developer/Documentation/SDL

echo "Moving SDL_mixer.framework to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
mkdir -p ~/Library/Frameworks
/Developer/Tools/CpMac -r $ROOT/SDL_mixer.framework ~/Library/Frameworks
rm -rf $ROOT/SDL_mixer.framework

echo "Precompiling Header"
# precompile header for speedier compiles
/usr/bin/cc -I $HOME/Library/Frameworks/SDL.framework/Headers -precomp ~/Library/Frameworks/SDL_mixer.framework/Headers/SDL_mixer.h -o ~/Library/Frameworks/SDL_mixer.framework/Headers/SDL_mixer.p
