/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CGARMINWPT_H
#define CGARMINWPT_H

#include <IDevice.h>
#include <QObject>
#include <QPixmap>
#include <QString>

class CGarminWpt : public QObject, public Garmin::Wpt_t
{
    Q_OBJECT
        public:
        CGarminWpt(QObject * parent);
        CGarminWpt(const Garmin::Wpt_t& wpt, QObject * parent);
        virtual ~CGarminWpt();

        /// convert to a Garmin Wpt_t structure
        const Garmin::Wpt_t& toGarminWpt();
        /// request to mark this waypoint as selected
        /**
            Actually this will not select the waypoint, but it will request
            CGarminWpt to deselect all other waypoints and to select this one.
        */
        void select(){emit sigSelected(this);}
        /// test if this waypoint is selected
        bool isSelected(){return selected;}

        QString key;
        QString ident;
        QString comment;
        QString facility;
        QString city;
        QString addr;
        QString crossroad;

        QPixmap icon;
        QString link;

        bool sticky;

        signals:
        void sigSelected(CGarminWpt* wpt);

    protected:
        friend class CGarminDBWpt;
        bool selected;
};
#endif                           // CGARMINWPT_H
