/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CDEVICE_H
#define CDEVICE_H

#include "IDeviceDefault.h"
#include "CSerial.h"

namespace NMEA
{

    class CDevice : public Garmin::IDeviceDefault
    {
        public:
            CDevice();
            virtual ~CDevice();

            const std::string& getCopyright();

        private:
            friend void * rtThread(void *ptr);

            void _acquire();
            void _setRealTimeMode(bool on);
            void _getRealTimePos(Garmin::Pvt_t& pvt);
            void _release();

            /// realtime mode thread
            pthread_t thread;
            /// mutex to serialize any data access
            pthread_mutex_t dataMutex;
            Garmin::CSerial * serial;
            /// keep alive flag for the realtime mode thread
            bool doRealtimeThread;
            void GPRMC(char *GPRMCLine, Garmin::Pvt_t &pvt);
            void GPGGA(char *GPGGALine, Garmin::Pvt_t &pvt);
            void GPGSA(char *GPGSALine, Garmin::Pvt_t &pvt);

            Garmin::Pvt_t PositionVelocityTime;


    };

}
#endif //CDEVICE_H

