/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef GARMINTYPEDEF_H
#define GARMINTYPEDEF_H

#pragma pack(1)

struct FATblock_t
{
    quint8  flag;               ///< 0x00000000
    char    name[8];            ///< 0x00000001 .. 0x00000008
    char    type[3];            ///< 0x00000009 .. 0x0000000B
    quint32 size;               ///< 0x0000000C .. 0x0000000F
    quint16 part;               ///< 0x00000010 .. 0x00000011
    quint8  byte0x00000012_0x0000001F[14];
    quint16 blocks[240];        ///< 0x00000020 .. 0x000001FF
};

struct hdr_img_t
{
    quint8  xorByte;            ///< 0x00000000
    quint8  byte0x00000001_0x0000000F[15];
    char    signature[7];       ///< 0x00000010 .. 0x00000016
    quint8  byte0x00000017_0x00000040[42];
    char    identifier[7];      ///< 0x00000041 .. 0x00000047
    quint8  byte0x00000048;
    char    desc1[20];          ///< 0x00000049 .. 0x0000005C
    quint8  byte0x0000005D_0x00000060[4];
    quint8  e1;                 ///< 0x00000061
    quint8  e2;                 ///< 0x00000062
    quint8  byte0x00000063_0x00000064[2];
    char    desc2[31];          ///< 0x00000065 .. 0x00000083
    quint8  byte0x00000084_0x0000040B[904];
    quint32 dataoffset;         ///< 0x0000040C .. 0x0000040F
    quint8  byte0x00000410_0x0000041F[16];
    quint16 blocks[240];        ///< 0x00000420 .. 0x000005FF

    quint32 blocksize(){return 1 << (e1 + e2);}
};

struct hdr_subfile_part_t
{
    quint16 length;             ///< 0x00000000 .. 0x00000001
    char    type[10];           ///< 0x00000002 .. 0x0000000B
    quint8  byte0x0000000C;
    quint8  flag;               ///< 0x0000000D
    quint8  byte0x0000000E_0x00000014[7];
};

struct hdr_rgn_t : public hdr_subfile_part_t
{
    quint32 offset;             ///< 0x00000015 .. 0x00000018
    quint32 length;             ///< 0x00000019 .. 0x0000000C
};

typedef quint8 quint24[3];

struct hdr_tre_t : public hdr_subfile_part_t
{
    quint24 northbound;         ///< 0x00000015 .. 0x00000017
    quint24 eastbound;          ///< 0x00000018 .. 0x0000001A
    quint24 southbound;         ///< 0x0000001B .. 0x0000001D
    quint24 westbound;          ///< 0x0000001E .. 0x00000020
    quint32 tre1_offset;        ///< 0x00000021 .. 0x00000024
    quint32 tre1_size;          ///< 0x00000025 .. 0x00000028
    quint32 tre2_offset;        ///< 0x00000029 .. 0x0000002C
    quint32 tre2_size;          ///< 0x0000002D .. 0x00000030
    quint32 tre3_offset;        ///< 0x00000031 .. 0x00000034
    quint32 tre3_size;          ///< 0x00000035 .. 0x00000038
    quint16 tre3_rec_size;      ///< 0x00000039 .. 0x0000003A
    quint8  byte0x0000003B_0x0000003E[4];
    quint8  POI_flags;          ///< 0x0000003F
    quint8  byte0x00000040_0x00000049[10];
    quint32 tre4_offset;        ///< 0x0000004A .. 0x0000004D
    quint32 tre4_size;          ///< 0x0000004E .. 0x00000051
    quint16 tre4_rec_size;      ///< 0x00000052 .. 0x00000053
    quint8  byte0x00000054_0x00000057[4];
    quint32 tre5_offset;        ///< 0x00000058 .. 0x0000005B
    quint32 tre5_size;          ///< 0x0000005C .. 0x0000005F
    quint16 tre5_rec_size;      ///< 0x00000060 .. 0x00000061
    quint8  byte0x00000062_0x00000065[4];
    quint32 tre6_offset;        ///< 0x00000066 .. 0x00000069
    quint32 tre6_size;          ///< 0x0000006A .. 0x0000006D
    quint16 tre6_rec_size;      ///< 0x0000006E .. 0x0000006F
    quint8  byte0x00000070_0x00000073[4];
    /*-----------------------------------------------------*/
    quint8  byte0x00000074_0x0000007B[8];
    quint32 tre7_offset;        ///< 0x0000007C .. 0x0000007F
    quint32 tre7_size;          ///< 0x00000080 .. 0x00000083
    quint32 tre7_rec_size;      ///< 0x00000084 .. 0x00000085
    quint8  byte0x00000086_0x00000089[4];
    quint32 tre8_offset;        ///< 0x0000008A .. 0x0000008D
    quint32 tre8_size;          ///< 0x0000008E .. 0x00000091
    quint8  byte0x00000092_0x00000099[8];
    /*-----------------------------------------------------*/
    quint8  key[20];            ///< 0x0000009A .. 0x000000AD
    quint32 tre9_offset;        ///< 0x000000AE .. 0x000000B1
    quint32 tre9_size;          ///< 0x000000B2 .. 0x000000B5
    quint32 tre9_rec_size;      ///< 0x000000B6 .. 0x000000B7

};

struct tre_map_level_t
{
    quint8  level       :4;
    quint8  bit4_6      :3;
    quint8  inherited   :1;
    quint8  bits;
    quint16 nsubdiv;
};

struct tre_subdiv_t
{
    quint24 rgn_offset;
    quint8  elements;
    quint24 center_lng;
    quint24 center_lat;
    quint16 width       :15;
    quint16 terminate   :1;
    quint16 height;
};

struct tre_subdiv_next_t : public tre_subdiv_t
{
    quint16 next;
};

struct hdr_lbl_t : public hdr_subfile_part_t
{
    quint32 lbl1_offset;        ///< 0x00000015 .. 0x00000018
    quint32 lbl1_length;        ///< 0x00000019 .. 0x0000001C
    quint8  addr_shift;         ///< 0x0000001D
    quint8  coding;             ///< 0x0000001E
    quint32 lbl2_offset;        ///< 0x0000001F .. 0x00000022
    quint32 lbl2_length;        ///< 0x00000023 .. 0x00000026
    quint16 lbl2_rec_size;      ///< 0x00000027 .. 0x00000028
    quint8  byte0x00000029_0x0000002C[4];
    quint32 lbl3_offset;        ///< 0x0000002D .. 0x00000030
    quint32 lbl3_length;        ///< 0x00000031 .. 0x00000034
    quint16 lbl3_rec_size;      ///< 0x00000035 .. 0x00000036
    quint8  byte0x00000037_0x0000003A[4];
    quint32 lbl4_offset;        ///< 0x0000003B .. 0x0000003E
    quint32 lbl4_length;        ///< 0x0000003F .. 0x00000042
    quint16 lbl4_rec_size;      ///< 0x00000043 .. 0x00000044
    quint8  byte0x00000045_0x00000048[4];
    quint32 lbl5_offset;        ///< 0x00000049 .. 0x0000004C
    quint32 lbl5_length;        ///< 0x0000004D .. 0x00000050
    quint16 lbl5_rec_size;      ///< 0x00000051 .. 0x00000052
    quint8  byte0x00000053_0x00000056[4];
    quint32 lbl6_offset;        ///< 0x00000057 .. 0x0000005A
    quint32 lbl6_length;        ///< 0x0000005B .. 0x0000005E
    quint8  lbl6_addr_shift;    ///< 0x0000005F
    quint8  lbl6_glob_mask;     ///< 0x00000060
    quint8  byte0x00000061_0x00000063[3];
    quint32 lbl7_offset;        ///< 0x00000064 .. 0x00000067
    quint32 lbl7_length;        ///< 0x00000068 .. 0x0000006B
    quint16 lbl7_rec_size;      ///< 0x0000006C .. 0x0000006D
    quint8  byte0x0000006E_0x00000071[4];
    quint32 lbl8_offset;        ///< 0x00000072 .. 0x00000075
    quint32 lbl8_length;        ///< 0x00000076 .. 0x00000079
    quint16 lbl8_rec_size;      ///< 0x0000007A .. 0x0000007B
    quint8  byte0x0000007C_0x0000007F[4];
    quint32 lbl9_offset;        ///< 0x00000080 .. 0x00000083
    quint32 lbl9_length;        ///< 0x00000084 .. 0x00000087
    quint16 lbl9_rec_size;      ///< 0x00000088 .. 0x00000089
    quint8  byte0x0000008A_0x0000008D[4];
    quint32 lbl10_offset;       ///< 0x0000008E .. 0x00000091
    quint32 lbl10_length;       ///< 0x00000092 .. 0x00000095
    quint16 lbl10_rec_size;     ///< 0x00000096 .. 0x00000097
    quint8  byte0x00000098_0x0000009B[4];
    quint32 lbl11_offset;       ///< 0x0000009C .. 0x0000009F
    quint32 lbl11_length;       ///< 0x000000A0 .. 0x000000A3
    quint16 lbl11_rec_size;     ///< 0x000000A4 .. 0x000000A5
    quint8  byte0x000000A6_0x000000AB[4];
    quint16 codepage;           ///< 0x000000AA .. 0x000000AB  optional check length

};

struct hdr_net_t : public hdr_subfile_part_t
{
    quint32 net1_offset;        ///< 0x00000015 .. 0x00000018
    quint32 net1_length;        ///< 0x00000019 .. 0x0000001C
    quint8  net1_addr_shift;    ///< 0x0000001D
    quint32 net2_offset;        ///< 0x0000001E .. 0x00000021
    quint32 net2_length;        ///< 0x00000022 .. 0x00000025
    quint16 net2_addr_shift;    ///< 0x00000026
    quint32 net3_offset;        ///< 0x00000027 .. 0x0000002A
    quint32 net3_length;        ///< 0x0000002B .. 0x0000002E
};


struct garmin_bmp_t{
    quint16 bfType;
    quint32 bfSize;
    quint32 bfReserved;
    quint32 bfOffBits;

    quint32 biSize;
    qint32 biWidth;
    qint32 biHeight;
    quint16 biPlanes;
    quint16 biBitCount;
    quint32 biCompression;
    quint32 biSizeImage;
    quint32 biXPelsPerMeter;
    quint32 biYPelsPerMeter;
    quint32 biClrUsed;
    quint32 biClrImportant;

    quint32 clrtbl[0x100];

    quint8  data[];
};

#pragma pack(0)

#endif //GARMINTYPEDEF_H

