/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef GARMINSTRTBL_H
#define GARMINSTRTBL_H

#include <QObject>
#include <QByteArray>
#include <QStringList>

struct hdr_lbl_t;
struct hdr_net_t;

struct str_info_t
{
    quint16 type;
    QStringList labels;

    const QString& label1() const { return (labels.count() > 0) ? labels[0] : dummy;}

    private:
        QString dummy;
};


/// base class for all string tables
class IGarminStrTbl : public QObject
{
    public:
        IGarminStrTbl(const quint8* pDataLBL, quint32 sizeLBL, QObject * parent);
        virtual ~IGarminStrTbl();

        enum type_e {norm,poi,net};

        virtual void registerNETSection(const quint8* pDataNET, quint32 sizeNET);

        virtual void get(quint32 , type_e, str_info_t&){}


    protected:
        quint32 calcOffset(const quint32 offset, type_e t);

        /// the complete LBL data section
        QByteArray dataLBL;
        /// pointer to LBL section header
        const hdr_lbl_t * const hdrLbl;
        /// pointer to LBL 1 data section
        const quint8 * const pLbl1;
        /// pointer to LBL 6 (POI) data section
        const quint8 * const pLbl6;

        /// the complete NET data section
        QByteArray dataNET;
        /// pointer to NET section header
        const hdr_net_t * hdrNet;
        /// pointer to NET 1 data section
        const quint8 * pNet1;

        /// output buffer returned by get()
        char buffer[1024];

        quint16 codepage;
};

/// 6 bit big endian - yuck!!!!
class CGarminStrTbl6 : public IGarminStrTbl
{
    public:
        CGarminStrTbl6(const quint8* pDataLBL, quint32 sizeLBL, QObject * parent);
        virtual ~CGarminStrTbl6();

        virtual void get(quint32 , type_e, str_info_t&);

    protected:
        void fill();
        /// temp shift reg buffer
        quint32 reg;
        /// bits in buffer
        quint32 bits;
        /// pointer to current data;
        const quint8 * p;

};

/// that's what I call a decent string table :)
class CGarminStrTbl8 : public IGarminStrTbl
{
    public:
        CGarminStrTbl8(const quint8* pData, quint32 size, QObject * parent);
        virtual ~CGarminStrTbl8();

        virtual void get(quint32 , type_e, str_info_t& );
};

/// what the hell ...?! Asian format???
class CGarminStrTbl10 : public IGarminStrTbl
{
    public:
        CGarminStrTbl10(const quint8* pDataLBL, quint32 sizeLBL, QObject * parent);
        virtual ~CGarminStrTbl10();

        virtual void get(quint32 offset, type_e t, str_info_t& info);
};

extern IGarminStrTbl * createStringTable(const quint8* pDataLBL, quint32 sizeLBL, QObject * parent);

#endif //GARMINSTRTBL_H

