/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CTOOLVIEWTRACK_H
#define CTOOLVIEWTRACK_H

#include "ui_IToolViewTrack.h"

#include <QWidget>

class CGarminDBTrack;

class CToolViewTrack : public QWidget, private Ui::IToolViewTrack
{
    Q_OBJECT
    public:
        CToolViewTrack(QWidget * parent, CGarminDBTrack* db);
        virtual ~CToolViewTrack();

        void getSelectedTracks(QStringList& keys);

    protected slots:
        void slotItemDoubleClicked(QTreeWidgetItem * item);
        void slotItemClicked(QTreeWidgetItem * item);
        void slotUpdateTackList();
        void slotContextMenu(const QPoint& pos);
        void slotDelete();

    protected:
        void keyPressEvent(QKeyEvent * e);

        bool originator;

        QMenu * contextMenu;
};

#endif //CTOOLVIEWTRACK_H

