/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA
**********************************************************************************************/
#ifndef CTOOLVIEWDIST_H
#define CTOOLVIEWDIST_H

#include <QWidget>

#include "ui_IToolViewDist.h"

class CGarminDBRoute;
class QMenu;

class CToolViewDist : public QWidget, private Ui::IToolViewDist
{
    Q_OBJECT
    public:
        CToolViewDist(QWidget * parent, CGarminDBRoute* db);
        virtual ~CToolViewDist();

    protected slots:
        void slotUpdateDistList();
        void slotItemClicked(QTreeWidgetItem * item);
        void slotItemDoubleClicked(QTreeWidgetItem * item);
        void slotContextMenu(const QPoint& pos);
        void slotDelete();

    protected:
        void keyPressEvent(QKeyEvent * e);
        bool originator;
        QMenu * contextMenu;
};

#endif //CTOOLVIEWDIST_H

