/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CPROJUTM_H
#define CPROJUTM_H

#include "IProjection.h"
#include <QMap>

class CProjUTM : public IProjection
{
  public:
    CProjUTM();
    virtual ~CProjUTM();

    virtual void registerMap(const QString& name, double latBottom, double latTop, double /*lonLeft*/, double /*lonRight*/);

    virtual void switchMap(const QString& name);


  protected:
    PJ * pjBase;

    QMap<QString,PJ*> projections;

};

#endif //CPROJUTM_H

