/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/

#include "CGarminWpt.h"
#include "GarminIcons.h"

CGarminWpt::CGarminWpt(QObject * parent)
    : QObject(parent)
    , sticky(false)
    , selected(false)
{
    getWptIconById(smbl,icon);
}

CGarminWpt::CGarminWpt(const Garmin::Wpt_t& wpt, QObject * parent)
    : QObject(parent)
    , Garmin::Wpt_t(wpt)
    , sticky(false)
    , selected(false)
{
    ident       = wpt.ident.c_str();
    comment     = wpt.comment.c_str();
    facility    = wpt.facility.c_str();
    city        = wpt.city.c_str();
    addr        = wpt.addr.c_str();
    crossroad   = wpt.crossroad.c_str();

    getWptIconById(smbl,icon);
}

CGarminWpt::~CGarminWpt()
{
}

const Garmin::Wpt_t& CGarminWpt::toGarminWpt()
{
    Garmin::Wpt_t::ident        = ident.toAscii().data();
    Garmin::Wpt_t::comment      = comment.toAscii().data();
    Garmin::Wpt_t::facility     = facility.toAscii().data();
    Garmin::Wpt_t::city         = city.toAscii().data();
    Garmin::Wpt_t::addr         = addr.toAscii().data();
    Garmin::Wpt_t::crossroad    = crossroad.toAscii().data();
    return *this;
}
