/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CGARMINMAP_H
#define CGARMINMAP_H

#include "IMap.h"
#include "CCentralResources.h"
#include "CGarminDBMap.h"

class CGarminImg;
class CGarminPolygon;
class CGarminPoint;

class QPolygonF;
class QPointF;

struct subfile_desc_t;

class CGarminMap : public IMap
{
    Q_OBJECT
    public:
        CGarminMap(QObject * parent);
        virtual ~CGarminMap();

        void world();
        void zoom(bool zoomIn, const QPoint& p);
        void zoom(QRect& r);
        void incDetails();
        void decDetails();
        void toggleCityNames();
        void togglePOIs();
        void toggleStreetNames();


    protected slots:
        void slotMapChanged(QRectF& area);
        void slotMapChanged();

    protected:
        /// render the map
        /**
            If p is non zero the map will be rendered to p rather than the
            internal pixmap buffer pixBottom;
        */
        virtual void drawBackground(QPainter * p = 0);

        inline void calcWorldRect()
        {
            IMap::calcWorldRect();
            mapLevelMap = gpResources->mapdb().selectVisibleTiles(CGarminDBMap::eMap, scales[idxZoom].bits + bitBias, worldrect);
            mapLevelOvl = gpResources->mapdb().selectVisibleTiles(CGarminDBMap::eOvl, scales[idxZoom].bits + bitBias, worldrect);
        }
        void setScale(quint32 idx,const QPoint& p);
        void drawSubMap(const subfile_desc_t& map,QPainter& p, quint8 level);

        void drawPolygons(const subfile_desc_t& map,QPainter& p, quint8 level);
        void drawPolylines(const subfile_desc_t& map,QPainter& p, quint8 level);
        void drawPoints(const subfile_desc_t& map,QPainter& p, quint8 level);

        void drawTextOnPolyline(const QPolygonF& poly, const QString& text, QPainter& p);

//         void drawPolygon(const QPolygonF& poly, const CGarminPolygon& line, QPainter& p);
        void drawPolyline(const quint16 type, const QPolygonF& poly, QPainter& p, const QString& label = "");
        void drawPolygon(const quint16 type, const QPolygonF& poly, QPainter& p, const QString& label = "");
        void drawPoint(const QPointF& pt, const CGarminPoint& point, QPainter& p);

        void loadSkin(const QString& filename);


        /// zoom index
        qint32 idxZoom;
        /// scale entry
        struct scale_t
        {
            /// scale name
            QString label;
            /// scale factor
            double scale;
            /// minimum bits required for this resolution
            quint32 bits;
        };

        /// different scale entries indexed by idxZoom,
        static scale_t scales[];
        /// the actual map detail level
        quint8 mapLevelMap;
        quint8 mapLevelOvl;
        /// a bit bias to tweak the actual map detail level
        qint32 bitBias;

};

#endif //CGARMINMAP_H

