/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de, Michael Ritzert
    michael.ritzert@googlemail.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CFUNCTIONSTATEMACHINE_H
#define CFUNCTIONSTATEMACHINE_H

#include <QWidget>

class QGridLayout;
class QLabel;
class CMainWindow;



class CFunctionStateMachine : public QWidget
{
    Q_OBJECT
    public:
        CFunctionStateMachine(QWidget& parent);
        virtual ~CFunctionStateMachine();

        struct func_key_state_t
        {
            const char ** icon;
            QString name;
            void (CFunctionStateMachine::*func)();
            QString tooltip;
        };

        enum mode_e {eMain,eMap,eWaypoint,eTrack};

        void keyPressEvent(QKeyEvent * e);

        void switchByKeyWord(const QString& key);

        mode_e getMode();
    protected:
        void switchState(const func_key_state_t statedef[11]);

        void mousePressEvent(QMouseEvent * e);

        void funcSwitchToDistEdit();
        void funcSwitchToRouteEdit();

        void funcSwitchToMap();
        void funcSwitchToWaypoint();
        void funcSwitchToWptMore();
        void funcSwitchToTrack();
        void funcSwitchToLiveLog();
        void funcSwitchToDistance();
        void funcSwitchToRoute();
        void funcClearAll();
        void funcUpload();
        void funcDownload();

        void funcSwitchToMain();
        void funcZoomArea();
        void funcMoveArea();
        void funcZoomWorld();
        void funcToggleInfo();

        void funcSelectArea();
        void funcUploadMaps();
        void funcDownloadMaps();

        void funcNewWpt();
        void funcNewWptHere();
        void funcEditWpt();
        void funcMoveWpt();
        void funcUploadWpt();
        void funcDownloadWpt();
        void funcSearchOCde();
        void funcDeleteByWpt();

        void funcTrackInfo();
        void funcTrackCombine();
        void funcTrackCut();
        void funcDownloadTrack();

        void funcToggleLog();
        void funcToggleLock();

        void funcDistNew();
        void funcDistEdit();

        void funcRouteNew();
        void funcRouteEdit();
        void funcRouteUpload();

        void funcEditRouteAdd();
        void funcEditRouteMove();
        void funcEditRouteDel();

        QLabel * menuTitle;
        QLabel * menuIcon;

        QGridLayout * layout;
        QLabel * keyEsc;
        QLabel * keyF1;
        QLabel * keyF2;
        QLabel * keyF3;
        QLabel * keyF4;
        QLabel * keyF5;
        QLabel * keyF6;
        QLabel * keyF7;
        QLabel * keyF8;
        QLabel * keyF9;
        QLabel * keyF10;

        QLabel * icons[11];

        QLabel * names[11];

        const func_key_state_t * current;

        static const func_key_state_t fsMain[];
        static const func_key_state_t fsMap[];
        static const func_key_state_t fsWaypoint[];
        static const func_key_state_t fsWptMore[];
        static const func_key_state_t fsTrack[];
        static const func_key_state_t fsLiveLog[];
        static const func_key_state_t fsDistance[];
        static const func_key_state_t fsDistEdit[];
        static const func_key_state_t fsRoute[];
        static const func_key_state_t fsRouteEdit[];




};

#endif //CFUNCTIONSTATEMACHINE_H

