/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgCustomIcons.h"
#include "GarminIcons.h"
#include "CCentralResources.h"
#include "CGarminDBWpt.h"
#include "CDlgWptIcon.h"
#include "GarminTypedef.h"

#include <IDevice.h>
#include <QtGui>

CDlgCustomIcons::CDlgCustomIcons()
{
    setupUi(this);
    connect(butSend,SIGNAL(pressed()),this,SLOT(slotSendToDevice()));
}

CDlgCustomIcons::~CDlgCustomIcons()
{

}

void CDlgCustomIcons::exec()
{

    QPushButton * but;
    QPixmap icon;
    QString name;
    QString src;
    uint16_t id;

    // setup custom icons tab
    for(int i=0; i < N_CUSTOM_ICONS; ++i){
        QTreeWidgetItem * entry = new QTreeWidgetItem(listCustomIcons);
        getWptIconById(CUSTOM_ICONS_ID0 + i, icon, name, src);

        entry->setIcon(0,QIcon(loadIcon(src)));

        entry->setText(1,name);

        but = new QPushButton("x",listCustomIcons);
        but->setObjectName(QString::number(i));
        but->setToolTip(tr("reset icon"));
        connect(but,SIGNAL(pressed()), this, SLOT(slotResetIconSource()));
        listCustomIcons->setItemWidget(entry,2,but);

        but = new QPushButton("...",listCustomIcons);
        but->setObjectName(QString::number(i));
        but->setToolTip(tr("select icon"));
        connect(but,SIGNAL(pressed()), this, SLOT(slotChangeIconSource()));
        listCustomIcons->setItemWidget(entry,3,but);

        entry->setText(4,src);

    }

    listCustomIcons->header()->setResizeMode(0,QHeaderView::Interactive);
    listCustomIcons->header()->setResizeMode(1,QHeaderView::Interactive);
    listCustomIcons->header()->setResizeMode(2,QHeaderView::Interactive);
    listCustomIcons->header()->setResizeMode(3,QHeaderView::Interactive);
    listCustomIcons->resizeColumnToContents(0);
    listCustomIcons->resizeColumnToContents(1);
    listCustomIcons->resizeColumnToContents(2);
    listCustomIcons->resizeColumnToContents(3);

    // setup oc.de icons tab
    QMap<int,CGarminDBWpt::type_t>& cacheIcons = gpResources->wptdb().cacheIcons;
    QMap<int,CGarminDBWpt::type_t>::const_iterator cacheIcon = cacheIcons.begin();
    while(cacheIcon != cacheIcons.end()){
        QTreeWidgetItem * entry = new QTreeWidgetItem(listOCIcons);
        getWptIconByName(cacheIcon->icon, id, icon);
        entry->setIcon(0,QIcon(icon));
        entry->setData(0,Qt::UserRole,cacheIcon.key());
        entry->setText(1,cacheIcon->type);

        but = new QPushButton("x",listOCIcons);
        but->setObjectName(QString::number(cacheIcon.key() - 1));
        but->setToolTip(tr("reset icon"));
        connect(but,SIGNAL(pressed()), this, SLOT(slotResetOCIcon()));
        listOCIcons->setItemWidget(entry,2,but);

        but = new QPushButton("...",listOCIcons);
        but->setObjectName(QString::number(cacheIcon.key() - 1));
        but->setToolTip(tr("select icon"));
        connect(but,SIGNAL(pressed()), this, SLOT(slotChangeOCIcon()));
        listOCIcons->setItemWidget(entry,3,but);

        entry->setText(4,cacheIcon->icon);
        ++cacheIcon;
    }
    listOCIcons->header()->setResizeMode(0,QHeaderView::Interactive);
    listOCIcons->header()->setResizeMode(1,QHeaderView::Interactive);
    listOCIcons->header()->setResizeMode(2,QHeaderView::Interactive);
    listOCIcons->header()->setResizeMode(3,QHeaderView::Interactive);
    listOCIcons->resizeColumnToContents(0);
    listOCIcons->resizeColumnToContents(1);
    listOCIcons->resizeColumnToContents(2);
    listOCIcons->resizeColumnToContents(3);

    QDialog::exec();
}

void CDlgCustomIcons::accept()
{
    for(int i=0; i < N_CUSTOM_ICONS; ++i){
        QTreeWidgetItem * entry = listCustomIcons->topLevelItem(i);
        setWptIconById(CUSTOM_ICONS_ID0 + i, entry->text(4));
    }

    QMap<int,CGarminDBWpt::type_t>& cacheIcons = gpResources->wptdb().cacheIcons;
    for(int n=0; n < listOCIcons->topLevelItemCount(); ++n){
        QTreeWidgetItem * entry = listOCIcons->topLevelItem(n);
        cacheIcons[entry->data(0,Qt::UserRole).toUInt()].icon = entry->text(4);
    }

    QDialog::accept();
}


void CDlgCustomIcons::slotChangeIconSource()
{
    QSettings cfg;
    QDir dir(cfg.value("path/icons",QDir::homePath()).toString());

    QTreeWidgetItem * entry = listCustomIcons->topLevelItem(sender()->objectName().toInt());
    if(entry){
        QString filename = QFileDialog::getOpenFileName(0,tr("Select icon ..."),dir.path());
        if(!filename.isEmpty()){
            entry->setIcon(0,QIcon(loadIcon(filename)));

            entry->setText(4,filename);

            cfg.setValue("path/icons",QFileInfo(filename).absolutePath());
        }
    }
}


void CDlgCustomIcons::slotResetIconSource()
{
    QTreeWidgetItem * entry = listCustomIcons->topLevelItem(sender()->objectName().toInt());
    if(entry){
        entry->setIcon(0,QIcon(loadIcon(":/icons/wpt/custom15x15.bmp")));
        entry->setText(4,":/icons/wpt/custom15x15.bmp");
    }
}

void CDlgCustomIcons::slotSendToDevice()
{
    std::list<Garmin::Icon_t> icons;

    for(int i=0; i < N_CUSTOM_ICONS; ++i){
        QTreeWidgetItem * entry = listCustomIcons->topLevelItem(i);
        QFile file(entry->text(4));
        if(!file.open(QIODevice::ReadOnly)) continue;
        QByteArray buffer = file.readAll();
        file.close();
        const garmin_bmp_t * pBmp = (garmin_bmp_t*)buffer.data();

        qDebug() << "-----------" << entry->text(4);
        qDebug() << "bfType              " << hex << pBmp->bfType;
        qDebug() << "bfSize              " << hex << pBmp->bfSize;
        qDebug() << "bfReserved          " << hex << pBmp->bfReserved;
        qDebug() << "bfOffBits           " << hex << pBmp->bfOffBits;

        qDebug() << "biSize              " << hex << pBmp->biSize;
        qDebug() << "biWidth             " << hex << pBmp->biWidth;
        qDebug() << "biHeight            " << hex << pBmp->biHeight;
        qDebug() << "biPlanes            " << hex << pBmp->biPlanes;
        qDebug() << "biBitCount          " << hex << pBmp->biBitCount;
        qDebug() << "biCompression       " << hex << pBmp->biCompression;
        qDebug() << "biSizeImage         " << hex << pBmp->biSizeImage;
        qDebug() << "biXPelsPerMeter     " << hex << pBmp->biXPelsPerMeter;
        qDebug() << "biYPelsPerMeter     " << hex << pBmp->biYPelsPerMeter;
        qDebug() << "biClrUsed           " << hex << pBmp->biClrUsed;
        qDebug() << "biClrImportant      " << hex << pBmp->biClrImportant;
        qDebug() << "clrtbl[0]           " << hex << pBmp->clrtbl[0];
        qDebug() << "clrtbl[1]           " << hex << pBmp->clrtbl[1];
        qDebug() << "clrtbl[0xfe]        " << hex << pBmp->clrtbl[0xfe];
        qDebug() << "clrtbl[0xff]        " << hex << pBmp->clrtbl[0xff];

        if(    pBmp->biBitCount != 8
            || pBmp->biCompression != 0
            || (pBmp->biClrUsed != 0 && pBmp->biClrUsed != 0x100)
            || (pBmp->biClrImportant != 0 && pBmp->biClrImportant != 0x100)
            || pBmp->biWidth != 16
            || pBmp->biHeight != 16)
        {
            QMessageBox::warning(0,tr("Format Error"),entry->text(4) + tr(": Bad icon format"),QMessageBox::Ok,QMessageBox::NoButton);
            return;
        }

        Garmin::Icon_t icon;
        icons.push_back(icon);
        icons.back().idx = i;
        memcpy(icons.back().clrtbl,pBmp->clrtbl,sizeof(icon.clrtbl));

        for(int r = 0; r < pBmp->biHeight; ++r){
            for(int c = 0; c < pBmp->biWidth; ++c){
                icons.back().data[r * pBmp->biWidth + c] = pBmp->data[(pBmp->biHeight - 1 - r)*pBmp->biWidth + c];
            }
        }

        //memcpy(icons.back().data,pBmp->data,pBmp->biSizeImage);
    }

    Garmin::IDevice * dev = 0;
    try{
        dev = gpResources->device();
        if(dev){
            dev->uploadCustomIcons(icons);
        }
    }
    catch(int e){
        if(dev == 0) return;
        QMessageBox::warning(0,tr("Device Link Error"),dev->getLastError().c_str(),QMessageBox::Ok,QMessageBox::NoButton);
        if(e == Garmin::errSync){
            gpResources->resetDevice();
        }
    }

}

void CDlgCustomIcons::slotChangeOCIcon()
{
    quint16 smbl;
    QPixmap icon;
    QString name;
    QTreeWidgetItem * entry         = listOCIcons->topLevelItem(sender()->objectName().toInt());

    getWptIconByName(entry->text(4),smbl);
    CDlgWptIcon dlg(smbl,0);
    dlg.exec();
    getWptIconById(smbl,icon,name);

    entry->setIcon(0,QIcon(icon));
    entry->setText(4,name);


}

void CDlgCustomIcons::slotResetOCIcon()
{
    QPixmap icon;
    quint16 id;
    QTreeWidgetItem * entry         = listOCIcons->topLevelItem(sender()->objectName().toInt());
    CGarminDBWpt::type_t& cacheIcon = gpResources->wptdb().cacheIcons[sender()->objectName().toInt()];
    if(entry){
        getWptIconByName("Geocache", id, icon);
        entry->setIcon(0,QIcon(icon));

        entry->setText(4,cacheIcon.icon);
    }

}

