/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CCENTRALRESOURCES_H
#define CCENTRALRESOURCES_H

#include <QObject>
#include <QMutex>

#include "CFunctionStateMachine.h"
#include "CCanvas.h"

class CMainWindow;
class CGarminDBMap;
class CGarminDBWpt;
class CGarminDBTrack;
class CGarminDBRoute;
class CGarminLiveLog;
class CViewTrackInfo;

namespace Garmin
{
  class IDevice;
}


/// resource object for easy access to all GUI and data components
/**

*/
class CCentralResources : public QObject
{
    Q_OBJECT
    public:
        CCentralResources(CMainWindow& parent);
        ~CCentralResources();
        /// get access to current canvas object
        CCanvas& canvas(){return *m_pCanvas;}
        /// get access to current map data base
        CGarminDBMap& mapdb(){return *m_pMapDB;}
        /// get access to current waypoint data base
        CGarminDBWpt& wptdb(){return *m_pWptDB;}
        /// get access to current track data base
        CGarminDBTrack& trackdb(){return *m_pTrackDB;}
        /// get access to current live log handler
        CGarminLiveLog& livelog(){return *m_pLiveLog;}
        /// get access to current route data base
        CGarminDBRoute& routedb(){return *m_pRouteDB;}
        /// get access to function statemachine
        CFunctionStateMachine& fsm(){return *m_pFSM;}
        /// handle key events from CMainWidget
        void keyPressEvent(QKeyEvent * e){m_pFSM->keyPressEvent(e);}
        /// get the map's font
        const QFont& getMapFont(){return m_mapfont;}
        /// convert a height value as string into the correct system and add unit
        void convertHeight(QString& val);
        /// get HTTP proxy settings
        /**
            @param url a string to store the proxy's URL
            @param port a 16bit unsigned integer to store the proxy's port

            @return The method will return true if the proxy is enabled.
        */
        bool getHttpProxy(QString& url, quint16& port);

        /// select widget in the lefthand toolbox tabwidget
        void setCurrentToolBoxWidget(QWidget * w);
        /// test for metric or imperial system settings
        bool doMetric(){return m_doMetric;}
        /// open a link in an external browser
        void openLink(const QString& link);
        /// get access to current device driver
        Garmin::IDevice * device();
        /// reset current device driver.
        void resetDevice(){m_DeviceName.clear();}

        /// set time offset to UTC in multiples of hours
        /**
            @param offset the offset in multiple of hours
        */
        void setUTCOffset(int offset);

        uint32_t getUTCOffset(){return time_offset;}

        /// global upload of GPS data
        void upload();
        /// global download of GPS data
        void download();

        const QString distance2str(double distance);

    signals:
        void sigProxyChanged();

    protected:
        friend class CDlgConfig;
        friend class CDlgDevice;

        enum bowser_e   {eFirefox = 0
                        ,eKonqueror = 1
                        ,eOther = 2
                        };

        CMainWindow& main;
        /// the canvas widget to display the map
        CCanvas * m_pCanvas;
        /// statemachine and widget to handle F-key input
        CFunctionStateMachine * m_pFSM;
        /// keep track of all registered maps and the current displayed map
        CGarminDBMap * m_pMapDB;
        /// manage all waypoints
        CGarminDBWpt * m_pWptDB;
        /// manage all track data
        CGarminDBTrack * m_pTrackDB;
        /// control real time position data from the GPSr
        CGarminLiveLog * m_pLiveLog;
        /// manage all distance measurement and route data
        CGarminDBRoute * m_pRouteDB;

        /// font used by the map
        QFont m_mapfont;
        /// true for metric system, false for imperial
        bool m_doMetric;

        /// use proxy for http requests
        bool m_useHttpProxy;
        /// the  proxy name or address
        QString m_httpProxy;
        /// the proxy port
        quint16 m_httpProxyPort;
        /// offset to UTC in multiples of hours
        quint32 m_offsetUTC;

        /// the installed browser type
        bowser_e m_eBrowser;
        /// command string to start Firefox
        QString cmdFirefox;
        /// command string to start Konqueror
        QString cmdKonqueror;
        /// user defined command string
        QString cmdOther;

        /// the device string to find device driver
        QString m_DeviceName;

        /// this offset is needed to correct time in seconds until Dec. 30th, 1989 12:00 to POSIX standard
        uint32_t time_offset;

        bool uploadMap;
        bool uploadWpt;
        bool uploadRte;
        bool downloadMap;
        bool downloadWpt;
        bool downloadTrk;

        QString altPluginPath;

        QString serialPort;
};

extern CCentralResources * gpResources;

#endif //CCENTRALRESOURCES_H

