/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgScreenshot.h"
#include "CCentralResources.h"
#include "GarminTypedef.h"
#include "Platform.h"
#include <IDevice.h>
#include <QtGui>


CDlgScreenshot::CDlgScreenshot()
{
    setupUi(this);
    connect(butScreenshot,SIGNAL(pressed()),this,SLOT(slotScreenshot()));
    connect(butSave,SIGNAL(pressed()),this,SLOT(slotSave()));
}


CDlgScreenshot::~CDlgScreenshot()
{

}


void CDlgScreenshot::slotScreenshot()
{
    char *  clrtbl  = 0;
    char *  data    = 0;
    int     width   = 0;
    int     height  = 0;

    Garmin::IDevice * dev = 0;
    try
    {
        dev = gpResources->device();
        if(dev) {
            dev->screenshot(clrtbl, data, width, height);
        }
    }
    catch(int e) {
        if(dev == 0) return;
        QMessageBox::warning(0,tr("Device Link Error"),dev->getLastError().c_str(),QMessageBox::Ok,QMessageBox::NoButton);
        if(e == Garmin::errSync) {
            gpResources->resetDevice();
        }
    }

    if(data != 0 && clrtbl != 0) {
        /* Hack hack hack - add two dummy bytes at the beginning of the array which are
         * removed below, and let the bmp record start at offs 2.  This shifts all 4-byte
         * data in the record to adresses which are a multiple of 4. */
        QByteArray buffer(sizeof(garmin_bmp_t) + width * height + 2, 0);
        garmin_bmp_t * pBmp = (garmin_bmp_t*)(buffer.data() + 2);
        pBmp->bfType        = gar_endian(uint16_t, 0x4d42);
        pBmp->bfSize        = gar_endian(uint32_t, buffer.size());
        pBmp->bfReserved    = 0;
        pBmp->bfOffBits     = gar_endian(uint32_t, sizeof(garmin_bmp_t));
        pBmp->biSize        = gar_endian(uint32_t, 0x28);
        pBmp->biWidth       = gar_endian(int32_t, width);
        pBmp->biHeight      = gar_endian(int32_t, height);
        pBmp->biPlanes      = gar_endian(uint16_t, 1);
        pBmp->biBitCount    = gar_endian(uint16_t, 8);
        pBmp->biCompression = 0;
        pBmp->biSizeImage   = gar_endian(uint32_t, width * height);
        pBmp->biYPelsPerMeter = 0;
        pBmp->biXPelsPerMeter = 0;
        pBmp->biClrUsed       = gar_endian(uint32_t, 0x100);
        pBmp->biClrImportant  = gar_endian(uint32_t, 0x100);
        memcpy(pBmp->clrtbl,clrtbl,sizeof(pBmp->clrtbl));
        memcpy(pBmp->data,data,width * height);

        QPixmap pixmap;
        pixmap.loadFromData((const uchar *)pBmp, sizeof(garmin_bmp_t) + width * height);
        lblImage->setPixmap(pixmap);
    }
}


void CDlgScreenshot::slotSave()
{
    if(lblImage->pixmap()) {
        QString selectedFilter;
        QSettings cfg;
        cfg.beginGroup( "path" );
        QString lastUsedPath = cfg.value( "screenshot", QDir::home().path() ).toString();
        QImage img = lblImage->pixmap()->toImage();
        QString filename = QFileDialog::getSaveFileName(0,tr("Save screenshot"),lastUsedPath,
            tr("Portable Network Graphics (*.png);;Windows Bitmap (*.bmp);;JPEG Image (*.jpg);;TIFF Image (*.tiff);;Portable Pixmap (*.ppm);;X11 Pixmap (*.xpm);;X11 Bitmap (*.xbm)"),
            &selectedFilter );

        if(filename.isEmpty()) return;

        QFileInfo fname(filename);
        QString ext = fname.suffix().toLower();

        if ( !(ext=="png" || ext=="bmp" || ext=="jpg" || ext=="tiff" || ext=="ppm" || ext=="xpm" || ext=="xbm" ) ) {
            if (selectedFilter.indexOf(".png")>=0)
                filename += ".png";
            else if (selectedFilter.indexOf(".bmp")>=0)
                filename += ".bmp";
            else if (selectedFilter.indexOf(".jpg")>=0)
                filename += ".jpg";
            else if (selectedFilter.indexOf(".tiff")>=0)
                filename += ".tiff";
            else if (selectedFilter.indexOf(".ppm")>=0)
                filename += ".ppm";
            else if (selectedFilter.indexOf(".xpm")>=0)
                filename += ".xpm";
            else if (selectedFilter.indexOf(".xbm")>=0)
                filename += ".xbm";
        }

        bool success = img.save(filename);
        if ( !success ) {        // probably user typed in a nonexisting path
            QString msg = QString(tr("I could not save the screen shot using filename = %1")).arg(filename);
            QMessageBox::warning(0,tr("Error while saving image"),
                msg, QMessageBox::Ok,QMessageBox::NoButton);
        }
        else {
                                 // remember the used path persistently
            cfg.setValue( "screenshot", fname.absoluteFilePath() );
        }
    }
}
