import canvas
import tick_mark
import line_style
import color
import fill_style
import pychart_util
import chart_object
import legend
import sys
import types
import error_bar

fill_style_itr = fill_style.standards.iterate()

_keys = {
    "direction" : (types.StringType, 0, "vertical",
                   """The direction the bars grows. Either 'horizontal'
                   or 'vertical'."""),
    "data" : (pychart_util.AnyType, 1, None, pychart_util.data_desc),
    "data_label_offset": (pychart_util.CoordType, 1, (0, 5),
                          "Location of data label relative to the sample point."),
    "data_label_format": (pychart_util.FormatType, 1, None,
                          """The format string for label printed
                          besides each bar.
                          It can be a `printf' style format string, or 
                          a two-parameter function that takes (x,y) values and
                          returns a string.
                          <<font>>."""),
    "label": (types.StringType, 1, "???", pychart_util.label_desc), 
    "bcol" : (types.IntType, 0, 0,
              """Base (i.e., X when DIRECTION is vertical, Y otherwise)
              value of each bar is extracted this column in data."""),
    "hcol": (types.IntType, 0, 1,
             "Height of each bar is extracted this column in data."),
    "line_style": (line_style.T, 1, line_style.default,
                   "The style of the outer frame of each box."),
    "fill_style": (fill_style.T, 1, lambda: fill_style_itr.next(),
                   "Fill style of each box."),
    "cluster": (types.TupleType, 0, (0, 1), "foo"),
    "width": (pychart_util.NumType, 0, 5, "Width of each box."),
    "cluster_sep": (pychart_util.NumType, 0, 0, "Separation between clustered boxes"),
    "stack_on": (pychart_util.AnyType, 1, None,
                 "Each bar of this plot is stacked on top of the plot specified by this value."),
    "y_min_col": (types.IntType, 1, 2,
                  """The depth of the errorbar is extracted from 
                  this column in data."""),
    "q_min_col":  (types.IntType, 1, None),
    "y_max_col": (types.IntType, 1, None,
                  """The depth of the errorbar is extracted from 
                  this column in data."""),
    "q_max_col":  (types.IntType, 1, None),
    "error_bar": (error_bar.Base, 1, None,
                  "The style of the error bar. <<error_bar>>"),
    }

class T(chart_object.T):
    keys = _keys
    def get_value(self, bval):
        for pair in self.data:
            if pair[self.bcol] == bval:
                if self.stack_on:
                    return self.stack_on.get_value(bval) + pair[self.hcol]
                else:
                    return pair[self.hcol]
	raise ValueError, str(bval) + ": can't find the xval"

    def _get_hrange_sub(self):
        values = []
        for pair in self.data:
            # XXX this thing is pretty slow..
            values.append(self.get_value(pair[self.bcol]))
        return (min(values), max(values))
    
    def get_data_range(self, which):
        if (which == 'X' and self.direction == 'vertical') \
           or self.direction == 'horizontal':
            return pychart_util.get_data_range(self.data, self.bcol)
        else:
            return self._get_hrange_sub()
        
    def draw_vertical(self, ar):
        for pair in self.data:
            xval = pair[self.bcol]
            yval = pair[self.hcol]

            ybot = 0
            if self.stack_on:
                ybot = self.stack_on.get_value(xval)
                yval = yval + ybot

            totalWidth = (self.width+self.cluster_sep) * self.cluster[1] - self.cluster_sep
            firstX = ar.x_pos(xval) - totalWidth/2.0
            thisX = firstX + (self.width+self.cluster_sep) * self.cluster[0] - self.cluster_sep

	    clipping = 0
	    if ar.y_zap and yval >= ar.y_zap[0] \
		and ybot < ar.y_zap[1]:
		clipping = 1
		canvas.beginZigZagClip(thisX+self.width/2.0, 
				   ar.y_pos(ar.y_zap[0]+ar.y_zap[1])/2.0, 10)

            canvas.rectangle(self.line_style, self.fill_style,
                         thisX, ar.y_pos(ybot), thisX+self.width, 
			 ar.y_pos(yval))

            if self.error_bar:
                plus = pair[self.y_min_col or self.y_max_col]
                minus = pair[self.y_max_col or self.y_min_col]
                if self.q_min_col or self.q_max_col:
                    qplus = pair[self.q_min_col or self.q_max_col]
                    qminus = pair[self.q_max_col or self.q_min_col]
                    self.error_bar.draw((thisX+self.width/2.0, ar.y_pos(yval)),
                                       ar.y_pos(yval - qminus),
                                       ar.y_pos(yval + qplus),
                                       ar.y_pos(yval - minus),
                                       ar.y_pos(yval + plus))
                else:
                    self.error_bar.draw((thisX+self.width/2.0, ar.y_pos(yval)),
                                       ar.y_pos(yval - minus),
                                       ar.y_pos(yval + plus))
                    
            if clipping:
		canvas.endZigZagClip()    
            if self.data_label_format:
                canvas.show(thisX + self.width/2.0 + self.data_label_offset[0],
                            ar.y_pos(yval) + self.data_label_offset[1],
                            "/hC" + pychart_util.apply_format(self.data_label_format, (pair[self.bcol], pair[self.hcol]), 1))
	    
    def draw_horizontal(self, ar):
        for pair in self.data:
            yval = pair[self.bcol]
            xval = pair[self.hcol]

            xbot = 0
            if self.stack_on:
                xbot = self.stack_on.get_value(yval)
                xval = xval + xbot

            totalWidth = (self.width+self.cluster_sep) * self.cluster[1] - self.cluster_sep
            firstY = ar.y_pos(yval) - totalWidth/2.0
            thisY = firstY + (self.width+self.cluster_sep) * self.cluster[0] - self.cluster_sep
            canvas.rectangle(self.line_style, self.fill_style,
                             ar.x_pos(xbot), thisY,
                             ar.x_pos(xval), thisY+self.width)
    def get_legend_entry(self):
        if self.label:
            return legend.Entry(line_style=self.line_style,
                                fill_style=self.fill_style,
                                label=self.label)
        return None
        
    def draw(self, ar):
	self.type_check()
        canvas.clip(ar.loc[0], ar.loc[1],
                ar.loc[0] + ar.size[0], ar.loc[1] + ar.size[1])
            
        if self.direction == "vertical":
            self.draw_vertical(ar)
        else:
            self.draw_horizontal(ar)

        canvas.endclip()

