import os
import re
import string

use_color=0
scale_factor = 1
output_format="unknown"   # "ps" or "pdf"
compress_output = 1
output_file = ""

default_font_family = "Helvetica"
default_font_size = 9
default_font_line_height = 9
default_font_halign = "L"
default_font_valign = "B"
default_font_angle = 0
default_line_width = 0.4

debug_level = 1

def parse_yesno(str):
    if str in ("yes", "true", "1"):
        return 1
    else:
        return 0
    
def tufte_style():
    white_line = line_style.T(color=color.white)
    chart_object.set_defaults(area.T,
                              x_grid_style = white_line,
                              y_grid_style = white_line,
                              x_grid_over_plot = 1,
                              y_grid_over_plot = 1)

if os.environ.has_key("PYCHART_OPTIONS"):
    for opt in string.split(os.environ["PYCHART_OPTIONS"]):
        arg = string.split(opt, "=")
        if arg[0] == "format":
            if arg[1] == "ps":
                output_format = "ps"
            elif arg[1] == "pdf-nocompress":
                output_format = "pdf"
                compress_output = 0
            elif arg[1] in ("pdf-compress", "pdf"):
                output_format = "pdf"
                compress_output = 1
            else:
                raise ValueError, "Unknown output option: " + str(arg)
	elif arg[0] == "output":
	    output_file = arg[1]
	    if output_format == "unknown":
		if re.search("\\.pdf$", output_file):
		    output_format = "pdf"
		    compress_output = 1
		else:
		    output_format = "ps"
        elif arg[0] == "color":
            use_color = parse_yesno(arg[1])
        elif arg[0] == "scale":
            scale_factor = float(arg[1])
        elif arg[0] == "font-family":
            default_font_family = arg[1]
        elif arg[0] == "font-size":
            default_font_size = int(arg[1])
            default_line_height = int(arg[1])            
        elif arg[0] == "line-width":
            default_line_width = int(arg[1])
        elif arg[0] == "debug-level":
            debug_level = int(arg[1])
        
if output_format == "unknown":
    output_format = "ps"
