from pychart import *

data = [(10, 20, 30, 5), (20, 65, 33, 5), (30, 55, 30, 5), (40, 45, 51, 7),
	(50, 25, 27, 3), (60, 75, 30, 5), (70, 80, 42, 5), (80, 62, 32, 5),
	(90, 42, 39, 5), (100, 32, 39, 4)]

# The attribute y_coord_system="category" tells that the Y axis values
# should be taken from samples, y_category_col'th column of
# y_category_data.  Thus, in this example, Y values will be
# [40,50,60,70,80].
ar = area.T(y_coord_system = 'category', 
            y_category_data = data[3:8], y_category_col = 0,
            x_range = (0,100), 
            x_axis=axis.X(label="X label", tic_interval=20, 
                  grid_interval=20, grid_style=line_style.gray5dash1),
            y_axis=axis.Y(label="Y label"), legend = legend.T(),
            bg_style = fill_style.gray9,
            border_line_style = line_style.default)

# Below call sets the default attributes for all bar plots.
chart_object.set_defaults(bar_plot.T, direction="horizontal", data=data)

ar.add_plot(bar_plot.T(label="foo", cluster=(0,3)))
ar.add_plot(bar_plot.T(label="bar", hcol=2, cluster=(1,3),
                       fill_style=fill_style.diag))
ar.add_plot(bar_plot.T(label="baz", hcol=3, cluster=(2,3),
                       fill_style=fill_style.rdiag))
ar.draw()



