from unittest  import TestCase, TestSuite, main, makeSuite

import sys, os
sys.path.insert(0, os.path.join(os.path.dirname(__file__), os.pardir))
from config import validation
del sys, os

class TestValidation(TestCase):
    def test_inNumericRange(self):
        v = validation.validatorFor('inNumericRange')
        self.failUnlessEqual(v(10, 1, 20), 1)
        self.failUnlessEqual(v('10', 1, 20), 1)
        self.failIfEqual(v(0, 4, 5), 1)

    def test_isPrintable(self):
        v = validation.validatorFor('isPrintable')
        self.failUnlessEqual(v('text'), 1)
        self.failIfEqual(v('\u203'), 1)
        self.failIfEqual(v(10), 1)

    def test_isSSN(self):
        v = validation.validatorFor('isSSN')
        self.failUnlessEqual(v('111223333'), 1)
        self.failUnlessEqual(v('111-22-3333', ignore=r'-'), 1)

    def test_isUSPhoneNumber(self):
        v = validation.validatorFor('isUSPhoneNumber')
        self.failUnlessEqual(v('(212) 555-1212',
                               ignore=r'[\s\(\)\-]'), 1)
        self.failUnlessEqual(v('2125551212',
                               ignore=r'[\s\(\)\-]'), 1)

        self.failUnlessEqual(v('(212) 555-1212'), 1)


    def test_isURL(self):
        v = validation.validatorFor('isURL')
        self.failUnlessEqual(v('http://foo.bar:8080/manage'), 1)
        self.failIfEqual(v('http://\n'), 1)
        self.failIfEqual(v('../foo/bar'), 1)


    def test_isEmail(self):
        v = validation.validatorFor('isEmail')
        self.failUnlessEqual(v('test@test.com'), 1)
        self.failIfEqual(v('@foo.bar'), 1)
        self.failIfEqual(v('me'), 1)

def test_suite():
    return TestSuite([
        makeSuite(TestValidation),
        ])


if __name__=='__main__':
    main(defaultTest='test_suite')
