#!/usr/bin/env python

import sys, string, commands, xml.dom.minidom
from xml.xslt.Processor import Processor
 
class XdocError(Exception):
   def __init__(self, mesg):
      self.mesg = mesg

   def __str__(self):
      return self.mesg

class Xdoc:
   def __init__(self, module, style='xdoc.xsl'):
      self.mod = __import__( module )
      self.dom = xml.dom.minidom.Document()
      try:
         xsl = open( style )
         self.xsl = xsl.read()
         xsl.close()
      except:
         raise XdocError( 'could not read style sheet' )

      self.preserve = [ 'funcprototype', 'para', 'programlisting', 'title', 'classsynopsis' ]

   def transform(self):
      fragments = ''
      try:
         for doc in self.mod.__doclist__():
            fragments += doc
      except Exception, e:
         raise XdocError( 'could not extract docset')

      document = '<docset>' + fragments + '</docset>' 
      debug = open( 'fragments.xml', 'w' )
      debug.write( document )
      debug.close()
      processor = Processor()
      processor.appendStylesheetUri('xdoc.xsl')
      return processor.runUri('fragments.xml')

   def _removeWhiteSpace(self, node):
      killlist = []
      for i in range( len(node.childNodes) ):
         if node.childNodes[i].nodeName not in self.preserve:
            if node.childNodes[i].hasChildNodes():
               self._removeWhiteSpace( node.childNodes[i] )
            if node.childNodes[i].nodeType == xml.dom.Node.TEXT_NODE:
               node.replaceChild( self.dom.createTextNode(
                        string.strip( node.childNodes[i].nodeValue ) ), node.childNodes[i] )
               if not node.childNodes[i].nodeValue:
                  killlist.append(i)

      for i in range( len(killlist) ):
         target = node.childNodes[ killlist[i] -i ] # ok this if totally whack but we need 
                                                    # to take into account
                                                    # the shrinking list of
                                                    # childNodes!
         node.removeChild( target )
         target.unlink()

   def _prettyWhiteNodePad(self, document, node, depth=1):
      for child in node.childNodes:
            if child.nodeName not in self.preserve:
               self._prettyWhiteNodePad( document, child, depth+1 )

      skip = 0
      for child in node.childNodes:
         if skip:
            skip = skip-1
         else:
            skip = 2
            node.insertBefore( document.createTextNode('\n'+' '*2*depth), child)
            if child.nextSibling:
               node.insertBefore( document.createTextNode(' '*2*(depth)), child.nextSibling)
            else:
               node.appendChild( document.createTextNode('\n'+' '*2*(depth-1)) )

   def format(self):
      dom = xml.dom.minidom.parseString( self.transform() )
      self._removeWhiteSpace( dom.documentElement )
      self._prettyWhiteNodePad( dom, dom.documentElement )
      return dom.toxml()

if len( sys.argv ) < 2:
   raise XdocError( '2 argument are required: xsl stylesheet and module name' )

if len( sys.argv ) == 2:
   x = Xdoc( sys.argv[1] )
else:
   x = Xdoc( sys.argv[1], sys.argv[2] )
xmldoc = x.format()
lines = xmldoc.splitlines()
lines[0] = '<!DOCTYPE article PUBLIC "-//OASIS//DTD DocBook V4.1//EN">'
line = string.join( lines, '\n' )
line = line.replace( '/>','>' )

file = open( sys.argv[1]+'.sgm', 'w' )
file.write(line)
file.close()
