#!/www/python/bin/python

__revision__ = "$Id: test_basics.py,v 1.1 2001/12/10 18:00:19 gward Exp $"

from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE

options = [Option("-a", type="string", dest='a'),
           Option("-b", "--boo", type="int", dest='boo'),
           Option("--foo", action="append", type="string", dest='foo'),
          ]

parser = OptionParser(usage=SUPPRESS_USAGE, option_list=options)

args = []
(values, args) = parser.parse_args(args)
assert values.a is None
assert values.boo is None
assert values.foo is None
assert len(vars(values)) == 3
assert args == []
print "ok: 1"

args = ["-a"]
try:
    (values, args) = parser.parse_args(args)
except SystemExit, err:
    assert err.args[0].endswith("-a option requires a value"), err.args[0]
    print "ok: 2"
else:
    print "not ok"

(values, args) = parser.parse_args(["-a", "", "--foo=blah", "--foo="])
assert vars(values) == {'a': "",
                        'boo': None,
                        'foo': ["blah", ""]}, vars(values)
assert args == []
print "ok: 3"

(values, args) = parser.parse_args(["--foo", "bar", "--foo", "", "--foo=x"])
assert vars(values) == {'a': None,
                        'boo': None,
                        'foo': ["bar", "", "x"]}, vars(values)
assert args == []
print "ok: 4"

args = ["-abc"]
(values, args) = parser.parse_args(args)
assert vars(values) == {'a': "bc",
                        'boo': None,
                        'foo': None}, vars(values)
assert args == []
print "ok: 5"

args = ["-a", "34"]
(values, args) = parser.parse_args(args)
assert vars(values) == {'a': "34",
                        'boo': None,
                        'foo': None}, vars(values)
assert args == []
print "ok: 6"

args = ["-b34"]
(values, args) = parser.parse_args(args)
assert vars(values) == {'a': None,
                        'boo': 34,
                        'foo': None}, vars(values)
assert args == []
print "ok: 7"

args = ["-b", "-5"]
(values, args) = parser.parse_args(args)
assert vars(values) == {'a': None,
                        'boo': -5,
                        'foo': None}, vars(values)
assert args == []
print "ok: 8"

args = ["-b", "5x"]
try:
    (values, args) = parser.parse_args(args)
except SystemExit, err:
    assert err.args[0].endswith("option -b: invalid integer value: '5x'"), \
           err.args[0]
    print "ok: 9"
else:
    print "not ok"

(values, args) = parser.parse_args(["--boo=13"])
assert vars(values) == {'a': None,
                        'boo': 13,
                        'foo': None}
assert args == []
print "ok: 10"

(values, args) = parser.parse_args(["--boo", "111"])
assert vars(values) == {'a': None,
                        'boo': 111,
                        'foo': None}
assert args == []
print "ok: 11"

try:
    (values, args) = parser.parse_args(["--boo13"])
except SystemExit, err:
    assert err.args[0].endswith("no such option: --boo13"), err.args[0]
    print "ok: 12"
else:
    print "not ok"

try:
    (values, args) = parser.parse_args(["--boo=x5"])
except SystemExit, err:
    assert err.args[0].endswith("option --boo: invalid integer value: 'x5'"), \
           err.args[0]
    print "ok: 13"
else:
    print "not ok"

(values, args) = parser.parse_args(["--foo=bar", "-axyz"])
assert values.foo == ["bar"]
assert values.a == "xyz"
assert values.boo is None
assert args == []
print "ok: 14"

(values, args) = parser.parse_args(["--f=bar", "-axyz"])
assert values.foo == ["bar"]
assert values.a == "xyz"
assert values.boo is None
assert args == []
print "ok: 15"

parser.add_option("--foz", action="store", type="string", dest="foo")
try:
    parser.parse_args(["--f=bar"])
except SystemExit, err:
    assert err.args[0].endswith("ambiguous option: --f (--foo, --foz, ...?)"),\
           err.args[0]
    print "ok: 16"
else:
    print "not ok"
    

(values, args) = parser.parse_args(["-a", "xyz", "--foo", "bar"])
assert values.foo == ["bar"]
assert values.a == "xyz"
assert values.boo is None
assert args == []
print "ok: 17"

(values, args) = parser.parse_args(["--foo=bar", "-b", "123", "--foo", "baz"])
assert values.foo == ["bar", "baz"]
assert values.a == None
assert values.boo == 123, `values.boo`
assert args == []
print "ok: 18"

(values, args) = parser.parse_args(["-a", "foo", "bar"])
assert vars(values) == {'a': "foo",
                        'boo': None,
                        'foo': None}
assert args == ["bar"]
print "ok: 19"


(values, args) = parser.parse_args(["-a", "--", "foo", "bar"])
assert vars(values) == {'a': "--",
                        'boo': None,
                        'foo': None}
assert args == ["foo", "bar"]
print "ok: 20"

(values, args) = parser.parse_args(["-ab", "--", "--foo", "bar"])
assert vars(values) == {'a': "b",
                        'boo': None,
                        'foo': None}
assert args == ["--foo", "bar"], args
print "ok: 21"

(values, args) = parser.parse_args(["-ab", "-", "--foo", "bar"])
assert vars(values) == {'a': "b",
                        'boo': None,
                        'foo': ["bar"]}
assert args == ["-"]
print "ok: 22"

args = ["-b3", "-b", "5", "--foo=bar", "--foo", "baz"]
(values, args) = parser.parse_args(args)
assert vars(values) == {'a': None,
                        'boo': 5,
                        'foo': ["bar", "baz"]}
assert args == []
print "ok: 23"

(values, args) = parser.parse_args(["-a", "-b3"])
assert vars(values) == {'a': "-b3",
                        'boo': None,
                        'foo': None}
assert args == []
print "ok: 24"

