#!/usr/bin/perl

use Data::Dumper;
use Net::Snort::Parser::Rule;

$Data::Dumper::Pad = "# ";

$| = 1; 
while(<DATA>) {
    chomp;
    next if /^#/;
    next if /^\s*$/;
    push (@tests,$_);
}

print "1.." . scalar(@tests) . "\n"; 
my $obj = Net::Snort::Parser::Rule->new();


for (my $i = 0; $i <= $#tests; $i++) {
    my ($type, $rule) = split(/\s+\|\|\s+/,$tests[$i],2);
    my $result = $obj->parse_rule($rule);
    if ($type eq 'good' && !defined($result->{'failed'})) {
        print "ok " . ($i+1) . "\n";
    } elsif ($type eq 'bad' && (!defined($result) || defined($result->{'failed'}))) {
        print "ok " . ($i+1) ."\n";
    } else {
        print Dumper($result);
        print "not ok " . ($i+1) ."\n";
    }
}

__DATA__
# basic rule
good || alert tcp $VAR 1 -> $VAR2 2 (flow:to_server; content:"hi|20|there"; dsize:40; offset:10; sid:1776; rev:1;)

# bad hex content
bad || alert tcp any any -> any any (content:"foo|";)

# bad protocol
bad || alert badproto any any -> any 3306 (content:"foo";)

# attempt to use flow in udp rule
bad || alert udp any any -> any 3306 (flow:to_server,established;)

# no closing (
bad || alert udp any any -> any 3306 (content:"foo";

# relative and non relative for the same content
bad || alert udp any any -> any 3306 (content:"bar"; content:"foo"; depth:1; distance:10;)

# relative and non relative for the same content
bad || alert udp any any -> any 3306 (content:"bar"; content:"foo"; offset:1; distance:10;)

# ref with backticked ; 
good || alert ip any any -> any any (reference:url,support.microsoft.com/default.aspx?scid=kb\;EN-US\;q138268;)

# rule with invalid sid 
bad || alert ip any any -> any 1 (sid:a;)

# rule with invalid rev
bad || alert ip any any -> any 2 (rev:b;)

# rule with multiple sids
bad || alert ip any any -> any 3 (sid:1; sid:2;)

# rule with multiple revs 
bad || alert ip any any -> any 4 (rev:1; rev:2;)

# rule with multiple classtypes 
bad || alert ip any any -> any 5 (classtype:1; classtype:2;)

# rule with multiple messages 
bad || alert ip any any -> any 6 (msg:"foo"; msg:"foo2";)

# rule with semi-colon in message
bad || alert ip any any -> any any (msg:"foo\;foo";)

good || alert tcp any 512 -> any any (msg:"ATTACK-RESPONSES rexec username too long response"; flow:from_server,established; content:"username too long"; offset:0; depth:17; classtype:unsuccessful-user; sid:2104; rev:2;)

good || alert tcp any any -> any any (msg:"WEB-CGI ads.cgi command execution attempt"; flow:to_server,established; uricontent:"/ads.cgi"; nocase; content:"file="; nocase; content:"../../"; content:"\|"; reference:cve,CAN-2001-0025; reference:bugtraq,2103; classtype:web-application-attack; sid:1053; rev:7;)

good || alert tcp any any -> $EXTERNAL_NET any (content: "a"; depth:1; stateless;)

good || alert tcp any any -> any any (content:!"1"; depth:1; stateless;)

good || alert tcp any any -> any any (content:"0"; stateless;)

bad || alert tcp any any -> any any (content:"0";)

bad || alert tcp any any -> any any (reference:cve,CAN-2000-2000; reference:cve,CAN-2000-2000;)

# rule with ( in message
bad || alert tcp any any -> any any (msg:"foo(";);

# rule with : in message
bad || alert tcp any any -> any any (msg:"foo:";);

# flow & stateless
bad || alert tcp any any -> any any (flow:stateless; stateless;)

# stateless & flow
bad || alert tcp any any -> any any (stateless; flow:stateless;)
