use 5.006000;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'EXE_FILES'    => [qw(snortconfig)],
    'NAME'         => 'Net::Snort::Parser',
    'VERSION_FROM' => 'Snort/Parser/Rule.pm',
    'PREREQ_PM'    => {},                       # e.g., Module::Name => 1.1
    'PM'           => {
        'Snort/Parser/File.pm' => '$(INST_LIBDIR)/Parser/File.pm',
        'Snort/Parser/Rule.pm' => '$(INST_LIBDIR)/Parser/Rule.pm',
    },
    'MAN1PODS' => {
        'snortconfig' => '$(INST_MAN1DIR)/snortconfig.1',
    },
    'MAN3PODS' => {
        'Snort/Parser/File.pm' => '$(INST_MAN3DIR)/Net::Snort::Parser::File.3',
        'Snort/Parser/Rule.pm' => '$(INST_MAN3DIR)/Net::Snort::Parser::Rule.3',
    },
    'realclean' => {FILES => '$(DISTNAME)-$(VERSION).tar.gz*'},
    'dist'      => {
        'SUFFIX'       => ".gz",
        'DIST_DEFAULT' => 'all tardist sign',
        'COMPRESS'     => "gzip -9vf"
    },
    ($] >= 5.005
    ?    ## Add these new keywords supported since 5.005
      (AUTHOR => 'Brian Caswell <bmc@shmoo.com>')
    : ()),
);

sub MY::postamble {
    q{
sign::
	gpg -a --detach-sign $(DISTNAME)-$(VERSION).tar.gz
}
}
