use ExtUtils::MakeMaker;

WriteMakefile
(
 'NAME'      => 'NDiff',
 'PM' => 
 {
     'DataStore.pm'       => '$(INST_LIBDIR)/PortScan/DataStore.pm',
     'NmapFile.pm'        => '$(INST_LIBDIR)/PortScan/NmapFile.pm',
     'PortSpec.pm'        => '$(INST_LIBDIR)/PortScan/PortSpec.pm',
     'ScanComparison.pm'  => '$(INST_LIBDIR)/PortScan/ScanComparison.pm',
     'ScanContext.pm'     => '$(INST_LIBDIR)/PortScan/ScanContext.pm',
     'ScanSet.pm'         => '$(INST_LIBDIR)/PortScan/ScanSet.pm',
     'ScannedHost.pm'     => '$(INST_LIBDIR)/PortScan/ScannedHost.pm',
     'SetOps.pm'          => '$(INST_LIBDIR)/PortScan/SetOps.pm',
     'ndiff.conf.sample'  => '$(INST_LIBDIR)/PortScan/ndiff.conf.sample',
 },
 EXE_FILES => [ "ndiff", "ngen", "nrun", "ndiff2html" ],
 MAN3PODS => { "NDiff_Quickstart.pod" => '$(INST_MAN3DIR)/NDiff_Quickstart.3' },
 NEEDS_LINKING => 0,
 VERSION => '0.04',
 ($] ge '5.005')
 ? (
    AUTHOR => 'James Levine (jdl@vinecorp.com)',
    ABSTRACT
    => 'Tools for storing/retrieving results of nmap scans, and generating deltas between them.',
    )
 : (),
 );                    






#        'dist' => {COMPRESS => 'gzip -9f', SUFFIX => 'gz'},
#    'VERSION_FROM' => '', # finds $VERSION





