/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "fame.h"

static const fame_vlc_t encode_ydc_table[511] = {
	{ 0x100, 15 },
	{ 0x101, 15 },
	{ 0x102, 15 },
	{ 0x103, 15 },
	{ 0x104, 15 },
	{ 0x105, 15 },
	{ 0x106, 15 },
	{ 0x107, 15 },
	{ 0x108, 15 },
	{ 0x109, 15 },
	{ 0x10a, 15 },
	{ 0x10b, 15 },
	{ 0x10c, 15 },
	{ 0x10d, 15 },
	{ 0x10e, 15 },
	{ 0x10f, 15 },
	{ 0x110, 15 },
	{ 0x111, 15 },
	{ 0x112, 15 },
	{ 0x113, 15 },
	{ 0x114, 15 },
	{ 0x115, 15 },
	{ 0x116, 15 },
	{ 0x117, 15 },
	{ 0x118, 15 },
	{ 0x119, 15 },
	{ 0x11a, 15 },
	{ 0x11b, 15 },
	{ 0x11c, 15 },
	{ 0x11d, 15 },
	{ 0x11e, 15 },
	{ 0x11f, 15 },
	{ 0x120, 15 },
	{ 0x121, 15 },
	{ 0x122, 15 },
	{ 0x123, 15 },
	{ 0x124, 15 },
	{ 0x125, 15 },
	{ 0x126, 15 },
	{ 0x127, 15 },
	{ 0x128, 15 },
	{ 0x129, 15 },
	{ 0x12a, 15 },
	{ 0x12b, 15 },
	{ 0x12c, 15 },
	{ 0x12d, 15 },
	{ 0x12e, 15 },
	{ 0x12f, 15 },
	{ 0x130, 15 },
	{ 0x131, 15 },
	{ 0x132, 15 },
	{ 0x133, 15 },
	{ 0x134, 15 },
	{ 0x135, 15 },
	{ 0x136, 15 },
	{ 0x137, 15 },
	{ 0x138, 15 },
	{ 0x139, 15 },
	{ 0x13a, 15 },
	{ 0x13b, 15 },
	{ 0x13c, 15 },
	{ 0x13d, 15 },
	{ 0x13e, 15 },
	{ 0x13f, 15 },
	{ 0x140, 15 },
	{ 0x141, 15 },
	{ 0x142, 15 },
	{ 0x143, 15 },
	{ 0x144, 15 },
	{ 0x145, 15 },
	{ 0x146, 15 },
	{ 0x147, 15 },
	{ 0x148, 15 },
	{ 0x149, 15 },
	{ 0x14a, 15 },
	{ 0x14b, 15 },
	{ 0x14c, 15 },
	{ 0x14d, 15 },
	{ 0x14e, 15 },
	{ 0x14f, 15 },
	{ 0x150, 15 },
	{ 0x151, 15 },
	{ 0x152, 15 },
	{ 0x153, 15 },
	{ 0x154, 15 },
	{ 0x155, 15 },
	{ 0x156, 15 },
	{ 0x157, 15 },
	{ 0x158, 15 },
	{ 0x159, 15 },
	{ 0x15a, 15 },
	{ 0x15b, 15 },
	{ 0x15c, 15 },
	{ 0x15d, 15 },
	{ 0x15e, 15 },
	{ 0x15f, 15 },
	{ 0x160, 15 },
	{ 0x161, 15 },
	{ 0x162, 15 },
	{ 0x163, 15 },
	{ 0x164, 15 },
	{ 0x165, 15 },
	{ 0x166, 15 },
	{ 0x167, 15 },
	{ 0x168, 15 },
	{ 0x169, 15 },
	{ 0x16a, 15 },
	{ 0x16b, 15 },
	{ 0x16c, 15 },
	{ 0x16d, 15 },
	{ 0x16e, 15 },
	{ 0x16f, 15 },
	{ 0x170, 15 },
	{ 0x171, 15 },
	{ 0x172, 15 },
	{ 0x173, 15 },
	{ 0x174, 15 },
	{ 0x175, 15 },
	{ 0x176, 15 },
	{ 0x177, 15 },
	{ 0x178, 15 },
	{ 0x179, 15 },
	{ 0x17a, 15 },
	{ 0x17b, 15 },
	{ 0x17c, 15 },
	{ 0x17d, 15 },
	{ 0x17e, 15 },
	{ 0x17f, 15 },/* -128 */
	{ 0x80, 13 },
	{ 0x81, 13 },
	{ 0x82, 13 },
	{ 0x83, 13 },
	{ 0x84, 13 },
	{ 0x85, 13 },
	{ 0x86, 13 },
	{ 0x87, 13 },
	{ 0x88, 13 },
	{ 0x89, 13 },
	{ 0x8a, 13 },
	{ 0x8b, 13 },
	{ 0x8c, 13 },
	{ 0x8d, 13 },
	{ 0x8e, 13 },
	{ 0x8f, 13 },
	{ 0x90, 13 },
	{ 0x91, 13 },
	{ 0x92, 13 },
	{ 0x93, 13 },
	{ 0x94, 13 },
	{ 0x95, 13 },
	{ 0x96, 13 },
	{ 0x97, 13 },
	{ 0x98, 13 },
	{ 0x99, 13 },
	{ 0x9a, 13 },
	{ 0x9b, 13 },
	{ 0x9c, 13 },
	{ 0x9d, 13 },
	{ 0x9e, 13 },
	{ 0x9f, 13 },
	{ 0xa0, 13 },
	{ 0xa1, 13 },
	{ 0xa2, 13 },
	{ 0xa3, 13 },
	{ 0xa4, 13 },
	{ 0xa5, 13 },
	{ 0xa6, 13 },
	{ 0xa7, 13 },
	{ 0xa8, 13 },
	{ 0xa9, 13 },
	{ 0xaa, 13 },
	{ 0xab, 13 },
	{ 0xac, 13 },
	{ 0xad, 13 },
	{ 0xae, 13 },
	{ 0xaf, 13 },
	{ 0xb0, 13 },
	{ 0xb1, 13 },
	{ 0xb2, 13 },
	{ 0xb3, 13 },
	{ 0xb4, 13 },
	{ 0xb5, 13 },
	{ 0xb6, 13 },
	{ 0xb7, 13 },
	{ 0xb8, 13 },
	{ 0xb9, 13 },
	{ 0xba, 13 },
	{ 0xbb, 13 },
	{ 0xbc, 13 },
	{ 0xbd, 13 },
	{ 0xbe, 13 },
	{ 0xbf, 13 },/* -64 */
	{ 0x40, 11 },
	{ 0x41, 11 },
	{ 0x42, 11 },
	{ 0x43, 11 },
	{ 0x44, 11 },
	{ 0x45, 11 },
	{ 0x46, 11 },
	{ 0x47, 11 },
	{ 0x48, 11 },
	{ 0x49, 11 },
	{ 0x4a, 11 },
	{ 0x4b, 11 },
	{ 0x4c, 11 },
	{ 0x4d, 11 },
	{ 0x4e, 11 },
	{ 0x4f, 11 },
	{ 0x50, 11 },
	{ 0x51, 11 },
	{ 0x52, 11 },
	{ 0x53, 11 },
	{ 0x54, 11 },
	{ 0x55, 11 },
	{ 0x56, 11 },
	{ 0x57, 11 },
	{ 0x58, 11 },
	{ 0x59, 11 },
	{ 0x5a, 11 },
	{ 0x5b, 11 },
	{ 0x5c, 11 },
	{ 0x5d, 11 },
	{ 0x5e, 11 },
	{ 0x5f, 11 },/* -32 */
	{ 0x20, 9 }, /* -31 */
	{ 0x21, 9 }, /* -30 */
	{ 0x22, 9 }, /* -29 */
	{ 0x23, 9 }, /* -28 */
	{ 0x24, 9 }, /* -27 */
	{ 0x25, 9 }, /* -26 */
	{ 0x26, 9 }, /* -25 */
	{ 0x27, 9 }, /* -24 */
	{ 0x28, 9 }, /* -23 */
	{ 0x29, 9 }, /* -22 */
	{ 0x2a, 9 }, /* -21 */
	{ 0x2b, 9 }, /* -20 */
	{ 0x2c, 9 }, /* -19 */
	{ 0x2d, 9 }, /* -18 */
	{ 0x2e, 9 }, /* -17 */
	{ 0x2f, 9 }, /* -16 */
	{ 0x10, 7 }, /* -15 */
	{ 0x11, 7 }, /* -14 */
	{ 0x12, 7 }, /* -13 */
	{ 0x13, 7 }, /* -12 */
	{ 0x14, 7 }, /* -11 */
	{ 0x15, 7 }, /* -10 */
	{ 0x16, 7 }, /*  -9 */
	{ 0x17, 7 }, /*  -8 */
	{ 0x10, 6 }, /*  -7 */
	{ 0x11, 6 }, /*  -6 */
	{ 0x12, 6 }, /*  -5 */
	{ 0x13, 6 }, /*  -4 */
	{ 0x08, 4 }, /*  -3 */
	{ 0x09, 4 }, /*  -2 */
	{ 0x06, 3 }, /*  -1 */
	{ 0x03, 3 }, /*   0 */
	{ 0x07, 3 },
	{ 0x0a, 4 },
	{ 0x0b, 4 },
	{ 0x14, 6 },
	{ 0x15, 6 },
	{ 0x16, 6 },
	{ 0x17, 6 },
	{ 0x18, 7 },
	{ 0x19, 7 },
	{ 0x1a, 7 },
	{ 0x1b, 7 },
	{ 0x1c, 7 },
	{ 0x1d, 7 },
	{ 0x1e, 7 },
	{ 0x1f, 7 },
	{ 0x30, 9 },
	{ 0x31, 9 },
	{ 0x32, 9 },
	{ 0x33, 9 },
	{ 0x34, 9 },
	{ 0x35, 9 },
	{ 0x36, 9 },
	{ 0x37, 9 },
	{ 0x38, 9 },
	{ 0x39, 9 },
	{ 0x3a, 9 },
	{ 0x3b, 9 },
	{ 0x3c, 9 },
	{ 0x3d, 9 },
	{ 0x3e, 9 },
	{ 0x3f, 9 },
	{ 0x60, 11 },
	{ 0x61, 11 },
	{ 0x62, 11 },
	{ 0x63, 11 },
	{ 0x64, 11 },
	{ 0x65, 11 },
	{ 0x66, 11 },
	{ 0x67, 11 },
	{ 0x68, 11 },
	{ 0x69, 11 },
	{ 0x6a, 11 },
	{ 0x6b, 11 },
	{ 0x6c, 11 },
	{ 0x6d, 11 },
	{ 0x6e, 11 },
	{ 0x6f, 11 },
	{ 0x70, 11 },
	{ 0x71, 11 },
	{ 0x72, 11 },
	{ 0x73, 11 },
	{ 0x74, 11 },
	{ 0x75, 11 },
	{ 0x76, 11 },
	{ 0x77, 11 },
	{ 0x78, 11 },
	{ 0x79, 11 },
	{ 0x7a, 11 },
	{ 0x7b, 11 },
	{ 0x7c, 11 },
	{ 0x7d, 11 },
	{ 0x7e, 11 },
	{ 0x7f, 11 },
	{ 0xc0, 13 },
	{ 0xc1, 13 },
	{ 0xc2, 13 },
	{ 0xc3, 13 },
	{ 0xc4, 13 },
	{ 0xc5, 13 },
	{ 0xc6, 13 },
	{ 0xc7, 13 },
	{ 0xc8, 13 },
	{ 0xc9, 13 },
	{ 0xca, 13 },
	{ 0xcb, 13 },
	{ 0xcc, 13 },
	{ 0xcd, 13 },
	{ 0xce, 13 },
	{ 0xcf, 13 },
	{ 0xd0, 13 },
	{ 0xd1, 13 },
	{ 0xd2, 13 },
	{ 0xd3, 13 },
	{ 0xd4, 13 },
	{ 0xd5, 13 },
	{ 0xd6, 13 },
	{ 0xd7, 13 },
	{ 0xd8, 13 },
	{ 0xd9, 13 },
	{ 0xda, 13 },
	{ 0xdb, 13 },
	{ 0xdc, 13 },
	{ 0xdd, 13 },
	{ 0xde, 13 },
	{ 0xdf, 13 },
	{ 0xe0, 13 },
	{ 0xe1, 13 },
	{ 0xe2, 13 },
	{ 0xe3, 13 },
	{ 0xe4, 13 },
	{ 0xe5, 13 },
	{ 0xe6, 13 },
	{ 0xe7, 13 },
	{ 0xe8, 13 },
	{ 0xe9, 13 },
	{ 0xea, 13 },
	{ 0xeb, 13 },
	{ 0xec, 13 },
	{ 0xed, 13 },
	{ 0xee, 13 },
	{ 0xef, 13 },
	{ 0xf0, 13 },
	{ 0xf1, 13 },
	{ 0xf2, 13 },
	{ 0xf3, 13 },
	{ 0xf4, 13 },
	{ 0xf5, 13 },
	{ 0xf6, 13 },
	{ 0xf7, 13 },
	{ 0xf8, 13 },
	{ 0xf9, 13 },
	{ 0xfa, 13 },
	{ 0xfb, 13 },
	{ 0xfc, 13 },
	{ 0xfd, 13 },
	{ 0xfe, 13 },
	{ 0xff, 13 },
	{ 0x180, 15 },
	{ 0x181, 15 },
	{ 0x182, 15 },
	{ 0x183, 15 },
	{ 0x184, 15 },
	{ 0x185, 15 },
	{ 0x186, 15 },
	{ 0x187, 15 },
	{ 0x188, 15 },
	{ 0x189, 15 },
	{ 0x18a, 15 },
	{ 0x18b, 15 },
	{ 0x18c, 15 },
	{ 0x18d, 15 },
	{ 0x18e, 15 },
	{ 0x18f, 15 },
	{ 0x190, 15 },
	{ 0x191, 15 },
	{ 0x192, 15 },
	{ 0x193, 15 },
	{ 0x194, 15 },
	{ 0x195, 15 },
	{ 0x196, 15 },
	{ 0x197, 15 },
	{ 0x198, 15 },
	{ 0x199, 15 },
	{ 0x19a, 15 },
	{ 0x19b, 15 },
	{ 0x19c, 15 },
	{ 0x19d, 15 },
	{ 0x19e, 15 },
	{ 0x19f, 15 },
	{ 0x1a0, 15 },
	{ 0x1a1, 15 },
	{ 0x1a2, 15 },
	{ 0x1a3, 15 },
	{ 0x1a4, 15 },
	{ 0x1a5, 15 },
	{ 0x1a6, 15 },
	{ 0x1a7, 15 },
	{ 0x1a8, 15 },
	{ 0x1a9, 15 },
	{ 0x1aa, 15 },
	{ 0x1ab, 15 },
	{ 0x1ac, 15 },
	{ 0x1ad, 15 },
	{ 0x1ae, 15 },
	{ 0x1af, 15 },
	{ 0x1b0, 15 },
	{ 0x1b1, 15 },
	{ 0x1b2, 15 },
	{ 0x1b3, 15 },
	{ 0x1b4, 15 },
	{ 0x1b5, 15 },
	{ 0x1b6, 15 },
	{ 0x1b7, 15 },
	{ 0x1b8, 15 },
	{ 0x1b9, 15 },
	{ 0x1ba, 15 },
	{ 0x1bb, 15 },
	{ 0x1bc, 15 },
	{ 0x1bd, 15 },
	{ 0x1be, 15 },
	{ 0x1bf, 15 },
	{ 0x1c0, 15 },
	{ 0x1c1, 15 },
	{ 0x1c2, 15 },
	{ 0x1c3, 15 },
	{ 0x1c4, 15 },
	{ 0x1c5, 15 },
	{ 0x1c6, 15 },
	{ 0x1c7, 15 },
	{ 0x1c8, 15 },
	{ 0x1c9, 15 },
	{ 0x1ca, 15 },
	{ 0x1cb, 15 },
	{ 0x1cc, 15 },
	{ 0x1cd, 15 },
	{ 0x1ce, 15 },
	{ 0x1cf, 15 },
	{ 0x1d0, 15 },
	{ 0x1d1, 15 },
	{ 0x1d2, 15 },
	{ 0x1d3, 15 },
	{ 0x1d4, 15 },
	{ 0x1d5, 15 },
	{ 0x1d6, 15 },
	{ 0x1d7, 15 },
	{ 0x1d8, 15 },
	{ 0x1d9, 15 },
	{ 0x1da, 15 },
	{ 0x1db, 15 },
	{ 0x1dc, 15 },
	{ 0x1dd, 15 },
	{ 0x1de, 15 },
	{ 0x1df, 15 },
	{ 0x1e0, 15 },
	{ 0x1e1, 15 },
	{ 0x1e2, 15 },
	{ 0x1e3, 15 },
	{ 0x1e4, 15 },
	{ 0x1e5, 15 },
	{ 0x1e6, 15 },
	{ 0x1e7, 15 },
	{ 0x1e8, 15 },
	{ 0x1e9, 15 },
	{ 0x1ea, 15 },
	{ 0x1eb, 15 },
	{ 0x1ec, 15 },
	{ 0x1ed, 15 },
	{ 0x1ee, 15 },
	{ 0x1ef, 15 },
	{ 0x1f0, 15 },
	{ 0x1f1, 15 },
	{ 0x1f2, 15 },
	{ 0x1f3, 15 },
	{ 0x1f4, 15 },
	{ 0x1f5, 15 },
	{ 0x1f6, 15 },
	{ 0x1f7, 15 },
	{ 0x1f8, 15 },
	{ 0x1f9, 15 },
	{ 0x1fa, 15 },
	{ 0x1fb, 15 },
	{ 0x1fc, 15 },
	{ 0x1fd, 15 },
	{ 0x1fe, 15 },
	{ 0x1ff, 15 },
};

static const fame_vlc_t encode_cdc_table[511] = {
	{ 0x100, 16 },
	{ 0x101, 16 },
	{ 0x102, 16 },
	{ 0x103, 16 },
	{ 0x104, 16 },
	{ 0x105, 16 },
	{ 0x106, 16 },
	{ 0x107, 16 },
	{ 0x108, 16 },
	{ 0x109, 16 },
	{ 0x10a, 16 },
	{ 0x10b, 16 },
	{ 0x10c, 16 },
	{ 0x10d, 16 },
	{ 0x10e, 16 },
	{ 0x10f, 16 },
	{ 0x110, 16 },
	{ 0x111, 16 },
	{ 0x112, 16 },
	{ 0x113, 16 },
	{ 0x114, 16 },
	{ 0x115, 16 },
	{ 0x116, 16 },
	{ 0x117, 16 },
	{ 0x118, 16 },
	{ 0x119, 16 },
	{ 0x11a, 16 },
	{ 0x11b, 16 },
	{ 0x11c, 16 },
	{ 0x11d, 16 },
	{ 0x11e, 16 },
	{ 0x11f, 16 },
	{ 0x120, 16 },
	{ 0x121, 16 },
	{ 0x122, 16 },
	{ 0x123, 16 },
	{ 0x124, 16 },
	{ 0x125, 16 },
	{ 0x126, 16 },
	{ 0x127, 16 },
	{ 0x128, 16 },
	{ 0x129, 16 },
	{ 0x12a, 16 },
	{ 0x12b, 16 },
	{ 0x12c, 16 },
	{ 0x12d, 16 },
	{ 0x12e, 16 },
	{ 0x12f, 16 },
	{ 0x130, 16 },
	{ 0x131, 16 },
	{ 0x132, 16 },
	{ 0x133, 16 },
	{ 0x134, 16 },
	{ 0x135, 16 },
	{ 0x136, 16 },
	{ 0x137, 16 },
	{ 0x138, 16 },
	{ 0x139, 16 },
	{ 0x13a, 16 },
	{ 0x13b, 16 },
	{ 0x13c, 16 },
	{ 0x13d, 16 },
	{ 0x13e, 16 },
	{ 0x13f, 16 },
	{ 0x140, 16 },
	{ 0x141, 16 },
	{ 0x142, 16 },
	{ 0x143, 16 },
	{ 0x144, 16 },
	{ 0x145, 16 },
	{ 0x146, 16 },
	{ 0x147, 16 },
	{ 0x148, 16 },
	{ 0x149, 16 },
	{ 0x14a, 16 },
	{ 0x14b, 16 },
	{ 0x14c, 16 },
	{ 0x14d, 16 },
	{ 0x14e, 16 },
	{ 0x14f, 16 },
	{ 0x150, 16 },
	{ 0x151, 16 },
	{ 0x152, 16 },
	{ 0x153, 16 },
	{ 0x154, 16 },
	{ 0x155, 16 },
	{ 0x156, 16 },
	{ 0x157, 16 },
	{ 0x158, 16 },
	{ 0x159, 16 },
	{ 0x15a, 16 },
	{ 0x15b, 16 },
	{ 0x15c, 16 },
	{ 0x15d, 16 },
	{ 0x15e, 16 },
	{ 0x15f, 16 },
	{ 0x160, 16 },
	{ 0x161, 16 },
	{ 0x162, 16 },
	{ 0x163, 16 },
	{ 0x164, 16 },
	{ 0x165, 16 },
	{ 0x166, 16 },
	{ 0x167, 16 },
	{ 0x168, 16 },
	{ 0x169, 16 },
	{ 0x16a, 16 },
	{ 0x16b, 16 },
	{ 0x16c, 16 },
	{ 0x16d, 16 },
	{ 0x16e, 16 },
	{ 0x16f, 16 },
	{ 0x170, 16 },
	{ 0x171, 16 },
	{ 0x172, 16 },
	{ 0x173, 16 },
	{ 0x174, 16 },
	{ 0x175, 16 },
	{ 0x176, 16 },
	{ 0x177, 16 },
	{ 0x178, 16 },
	{ 0x179, 16 },
	{ 0x17a, 16 },
	{ 0x17b, 16 },
	{ 0x17c, 16 },
	{ 0x17d, 16 },
	{ 0x17e, 16 },
	{ 0x17f, 16 },
	{ 0x80, 14 },
	{ 0x81, 14 },
	{ 0x82, 14 },
	{ 0x83, 14 },
	{ 0x84, 14 },
	{ 0x85, 14 },
	{ 0x86, 14 },
	{ 0x87, 14 },
	{ 0x88, 14 },
	{ 0x89, 14 },
	{ 0x8a, 14 },
	{ 0x8b, 14 },
	{ 0x8c, 14 },
	{ 0x8d, 14 },
	{ 0x8e, 14 },
	{ 0x8f, 14 },
	{ 0x90, 14 },
	{ 0x91, 14 },
	{ 0x92, 14 },
	{ 0x93, 14 },
	{ 0x94, 14 },
	{ 0x95, 14 },
	{ 0x96, 14 },
	{ 0x97, 14 },
	{ 0x98, 14 },
	{ 0x99, 14 },
	{ 0x9a, 14 },
	{ 0x9b, 14 },
	{ 0x9c, 14 },
	{ 0x9d, 14 },
	{ 0x9e, 14 },
	{ 0x9f, 14 },
	{ 0xa0, 14 },
	{ 0xa1, 14 },
	{ 0xa2, 14 },
	{ 0xa3, 14 },
	{ 0xa4, 14 },
	{ 0xa5, 14 },
	{ 0xa6, 14 },
	{ 0xa7, 14 },
	{ 0xa8, 14 },
	{ 0xa9, 14 },
	{ 0xaa, 14 },
	{ 0xab, 14 },
	{ 0xac, 14 },
	{ 0xad, 14 },
	{ 0xae, 14 },
	{ 0xaf, 14 },
	{ 0xb0, 14 },
	{ 0xb1, 14 },
	{ 0xb2, 14 },
	{ 0xb3, 14 },
	{ 0xb4, 14 },
	{ 0xb5, 14 },
	{ 0xb6, 14 },
	{ 0xb7, 14 },
	{ 0xb8, 14 },
	{ 0xb9, 14 },
	{ 0xba, 14 },
	{ 0xbb, 14 },
	{ 0xbc, 14 },
	{ 0xbd, 14 },
	{ 0xbe, 14 },
	{ 0xbf, 14 },
	{ 0x40, 12 },
	{ 0x41, 12 },
	{ 0x42, 12 },
	{ 0x43, 12 },
	{ 0x44, 12 },
	{ 0x45, 12 },
	{ 0x46, 12 },
	{ 0x47, 12 },
	{ 0x48, 12 },
	{ 0x49, 12 },
	{ 0x4a, 12 },
	{ 0x4b, 12 },
	{ 0x4c, 12 },
	{ 0x4d, 12 },
	{ 0x4e, 12 },
	{ 0x4f, 12 },
	{ 0x50, 12 },
	{ 0x51, 12 },
	{ 0x52, 12 },
	{ 0x53, 12 },
	{ 0x54, 12 },
	{ 0x55, 12 },
	{ 0x56, 12 },
	{ 0x57, 12 },
	{ 0x58, 12 },
	{ 0x59, 12 },
	{ 0x5a, 12 },
	{ 0x5b, 12 },
	{ 0x5c, 12 },
	{ 0x5d, 12 },
	{ 0x5e, 12 },
	{ 0x5f, 12 },
	{ 0x20, 10 },
	{ 0x21, 10 },
	{ 0x22, 10 },
	{ 0x23, 10 },
	{ 0x24, 10 },
	{ 0x25, 10 },
	{ 0x26, 10 },
	{ 0x27, 10 },
	{ 0x28, 10 },
	{ 0x29, 10 },
	{ 0x2a, 10 },
	{ 0x2b, 10 },
	{ 0x2c, 10 },
	{ 0x2d, 10 },
	{ 0x2e, 10 },
	{ 0x2f, 10 },
	{ 0x10, 8 },
	{ 0x11, 8 },
	{ 0x12, 8 },
	{ 0x13, 8 },
	{ 0x14, 8 },
	{ 0x15, 8 },
	{ 0x16, 8 },
	{ 0x17, 8 },
	{ 0x08, 6 },
	{ 0x09, 6 },
	{ 0x0a, 6 },
	{ 0x0b, 6 },
	{ 0x04, 4 },
	{ 0x05, 4 },
	{ 0x04, 3 },
	{ 0x03, 2 },
	{ 0x05, 3 },
	{ 0x06, 4 },
	{ 0x07, 4 },
	{ 0x0c, 6 },
	{ 0x0d, 6 },
	{ 0x0e, 6 },
	{ 0x0f, 6 },
	{ 0x18, 8 },
	{ 0x19, 8 },
	{ 0x1a, 8 },
	{ 0x1b, 8 },
	{ 0x1c, 8 },
	{ 0x1d, 8 },
	{ 0x1e, 8 },
	{ 0x1f, 8 },
	{ 0x30, 10 },
	{ 0x31, 10 },
	{ 0x32, 10 },
	{ 0x33, 10 },
	{ 0x34, 10 },
	{ 0x35, 10 },
	{ 0x36, 10 },
	{ 0x37, 10 },
	{ 0x38, 10 },
	{ 0x39, 10 },
	{ 0x3a, 10 },
	{ 0x3b, 10 },
	{ 0x3c, 10 },
	{ 0x3d, 10 },
	{ 0x3e, 10 },
	{ 0x3f, 10 },
	{ 0x60, 12 },
	{ 0x61, 12 },
	{ 0x62, 12 },
	{ 0x63, 12 },
	{ 0x64, 12 },
	{ 0x65, 12 },
	{ 0x66, 12 },
	{ 0x67, 12 },
	{ 0x68, 12 },
	{ 0x69, 12 },
	{ 0x6a, 12 },
	{ 0x6b, 12 },
	{ 0x6c, 12 },
	{ 0x6d, 12 },
	{ 0x6e, 12 },
	{ 0x6f, 12 },
	{ 0x70, 12 },
	{ 0x71, 12 },
	{ 0x72, 12 },
	{ 0x73, 12 },
	{ 0x74, 12 },
	{ 0x75, 12 },
	{ 0x76, 12 },
	{ 0x77, 12 },
	{ 0x78, 12 },
	{ 0x79, 12 },
	{ 0x7a, 12 },
	{ 0x7b, 12 },
	{ 0x7c, 12 },
	{ 0x7d, 12 },
	{ 0x7e, 12 },
	{ 0x7f, 12 },
	{ 0xc0, 14 },
	{ 0xc1, 14 },
	{ 0xc2, 14 },
	{ 0xc3, 14 },
	{ 0xc4, 14 },
	{ 0xc5, 14 },
	{ 0xc6, 14 },
	{ 0xc7, 14 },
	{ 0xc8, 14 },
	{ 0xc9, 14 },
	{ 0xca, 14 },
	{ 0xcb, 14 },
	{ 0xcc, 14 },
	{ 0xcd, 14 },
	{ 0xce, 14 },
	{ 0xcf, 14 },
	{ 0xd0, 14 },
	{ 0xd1, 14 },
	{ 0xd2, 14 },
	{ 0xd3, 14 },
	{ 0xd4, 14 },
	{ 0xd5, 14 },
	{ 0xd6, 14 },
	{ 0xd7, 14 },
	{ 0xd8, 14 },
	{ 0xd9, 14 },
	{ 0xda, 14 },
	{ 0xdb, 14 },
	{ 0xdc, 14 },
	{ 0xdd, 14 },
	{ 0xde, 14 },
	{ 0xdf, 14 },
	{ 0xe0, 14 },
	{ 0xe1, 14 },
	{ 0xe2, 14 },
	{ 0xe3, 14 },
	{ 0xe4, 14 },
	{ 0xe5, 14 },
	{ 0xe6, 14 },
	{ 0xe7, 14 },
	{ 0xe8, 14 },
	{ 0xe9, 14 },
	{ 0xea, 14 },
	{ 0xeb, 14 },
	{ 0xec, 14 },
	{ 0xed, 14 },
	{ 0xee, 14 },
	{ 0xef, 14 },
	{ 0xf0, 14 },
	{ 0xf1, 14 },
	{ 0xf2, 14 },
	{ 0xf3, 14 },
	{ 0xf4, 14 },
	{ 0xf5, 14 },
	{ 0xf6, 14 },
	{ 0xf7, 14 },
	{ 0xf8, 14 },
	{ 0xf9, 14 },
	{ 0xfa, 14 },
	{ 0xfb, 14 },
	{ 0xfc, 14 },
	{ 0xfd, 14 },
	{ 0xfe, 14 },
	{ 0xff, 14 },
	{ 0x180, 16 },
	{ 0x181, 16 },
	{ 0x182, 16 },
	{ 0x183, 16 },
	{ 0x184, 16 },
	{ 0x185, 16 },
	{ 0x186, 16 },
	{ 0x187, 16 },
	{ 0x188, 16 },
	{ 0x189, 16 },
	{ 0x18a, 16 },
	{ 0x18b, 16 },
	{ 0x18c, 16 },
	{ 0x18d, 16 },
	{ 0x18e, 16 },
	{ 0x18f, 16 },
	{ 0x190, 16 },
	{ 0x191, 16 },
	{ 0x192, 16 },
	{ 0x193, 16 },
	{ 0x194, 16 },
	{ 0x195, 16 },
	{ 0x196, 16 },
	{ 0x197, 16 },
	{ 0x198, 16 },
	{ 0x199, 16 },
	{ 0x19a, 16 },
	{ 0x19b, 16 },
	{ 0x19c, 16 },
	{ 0x19d, 16 },
	{ 0x19e, 16 },
	{ 0x19f, 16 },
	{ 0x1a0, 16 },
	{ 0x1a1, 16 },
	{ 0x1a2, 16 },
	{ 0x1a3, 16 },
	{ 0x1a4, 16 },
	{ 0x1a5, 16 },
	{ 0x1a6, 16 },
	{ 0x1a7, 16 },
	{ 0x1a8, 16 },
	{ 0x1a9, 16 },
	{ 0x1aa, 16 },
	{ 0x1ab, 16 },
	{ 0x1ac, 16 },
	{ 0x1ad, 16 },
	{ 0x1ae, 16 },
	{ 0x1af, 16 },
	{ 0x1b0, 16 },
	{ 0x1b1, 16 },
	{ 0x1b2, 16 },
	{ 0x1b3, 16 },
	{ 0x1b4, 16 },
	{ 0x1b5, 16 },
	{ 0x1b6, 16 },
	{ 0x1b7, 16 },
	{ 0x1b8, 16 },
	{ 0x1b9, 16 },
	{ 0x1ba, 16 },
	{ 0x1bb, 16 },
	{ 0x1bc, 16 },
	{ 0x1bd, 16 },
	{ 0x1be, 16 },
	{ 0x1bf, 16 },
	{ 0x1c0, 16 },
	{ 0x1c1, 16 },
	{ 0x1c2, 16 },
	{ 0x1c3, 16 },
	{ 0x1c4, 16 },
	{ 0x1c5, 16 },
	{ 0x1c6, 16 },
	{ 0x1c7, 16 },
	{ 0x1c8, 16 },
	{ 0x1c9, 16 },
	{ 0x1ca, 16 },
	{ 0x1cb, 16 },
	{ 0x1cc, 16 },
	{ 0x1cd, 16 },
	{ 0x1ce, 16 },
	{ 0x1cf, 16 },
	{ 0x1d0, 16 },
	{ 0x1d1, 16 },
	{ 0x1d2, 16 },
	{ 0x1d3, 16 },
	{ 0x1d4, 16 },
	{ 0x1d5, 16 },
	{ 0x1d6, 16 },
	{ 0x1d7, 16 },
	{ 0x1d8, 16 },
	{ 0x1d9, 16 },
	{ 0x1da, 16 },
	{ 0x1db, 16 },
	{ 0x1dc, 16 },
	{ 0x1dd, 16 },
	{ 0x1de, 16 },
	{ 0x1df, 16 },
	{ 0x1e0, 16 },
	{ 0x1e1, 16 },
	{ 0x1e2, 16 },
	{ 0x1e3, 16 },
	{ 0x1e4, 16 },
	{ 0x1e5, 16 },
	{ 0x1e6, 16 },
	{ 0x1e7, 16 },
	{ 0x1e8, 16 },
	{ 0x1e9, 16 },
	{ 0x1ea, 16 },
	{ 0x1eb, 16 },
	{ 0x1ec, 16 },
	{ 0x1ed, 16 },
	{ 0x1ee, 16 },
	{ 0x1ef, 16 },
	{ 0x1f0, 16 },
	{ 0x1f1, 16 },
	{ 0x1f2, 16 },
	{ 0x1f3, 16 },
	{ 0x1f4, 16 },
	{ 0x1f5, 16 },
	{ 0x1f6, 16 },
	{ 0x1f7, 16 },
	{ 0x1f8, 16 },
	{ 0x1f9, 16 },
	{ 0x1fa, 16 },
	{ 0x1fb, 16 },
	{ 0x1fc, 16 },
	{ 0x1fd, 16 },
	{ 0x1fe, 16 },
	{ 0x1ff, 16 },
};
