/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "fame.h"


static const fame_vlc_t mb_addr_inc[34] = {
  { 0x1, 1},
  { 0x3, 3},
  { 0x2, 3},
  { 0x3, 4},
  { 0x2, 4},
  { 0x3, 5},
  { 0x2, 5},
  { 0x7, 7},
  { 0x6, 7},
  { 0xb, 8},
  { 0xa, 8},
  { 0x9, 8},
  { 0x8, 8},
  { 0x7, 8},
  { 0x6, 8},
  { 0x17, 10},
  { 0x16, 10},
  { 0x15, 10},
  { 0x14, 10},
  { 0x13, 10},
  { 0x12, 10},
  { 0x23, 11},
  { 0x22, 11},
  { 0x21, 11},
  { 0x20, 11},
  { 0x1f, 11},
  { 0x1e, 11},
  { 0x1d, 11},
  { 0x1c, 11},
  { 0x1b, 11},
  { 0x1a, 11},
  { 0x19, 11},
  { 0x18, 11},
  { 0x08, 11}
};

static const fame_vlc_t mb_pattern_table[64] = {
  { 0x01,  9 },
  { 0x0b,  5 },
  { 0x09,  5 },
  { 0x0d,  6 },
  { 0x0d,  4 },
  { 0x17,  7 },
  { 0x13,  7 },
  { 0x1f,  8 },
  { 0x0c,  4 },
  { 0x16,  7 },
  { 0x12,  7 },
  { 0x1e,  8 },
  { 0x13,  5 },
  { 0x1b,  8 },
  { 0x17,  8 },
  { 0x13,  8 },
  { 0x0b,  4 },
  { 0x15,  7 },
  { 0x11,  7 },
  { 0x1d,  8 },
  { 0x11,  5 },
  { 0x19,  8 },
  { 0x15,  8 },
  { 0x11,  8 },
  { 0x0f,  6 },
  { 0x0f,  8 },
  { 0x0d,  8 },
  { 0x03,  9 },
  { 0x0f,  5 },
  { 0x0b,  8 },
  { 0x07,  8 },
  { 0x07,  9 },
  { 0x0a,  4 },
  { 0x14,  7 },
  { 0x10,  7 },
  { 0x1c,  8 },
  { 0x0e,  6 },
  { 0x0e,  8 },
  { 0x0c,  8 },
  { 0x02,  9 },
  { 0x10,  5 },
  { 0x18,  8 },
  { 0x14,  8 },
  { 0x10,  8 },
  { 0x0e,  5 },
  { 0x0a,  8 },
  { 0x06,  8 },
  { 0x06,  9 },
  { 0x12,  5 },
  { 0x1a,  8 },
  { 0x16,  8 },
  { 0x12,  8 },
  { 0x0d,  5 },
  { 0x09,  8 },
  { 0x05,  8 },
  { 0x05,  9 },
  { 0x0c,  5 },
  { 0x08,  8 },
  { 0x04,  8 },
  { 0x04,  9 },
  { 0x07,  3 },
  { 0x0a,  5 },
  { 0x08,  5 },
  { 0x0c,  6 }
};
