/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001  Damien Vincent

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __FAME_RATE_H
#define __FAME_RATE_H

#include "fame.h"

typedef struct _fame_rate_t_ {
  FAME_EXTENDS(fame_object_t);

  void (* init)(struct _fame_rate_t_ *rate,
		int mb_width,
		int mb_height,
		int bitrate,
		char *coding,
		unsigned int flags);
  void (* close)(struct _fame_rate_t_ *rate);
  void (* enter)(struct _fame_rate_t_ *rate,
		 fame_yuv_t **ref,
		 fame_yuv_t *current,
		 unsigned char *shape,
		 char coding);
  int (* global_estimation)(struct _fame_rate_t_ *rate);
  int (* local_estimation)(struct _fame_rate_t_ *rate,
			   int mb_x, int mb_y,
			   short blocks[6][64]);
  void (* leave)(struct _fame_rate_t_ *rate,
		 int spent);

  int mb_width;
  int mb_height;
  fame_yuv_t **ref;
  fame_yuv_t *current;
  unsigned char *shape;
  char coding;
  int bitrate;
  int available;
  int global_scale;
  int I_bits, P_bits;
  int activity;
  int activity_diff;
  int spent;
  int I_factor, P_factor;
  int quant_step;
  unsigned int flags;
} fame_rate_t;

#define FAME_RATE(x) ((fame_rate_t *) x)

extern FAME_CONSTRUCTOR(fame_rate_t);

#endif
