/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
* 				    math.c                                    *
*                                                                             *
* 		     a library of math functions for klone                     *
*                                                                             *
\*****************************************************************************/
/*
 * requires to be linked with -lm
 * you must init it by calling KlMathInit() in your main program after
 * having initialized klone
 */

#include <stdio.h>
#include "klone.h"
#include "kl_atom.h"
#include "kl_string.h"
#include "kl_list.h"
#include "kl_number.h"

/* expt: power elevation
 * always returns a real
 */

KlO
KlExpt(n1, n2)
    KlNumber n1, n2;
{
    KlMustBeNumber(n1, 0);
    KlMustBeNumber(n2, 1);
    return (KlO) KlRealMake(pow(KlNumberRealValue(n1), KlNumberRealValue(n2)));
}

/* log: (log number &optional base)
 * natural logarythm
 */

KlO
KlLog(a)
    KlO a;
{
    double tmp;

    if (KlIsANumber(a)) {
	tmp = KlNumberRealValue(a);
	if (tmp > 0) {
	    tmp = log(tmp);
	    return (KlO) KlRealMake(tmp);
	} else {
	    return KlError(KlStringMake("argument %0 must be positive"), a);
	}
    } else {
	return KlError3(KlE_BAD_ARG_TYPE, a, KlNumberMake(0), KlNumbersType);
    }
}

/*****************************************************************************\
* 				     Init                                     *
\*****************************************************************************/

KlMathInit()
{
    KlDeclareSubr(KlExpt, "expt", 2);
    KlDeclareSubr(KlLog, "log", 1);
}
