%{
/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
*  BYacc grammar for Klone                                                    *
*                                                                             *
\*****************************************************************************/
/* This grammar works with byacc (berkeley yacc) v1.9, but should not dependent 
 * on the version, and should even work with yacc or bison
 */

#define IN_YACC_PARSER
#include "klparser.h"


%}

%union{
    KlO KlObject;
    KlCollection Kl_collection;
}

%type <KlObject> s_expression main_s_exp 
%type <Kl_collection> list_of_s_expressions

%token  END_OF_FILE 	/* MUST be the first token! */
%token  STRING RAW_STRING QUOTECHAR BINEXPR BADBINEXPR
%token  NON_CLOSED_STRING NON_CLOSED_RAW_STRING NON_CLOSED_COMMENT
%token  NUMBER HEX_NUMBER SYMBCHAR CHAR CTRLCHAR
%token  REAL_NUMBER
%token  LEFTPAR RIGHTPAR LEFTBRA RIGHTBRA 
%token  BACKQUOTE UNQUOTE UNQUOTESPLICING
%token  NAME PACKNAME
%token  LEFTPARVECTOR

%token LEFTSQUARE RIGHTPARDOT
%type <KlObject> name number
%token RIGHTSQUARE LEFTSHARPSQUARE
%token UNSIGNED_NUMBER
%token LONGLONG_NUMBER

%start main_s_exp 

%%
main_s_exp	: s_expression
			{$$ = KlReadExpr = $1;
			 YYACCEPT;}
		| /* empty */ RIGHTPAR main_s_exp
			{$$ = KlReadExpr = $2;
			 YYACCEPT;}
		| /* empty */ END_OF_FILE
			{$$ = KlReadExpr = NULL;
			 YYACCEPT;}
		;
name            : NAME
                        {$$ = (KlO) KlInternBytes(yyleng, yytext);}
                ;
number          : NUMBER
			{Int num;
			 sscanf(yytext,"%ld",&num);
			 $$ = (KlO) KlNumberMake((Int) num);}
                ;

s_expression	: LEFTPAR list_of_s_expressions RIGHTPAR
			{$$ = (KlO) KlListMake($2);}
		| LEFTBRA list_of_s_expressions RIGHTBRA
			{$$ = KlCollectionEvalOnLine($2);
			 if (!$$) {
			     KlReadExpr = NULL;
			     yyerror("Error in inline function");
			     YYABORT;
			 }
		     }
		| LEFTSQUARE list_of_s_expressions RIGHTSQUARE
			{$$ = (KlO) KlVectorMakeQ($2);}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT name
			{$$ = (KlO) KlAccessorMake(KlListMake($2), $4);}
                | name
                        {$$ = $1;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT number
			{$$ = (KlO) KlAccessorMake(KlListMake($2), $4);}
		| LEFTPARVECTOR list_of_s_expressions RIGHTPARDOT name
			{$$ = (KlO) KlAccessorMake(KlVectorMakeQ($2), $4);}
		| LEFTPARVECTOR list_of_s_expressions RIGHTPARDOT number
			{$$ = (KlO) KlAccessorMake(KlVectorMakeQ($2), $4);}
                | number
                        {$$ = $1;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT LEFTPAR
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT RIGHTPAR
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT RIGHTSQUARE
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT LEFTSQUARE
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT END_OF_FILE
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT STRING
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
                | LEFTPAR list_of_s_expressions RIGHTPARDOT QUOTECHAR
			{$$ = KlReadExpr = NULL;
			yyerror("Bad dot usage"); YYABORT;}
		| LEFTPARVECTOR list_of_s_expressions RIGHTPAR
			{$$ = (KlO) KlVectorMakeQ($2);}
		| LEFTSHARPSQUARE list_of_s_expressions RIGHTSQUARE
			{
			    if (((KlList) $2)->size < 2 || 
                                (((KlList) $2)->size == 2 &&
			         ((KlList) $2)->list[0] == (KlO) KlA_assign)
                               ) {
				yyerror("A locator #[...] needs more elements");
				YYABORT;
			    }
			    $$ = (KlO) KlLocatorMakeFromColl($2);
			}
                | PACKNAME
		  	{$$ = (KlO) KlPacknameMake(yyleng, yytext);} 
		| REAL_NUMBER
			{double x;
			 KlParseReals(x);
			 $$ = (KlO) KlRealMake(x);}
		| HEX_NUMBER
			{Int num;
			 sscanf(yytext+2,"%lx",&num);
			 $$ = (KlO) KlNumberMake((Int) num);}
		| UNSIGNED_NUMBER
			{$$ = (KlO) KlUnsignedMakeFromString(yytext);}
		| LONGLONG_NUMBER
			{$$ = (KlO) KlLongMakeFromString(yytext);}
		| STRING 
    			{$$ = KlReadString;}
		| RAW_STRING
                        {$$ = KlReadString;}
		| QUOTECHAR s_expression
			{$$ = (KlO) KlQuotedExprMake($2);}
		| BACKQUOTE s_expression
			{$$ = (KlO) KlBackQuotedExprMake($2);}
		| UNQUOTE s_expression
			{$$ = (KlO) KlUnquoteExprMake($2);}
		| UNQUOTESPLICING s_expression
			{$$ = (KlO) KlUnquoteSplicingExprMake($2);}
		| NON_CLOSED_STRING 
		        {$$ = KlReadExpr = NULL;
			    yyerror("Non closed string");
		            YYABORT;
			}
		| NON_CLOSED_RAW_STRING 
		        {$$ = KlReadExpr = NULL;
			    yyerror("Non closed raw string");
		            YYABORT;
			}
		| LEFTPAR list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Lacking \")\" at the end of file!");
			    YYABORT;
			}
		| LEFTBRA list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Non-closed \"{\"");
			    YYABORT;
			}
		| LEFTSQUARE list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Non-closed \"[\"");
			    YYABORT;
			}
		| LEFTPARVECTOR list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Non-closed \"#(\"");
			    YYABORT;
			}
		| LEFTSHARPSQUARE list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Non-closed \"#[\"");
			    YYABORT;
			}
		| CHAR
			{$$ = (KlO) KlNumberMake(((unsigned char *) yytext)[2]);}
		| CTRLCHAR
			{$$ = (KlO) KlNumberMake((yytext[3] - 64) % 32);}
		| SYMBCHAR
                        {int charcode = KlSymbCharParse(yytext+2);
			if (charcode == -1) {
			    yyerror("Invalid character name");
			    YYABORT;
			 } else {			
			     $$ = (KlO) KlNumberMake(charcode);
			 }
			}
 		| BINEXPR
			{$$ = KlReadExprBin;}
 		| BADBINEXPR
			{$$ = NIL;yyerror("Bad BinExpr");}
		| error 
			{$$ = NIL;}
		;

list_of_s_expressions : list_of_s_expressions s_expression
			{$$ = KlCollectionAdd($1, $2);}
		| /* empty */
			{$$ = KlCollectionMake();}
		;


%%

static char *Klyyerrorstring;

Klyyerror(s)
    char *s;
{
    Klyyerrorstring = s;
}

static int Klyyparsing;

KlyyparseSyntaxError(why)
    char *why;
{
    /* set back flag to 0 since this error cannot be corrected */
    Klyyparsing = 0;
    KlError1s(KlE_SYNTAX_ERROR, why);
}

int
Klyyparse()
{
    if (Klyyparsing) {			/* we cannot re-enter parser! */
	KlError1s(KlE_SYNTAX_ERROR,
		  "Parser not reentrant: cannot call read in a read");
	return 1;
    } else {
	Klyyparsing = 1;
    }
    if (KlyyparseRaw()) {		/* abort */
	Klyyparsing = 0;
	KlError1s(KlE_SYNTAX_ERROR, Klyyerrorstring);
	return 1;
    } else {				/* accept */
	Klyyparsing = 0;
	return 0;
    }
}

/*
;;; EMACS MODES
;;; Local Variables: ***
;;; mode:c ***
;;; End: ***
*/
