/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*******************************\
*                               *
*  Machine - dependent patches  *
*                               *
\*******************************/

#ifndef INCLUDE_KLMACHINE_H
#define INCLUDE_KLMACHINE_H

/*****************************************************************************\
* 				OS Description                                *
\*****************************************************************************/
/* To describe your OS, you can #define those flags:
 * 
 * NO_GETPAGESIZE    if you dont have getpagesize()
 * SYSV_TIME         if you cannot use BSD ftime function
 * SYSV_STRINGS      if you include <string.h> instead of <strings.h>
 * SYSV_UTSNAME      if you don't have gethostname()
 * SYSV_SIGNALS      if catching a signal resets its handler to SIG_DFL,
 *			or if you dont have wait3()
 * SYSV_STAT	     if your stat(5) struct do not have the st_blocks field
 * NO_BCOPY          if you dont have bcopy and friends (should use memcpy)
 * NO_MEMSET         if you dont have memset
 * NO_STRCHR	     if strchr do not already exists
 * NO_MEMCHR         if you dont have memchr (implied by the above)
 * NO_MALLOC_DECLARE if your includes already declares char *malloc()
 * NO_ALLOCA  	     if you do not have the alloca function
 * NEED_ALLOCA_H     if you need to include <alloca.h> (e.g: sparcs)
 * NO_VFORK	     if your system do not support the vfork() call
 * NO_LSTAT	     if your system do not have symbolic links, thus no lstat()
 * NO_GETDTABLESIZE  if your system do not have getdtablesize()
 * NO_GETCW          if your system do not have getcw()
 * NO_DIRENT         if you still use the old <sys/dir.h> instead of <dirent.h>
 * VOID_SIGNALS	     if signal handlers are functions returning void (else int)
 *		        do a man  signal |fgrep '(*func)();' to know
 * NO_SELECT         if you cannot use the select(2) call
 * VOID_MALLOC       if malloc, realloc, calloc return void * instead of char *
 * VOID_MALLOCARG    if malloc, realloc, calloc take a void * instead of char *
 * VOID_FREE         if free is declared as void
 * USE_FILENO        if fileno(FILE*) is defined as a function, not as a macro
 * NO_MODE_T         if <sys/stat.h> do not define the mode_t type
 * HAS_SYS_ERRLIST   if you dont have the strerror function in your libc,
 *                   but have the sys_errlist array in the errno manpage
 * NO_STRERROR       if you have neither strerror nor sys_errlist
 * REALLOC_ACCEPTS_NULL define this if your libc realloc function accepts
 *                   null pointers (and make a malloc), for a tad more speed,
 *                   if you defined USE_STANDARD_MALLOC
 * CHECK_DOUBLE_INT_CAST    if your machine does A Floating Point Exeption when
 *                   a cast of a double > 2^31 into a int is done
 * ANSI_STRING_MACRO_EXPANSION if you compiler is not full ANSI (__STDC__ not
 *                   true), but you get the error message in klone.h:
 *                   warning: macro replacement within a string literal
 * PROTOTYPES        if you compiler is not full ANSI (__STDC__ not
 *                   true), but implements prototypes. set if errors:
 *                   warning: argument is incompatible with prototype:
 * NO_SIZE_T         if size_t is not defined by default
 * 
 * For the regexp package, (file regexp.c), you may have to set the flags:
 * -Dvoid=int		compilers that don't do void
 * -DKLCHARBITS=0377	compilers that don't do unsigned char
 * -DSTATIC=extern	compilers that don't like "static foo();" 
 *                      as forward decl
 * -DSTRCSPN		library does not have strcspn()
 * 
 * For the Klone malloc replacement (klmalloc.c) you may set these flags:
 * DOUBLE_ALIGN      if doubles need to be aligned on double boundaries
 * REAL_PADDING      same thing but do not modifies allocator, but fixes built-in
 *                   structures. you must define DO_NOT_REDEFINE_MALLOC also
 * MALLOC_ALIGN=N    if malloced blocks must be aligned on N bytes (default
 *                   to a pointer size)
 * USE_STANDARD_MALLOC     do NOT use klone malloc at all, use standard malloc
 * DO_NOT_REDEFINE_MALLOC  only use klone malloc from klone (via the KlMalloc,...
 *                         primitives, other linked code use the standard one.
 * DO_NOT_USE_SBRK   if using sbrk directly crashes the standard malloc
 *                   (relevant only in the DO_NOT_REDEFINE_MALLOC case)
 *
 * Debugging / tracing code: (see also klmalloc.c for malloc-specific debug)
 *
 * KLPROFILER        Enables inclusion of time-profiling code. You should also
 *                   compile with -pg then
 * DEBUG_CFAPPLY     traps calling null C functiuon pointers
 * DEBUG             general debugging code (slow)
 * DEBUG2            deeper debuging (MUCH slower, tracks stack coherence)
 * 
 */

#ifdef SVR4				/* SYSV R4 (Solaris) */
#ifndef SYSV
#define SYSV
#endif /* !SYSV */
#define NO_MALLOC_DECLARE
#define NO_GETCW
#define VOID_MALLOCARG
#endif /* SVR4 */

					/* OLD SYSV, R3 and older. */
#ifdef SVR3
#ifndef SYSV
#define SYSV
#endif /* !SYSV */
#define NO_GETPAGESIZE
#define NO_GETDTABLESIZE
#endif/* SVR3 */


#ifdef SYSV				/* Generic SYSV (all versions) */
#define SYSV_TIME
#define SYSV_STRINGS
#define SYSV_UTSNAME
#define SYSV_SIGNALS
#define NO_BCOPY
#define SYSV_STAT
#define VOID_MALLOC
#define VOID_SIGNALS
#endif
					/* LINUX */
#ifdef linux
#ifndef LINUX				/* linux ==> LINUX */
#define LINUX
#endif
#endif

#ifdef LINUX
#define USE_FILENO
#define VOID_MALLOCARG
#define VOID_SIGNALS
#define VOIDPTR_MALLOC
#define SYSV			/* needed for glibc */
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif /* !_BSD_SOURCE */
#ifndef __ELF__
#ifdef KLDLOAD				/* dynamic load not supported in a.out */
#undef KLDLOAD
#endif
#endif /* !__ELF__ */
#ifndef NO_GETCW
#define NO_GETCW
#endif
#endif /* LINUX */


#ifdef hpux
#define VOID_SIGNALS
#define NO_GETPAGESIZE
#define SYSV_SIGNALS
#define NO_GETDTABLESIZE
#define VOID_MALLOC
#define USE_FILENO
#ifndef SIMPLE_LHS
#define SIMPLE_LHS
#endif
#endif /* hpux */


/* BSD means no flags (normal) */
/* some (very few) systems might want to define NO_STRCHR */

/*****************************************************************************\
* 			   automatic customizations                           *
\*****************************************************************************/

					/* SUN's sparc machines (sun4) */
#ifdef sparc
#define NO_BCOPY			/* bzero buggy on sun4 */
#ifndef __GNUC__
#define NEED_ALLOCA_H			/* gnu C has a normal alloca */
#endif /* !__GNUC__ */
#endif
					/* silicon graphics (irix) */
#ifdef sgi
#define NO_STRCHR_DECLARE
#define NEED_ALLOCA_H
#define NO_VFORK
#endif

#ifdef AMIGA                            /* The dream machine... AmigaDos+gcc */
#define MACHINE_TYPE "amiga"
#define VOID_SIGNALS
#define DO_NOT_REDEFINE_MALLOC
#define DO_NOT_USE_SBRK
#define LOCATORS
#define NO_SETSID
#endif

#ifdef KLPROFILER			/* klprofiler implies monitor  */
#ifndef MONITOR
#define MONITOR
#endif
#endif

#if __STDC__				/* ANSI */
#else
#define const 
#endif

#ifdef REAL_PADDING			/* take care: protect linked code */
#ifndef DO_NOT_REDEFINE_MALLOC
#ifndef USE_STANDARD_MALLOC
#define DO_NOT_REDEFINE_MALLOC
#endif
#endif
#endif

/*****************************************************************************\
* 			    compiler-dependencies                             *
\*****************************************************************************/

#ifdef __GNUC__
#define	Abs(x)	__builtin_abs(x)
#ifndef alloca
#define alloca __builtin_alloca
#endif /* !alloca */
#endif
#ifdef __HIGHC__
#define	Abs(x)	_abs(x)
#endif

/*****************************************************************************\
* 				    bcopy                                     *
\*****************************************************************************/

#ifdef NO_BCOPY

#ifndef bcopy
#define bcopy(source, dest, count) memcpy(dest, source, count)
#endif
#ifndef bzero
#define bzero(dest, count) memset(dest, 0, count)
#endif
#ifndef bcmp
#define bcmp(source, dest, count) memcmp(source, dest, count)
#endif

#endif					/* NO_BCOPY */

/*****************************************************************************\
* 				    vfork                                     *
\*****************************************************************************/

#ifdef NO_VFORK
#define VFORK fork
#else
#define VFORK vfork
#endif

/*****************************************************************************\
* 			 strchr implemented as index                          *
\*****************************************************************************/

#ifndef NO_STRCHR_DECLARE
#ifndef NO_STRCHR

#define DECLARE_strchr extern char *strchr()
#define DECLARE_strrchr extern char *strrchr()

#else					/* NO_STRCHR */

#define DECLARE_strchr extern char *index()
#define DECLARE_strrchr extern char *rindex()
#define strchr(string, char) index(string, char)
#define strrchr(string, char) rindex(string, char)

#endif					/* NO_STRCHR */
#else					/* NO_STRCHR_DECLARE */
#define DECLARE_strchr
#define DECLARE_strrchr
#endif					/* NO_STRCHR_DECLARE */


#ifdef VOID_SIGNALS
#define KlRSignal void
#else
#define KlRSignal int
#endif
typedef KlRSignal (*KlSignalHandler)();

#ifdef SYSV_SIGNALS
#define KlSIGCHLD SIGCLD
#else
#define KlSIGCHLD SIGCHLD
#endif

/*****************************************************************************\
* 			 Misc. general-purpose macros                         *
\*****************************************************************************/

/* a more readable form of strcmp */
#define strequal(s1, s2) (!strcmp(s1, s2))

/* the STMT macro to embed statements into expressions
 * useful for defining variables local to experssions
 */
#ifdef lint
static int __STMT_ZERO;
#else
#define __STMT_ZERO 0
#endif
#define STMT(statement) do { statement } while (__STMT_ZERO)

/* generic types */
#ifdef NO_VOID
typedef char *AnyPtr;
typedef char (*AnyFuncPtr)();
#else
typedef void *AnyPtr;
typedef void (*AnyFuncPtr)();
#endif

#ifdef NO_STRCHR
#ifndef NO_MEMCHR
#define NO_MEMCHR
#endif
#endif

#ifdef NO_SIZE_T
#include <sys/stdtypes.h>
#endif

/* OS-dependent tweaking */

/****************************************************** offset of structures */

#define KlOffsetOf(s_type,field) KlOffset(s_type*,field)
#define KlOsFieldSize(s_type,field) sizeof(((struct s_type *) 0)->field)

/* this doesn't work on picky compilers */
#define KlOffset(p_type,field)	((unsigned int)&(((p_type)NULL)->field))


#ifndef NO_MEMSET
#define KlMemSet(s, c, n) memset(s, c, n)
#endif /* NO_MEMSET */

#endif					/* INCLUDE_KLMACHINE_H */
