/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
* KLKO                                                                        *
* BODY                                                                        *
*                                                                             *
\*****************************************************************************/
/* Klone Klonable Objects
 */
#include "EXTERN.h"
#include "klone.h"
#include "kl_number.h"
#include "kl_atom.h"
#include "kl_list.h"
#include "kl_coll.h"
#include "kl_string.h"
#include "kl_stream.h"
#include "INTERN.h"
#include "klko.h"

/*****************************************************************************\
* 				    Fields                                    *
\*****************************************************************************/
/* returns index of fields, allocating it if necessary
 */
Int
KlKoNumOfField(field)
    KlAtom field;
{
#ifdef KLKO_IMPLEMENTED
    register KlAtom *p;
    for (p = KlKoFields; p < KlKoFieldsLast; p++) {
	if (*p == field)
	    return (p - KlKoFields);
    }
    /* not found, we must append it */
    if (KlKoFields) {
	KlKoFields = (KlAtom *) Realloc(
	    KlKoFields, ((KlKoFieldsLast - KlKoFields) + 1)  * KLSO);
    } else {
	KlKoFields = (KlAtom *) Malloc(KLSO);
	KlKoFieldsLast = KlKoFields;
    }
    KlIncRef(*KlKoFieldsLast++ = field);
    return (KlKoFieldsLast - KlKoFields) - 1;
#else /* !KLKO_IMPLEMENTED */
    return 0;
#endif /* !KLKO_IMPLEMENTED */
}

/*****************************************************************************\
* 				     INIT                                     *
\*****************************************************************************/

KlKoInit()
{
    
}
