/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.IBuildSearchPage;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.StatusHelper;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SearchpathOrderingWorkbookPage
implements IBuildSearchPage {
    private Label label = null;
    private Table table = null;
    private Composite buttonBar = null;
    private Button upButton = null;
    private Button downButton = null;
    private Label spacer1 = null;
    private Button exportAllButton = null;
    private Button unExportAllButton = null;
    private IStatus status;
    private boolean inUpdate;
    private BeaninfoPathsBlock beaninfoPathsBlock;
    private Composite top;
    private CheckboxTableViewer tableViewer = null;
    private SearchPathListLabelProvider labelProvider;
    private List elements;
    private List selected;
    private List checked;

    public SearchpathOrderingWorkbookPage(BeaninfoPathsBlock beaninfoPathsBlock) {
        this.beaninfoPathsBlock = beaninfoPathsBlock;
        this.status = StatusHelper.OK_STATUS;
        this.labelProvider = new SearchPathListLabelProvider();
        this.elements = new ArrayList();
    }

    public Control createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.label = new Label(this.top, 0);
        this.label.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_label);
        this.label.setLayoutData((Object)gridData);
        this.createTable();
        this.top.setLayout((Layout)gridLayout);
        this.createButtonBar();
        this.top.setSize(new Point(300, 200));
        this.updateEnabledStates();
        return this.top;
    }

    private void createTable() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.table = new Table(this.top, 68386);
        this.table.setLayoutData((Object)gridData1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchpathOrderingWorkbookPage.this.setSelection(BeaninfoPathsBlock.getSelectedList(SearchpathOrderingWorkbookPage.this.tableViewer.getSelection()));
                SearchpathOrderingWorkbookPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput((Object)this.elements);
        if (this.getSelection() != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(this.getSelection()));
        }
        if (this.checked != null) {
            this.tableViewer.setCheckedElements(this.checked.toArray());
        }
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SearchpathOrderingWorkbookPage.this.pageChanged();
            }
        });
    }

    private void createButtonBar() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.fill = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 1;
        this.buttonBar = new Composite(this.top, 0);
        this.buttonBar.setLayoutData((Object)gridData2);
        this.buttonBar.setLayout((Layout)rowLayout);
        this.upButton = new Button(this.buttonBar, 0);
        this.upButton.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_up_button);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selItr = SearchpathOrderingWorkbookPage.this.getSelection().iterator();
                while (selItr.hasNext()) {
                    Object element = selItr.next();
                    int oldIndex = SearchpathOrderingWorkbookPage.this.elements.indexOf(element);
                    if (oldIndex <= 0) continue;
                    SearchpathOrderingWorkbookPage.this.elements.remove(element);
                    SearchpathOrderingWorkbookPage.this.elements.add(--oldIndex, element);
                }
                SearchpathOrderingWorkbookPage.this.tableViewer.refresh();
                SearchpathOrderingWorkbookPage.this.pageChanged();
            }
        });
        this.downButton = new Button(this.buttonBar, 0);
        this.downButton.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_down_button);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selItr = SearchpathOrderingWorkbookPage.this.getSelection().iterator();
                while (selItr.hasNext()) {
                    Object element = selItr.next();
                    int oldIndex = SearchpathOrderingWorkbookPage.this.elements.indexOf(element);
                    if (oldIndex >= SearchpathOrderingWorkbookPage.this.elements.size() - 1) continue;
                    SearchpathOrderingWorkbookPage.this.elements.remove(element);
                    SearchpathOrderingWorkbookPage.this.elements.add(++oldIndex, element);
                }
                SearchpathOrderingWorkbookPage.this.tableViewer.refresh();
                SearchpathOrderingWorkbookPage.this.pageChanged();
            }
        });
        this.spacer1 = new Label(this.buttonBar, 0);
        this.exportAllButton = new Button(this.buttonBar, 0);
        this.exportAllButton.setText(BeanInfoUIMessages.BeanInfoPathsBlock_ExportAll);
        this.exportAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchpathOrderingWorkbookPage.this.setCheckedElements(SearchpathOrderingWorkbookPage.this.getElements());
            }
        });
        this.unExportAllButton = new Button(this.buttonBar, 0);
        this.unExportAllButton.setText(BeanInfoUIMessages.BeanInfoPathsBlock_UnexportAll);
        this.unExportAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchpathOrderingWorkbookPage.this.setCheckedElements(null);
            }
        });
    }

    public List getElements() {
        return new ArrayList(this.elements);
    }

    public void setElements(List elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
            this.updateButtons();
        }
    }

    public void init(IJavaProject javaProject) {
        this.labelProvider.setJavaProject(javaProject);
    }

    public void setCheckedElements(List exportedEntries) {
        this.checked = exportedEntries;
        if (this.tableViewer != null && !this.table.isDisposed()) {
            this.tableViewer.setCheckedElements(this.checked != null ? this.checked.toArray() : new Object[]{});
            this.updateButtons();
        }
        this.pageChanged();
    }

    public boolean isChecked(BPListElement currElement) {
        if (this.tableViewer != null) {
            return this.tableViewer.getChecked((Object)currElement);
        }
        return this.checked != null && this.checked.contains(currElement);
    }

    public List getSelection() {
        return this.selected;
    }

    public void setSelection(List selection) {
        this.selected = selection;
        if (this.tableViewer != null && !this.table.isDisposed()) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selection != null ? selection : new ArrayList()));
            this.updateButtons();
        }
    }

    public void pageChanged() {
        this.updateSearchPathStatus();
        this.beaninfoPathsBlock.doStatusLineUpdate();
    }

    protected void updateButtons() {
        this.upButton.setEnabled(this.canMoveUp() && this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.downButton.setEnabled(this.canMoveDown() && this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.exportAllButton.setEnabled(this.elements != null && this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.unExportAllButton.setEnabled(this.elements != null && this.beaninfoPathsBlock.isBeaninfoEnabled());
    }

    private boolean canMoveDown() {
        int[] indc = this.table.getSelectionIndices();
        int k = this.elements.size() - 1;
        int i = indc.length - 1;
        while (i >= 0) {
            if (indc[i] != k) {
                return true;
            }
            --i;
            --k;
        }
        return false;
    }

    private boolean canMoveUp() {
        int[] indc = this.table.getSelectionIndices();
        int i = 0;
        while (i < indc.length) {
            if (indc[i] != i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSearchPathStatus() {
        if (this.inUpdate) {
            return;
        }
        try {
            this.inUpdate = true;
            this.status = StatusHelper.OK_STATUS;
            List elements = this.getElements();
            boolean entryMissing = false;
            ArrayList<BPListElement> exported = new ArrayList<BPListElement>();
            Iterator entries = elements.iterator();
            while (true) {
                block10: {
                    if (entries.hasNext()) break block10;
                    this.setCheckedElements(exported);
                    if (entryMissing) {
                        this.status = new Status(2, JEMUIPlugin.getPlugin().getBundle().getSymbolicName(), 2, BeanInfoUIMessages.BeaninfoPathsBlock_UI__warning_EntryMissing, null);
                    }
                    break;
                }
                BPListElement currElement = (BPListElement)entries.next();
                boolean isChecked = this.isChecked(currElement);
                if (currElement.canExportBeChanged()) {
                    if (isChecked) {
                        exported.add(currElement);
                    }
                    currElement.setExported(isChecked);
                } else if (currElement.isExported()) {
                    exported.add(currElement);
                }
                entryMissing = entryMissing || currElement.isMissing();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.inUpdate = false;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.inUpdate = false;
            return;
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setBeaninfoEnabled(boolean enable) {
        if (this.top != null && !this.top.isDisposed()) {
            this.updateEnabledStates();
        }
    }

    private void updateEnabledStates() {
        this.updateButtons();
        this.table.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.label.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
    }
}

