##############################################################################
#
# Copyright (c) 2001 Zope Corporation and Contributors. All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""2002-04-15 Hotfix"""

HOTFIX_ID = 'Hotfix_2002-04-15'


apply_hotfix = 0
try:
    from App.Hotfixes import beforeApplyHotfix
    apply_hotfix = beforeApplyHotfix(HOTFIX_ID, 2, 0, 0)
except ImportError:
    apply_hotfix = 1
    from zLOG import LOG, INFO
    LOG('Hotfix', INFO, 'Applying %s.' % HOTFIX_ID)
    

if apply_hotfix:

    import sys, os, types
    from ZPublisher.Response import Response
    from ZPublisher.Request import Request
    from ZPublisher.Publish import publish

    def publish_module(module_name,
                       stdin=sys.stdin, stdout=sys.stdout, stderr=sys.stderr,
                       environ=os.environ, debug=0, request=None, response=None):
        must_die=0
        status=200
        after_list=[None]
        try:
            try:
                if response is None:
                    response=Response(stdout=stdout, stderr=stderr)
                else:
                    stdout=response.stdout

                if request is None:
                    request=Request(stdin, environ, response)

                response = publish(request, module_name, after_list, debug=debug)
            except:
                exc_info=sys.exc_info()
                exc_type, exc_value, exc_tb = exc_info
                if isinstance(exc_type, types.StringType):
                    # this test needs to be first, otherwise the following
                    # issubclass tests will raise a TypeError on the string
                    # exc_type.
                    request.response.exception(info=exc_info)
                    status=response.getStatus()
                elif (issubclass(exc_type, SystemExit) or
                      issubclass(exc_type, ImportError)):
                    # EITHER
                    # This is a real SystemExit. Calling response.exception lets
                    # the exception handler know that we're serious about
                    # shutting down.
                    #
                    # OR
                    # This is an ImportError, which is fatal in this context,
                    # so we turn it into a SystemExit.
                    exc_info = SystemExit, exc_value, exc_tb
                    request.response.exception(fatal=1, info=exc_info)
                    must_die = exc_info
                else:
                    # This is a normal class exception.
                    request.response.exception(info=exc_info)
                    status=response.getStatus()

            if response:
                outputBody=getattr(response, 'outputBody', None)
                if outputBody is not None:
                    outputBody()
                else:
                    response=str(response)
                    if response: stdout.write(response)

            # The module defined a post-access function, call it
            if after_list[0] is not None: after_list[0]()

        finally:
            if request is not None: request.close()

        if must_die:
            try: raise must_die[0], must_die[1], must_die[2]
            finally: must_die=None
        else:
            req_exc = request.response.getHeader('bobo-exception-type')
            if req_exc == 'exceptions.SystemExit':
                request.response.setHeader('bobo-exception-type', 'NiceTry')

        return status


    import ZPublisher, ZServer
    if os.environ.get('PROFILE_PUBLISHER', None):
        ZPublisher.Publish._pfunc = publish_module
    else:
        ZPublisher.Publish.publish_module = publish_module
        ZPublisher.publish_module = publish_module
        ZServer.PubCore.ZServerPublisher.publish_module = publish_module

