/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
*                Based on xsniffer and xsniffer.h                              *
*             Copyright (C) 2000, 2001 Vilhelm Bergman                         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdnav.cpp,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/

extern "C"{
#include <ogle/dvdcontrol.h>
#include <ogle/msgevents.h>
}

#include <fxkeys.h>
#include "dvdwindow.h"
#include "dvdnav.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif



extern FXWindow * targetwindow;
extern DVDNav_t *dvdnav;
extern FXbool popupwindow;
extern FXEvent popupevent;
extern FXbool doCrop;


pthread_t at;

void* dvdnav_message_loop(void* args) {
  MsgEvent_t mev;
  KeySym keysym;
  DVDResult_t res;
  FXEvent event;

  int x,y;
  int cropx,cropy;

 
  while(1){
#if (defined(BSD) && (BSD >= 199306))
    if (DVDNextEventNonBlocking(dvdnav, &mev) != DVD_E_Ok) pthread_exit(NULL);
#else
    if (DVDNextEvent(dvdnav, &mev) != DVD_E_Ok) pthread_exit(NULL);
#endif
    if (popupwindow) continue;

    switch(mev.type){
      case MsgEventQInputPointerMotion:{     
        if (!doCrop) {
          x = mev.input.x;
      	  y = mev.input.y;
          res = DVDMouseSelect(dvdnav, x, y);
          }
        } break;

    case MsgEventQInputButtonPress:
      switch(mev.input.input) {
        case 0x1: {
  	        x = mev.input.x;
  	        y = mev.input.y;
            if (!doCrop) {
  	          res = DVDMouseActivate(dvdnav, x, y);
              }
            else{
              cropx=x;
              cropy=y;
              }
          }	break;
        case 0x2:	break;
        case 0x3:	{
            popupevent.root_x=mev.input.x_root;
            popupevent.root_y=mev.input.y_root;
            popupwindow=TRUE;
        } break;
      }

   case MsgEventQInputButtonRelease:
      if (doCrop){
        switch(mev.input.input) {
          case 0x1: {
              doCrop=FALSE;
            }	break;
        }
      }


    case MsgEventQInputKeyPress: {
      if (targetwindow) {
        event.code=mev.input.input;
        event.state=mev.input.mod_mask;
        if (event.code==KEY_Shift_L)    event.state|=SHIFTMASK;
        if (event.code==KEY_Shift_R)    event.state|=SHIFTMASK;
        if (event.code==KEY_Control_L)  event.state|=CONTROLMASK;
        if (event.code==KEY_Control_R)  event.state|=CONTROLMASK;
        if (event.code==KEY_F13)        event.state|=METAMASK;
        if (event.code==KEY_Alt_L)      event.state|=ALTMASK;
        if (event.code==KEY_Alt_R)      event.state|=ALTMASK;    // FIXME do we need ALTGR flag instead/in addition?
        /// We need to send it directly to the accel table in order to bypass FXComposite's 
        /// onKeyPress handle which captures the keypad keys (left,right etc).
        targetwindow->getAccelTable()->handle(targetwindow,FXSEL(SEL_KEYPRESS,0),(void*)&event); //return 1;

        }
      } break;


    case MsgEventQInputKeyRelease: {
      if (targetwindow) {
        event.code=mev.input.input;
        event.state=mev.input.mod_mask;
        if (event.code==KEY_Shift_L)    event.state&=~SHIFTMASK;
        if (event.code==KEY_Shift_R)    event.state&=~SHIFTMASK;
        if (event.code==KEY_Control_L)  event.state&=~CONTROLMASK;
        if (event.code==KEY_Control_R)  event.state&=~CONTROLMASK;
        if (event.code==KEY_F13)        event.state&=~METAMASK;
        if (event.code==KEY_Alt_L)      event.state&=~ALTMASK;
        if (event.code==KEY_Alt_R)      event.state&=~ALTMASK;    // FIXME do we need ALTGR flag instead/in addition?
        targetwindow->getAccelTable()->handle(targetwindow,FXSEL(SEL_KEYRELEASE,0),(void*)&event); //return 1;
        }
      } break;

    default: break;
    }
  }
}

void dvdnav_init(FXint pid){
  DVDResult_t res;


  res = DVDOpenNav(&dvdnav,pid);
  if(res != DVD_E_Ok ) {
    DVDPerror("Goggles Navigator: Unable to Open Navigator", res);
    exit(1);
    }
  sleep(1);
  DVDRequestInput(dvdnav,(InputMask_t)(INPUT_MASK_KeyPress|INPUT_MASK_KeyRelease|INPUT_MASK_ButtonPress|INPUT_MASK_ButtonRelease|INPUT_MASK_PointerMotion));
  pthread_create(&at, NULL,dvdnav_message_loop, NULL);
  }


 
