/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdwindow.cpp,v 1.7 2003/05/08 03:22:25 sander Exp $
*/
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <fx.h>
#include <fxkeys.h>
#include <FXJPGImage.h>
#include <FXPNGImage.h>
#include <FXPNGIcon.h>
extern "C" {
#include <ogle/dvdcontrol.h>
}


#include "version.h"
#include "dvdwindow.h"
#include "dvdnav.h"
#include "dvddesktop.h"
#include "icons.h"



// Define Message Map
FXDEFMAP(DVDWindow) DVDWindowMap[]={
  //____Message_Type______________ID_______________Message_Handler___
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_QUIT,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,         DVDWindow::ID_QUIT,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,          DVDWindow::ID_SELF,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ABOUT,                DVDWindow::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_OPEN,                 DVDWindow::onCmdOpen),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_OPEN,                 DVDWindow::onUpdOpen),

  
  //Timers 
  FXMAPFUNC(SEL_TIMEOUT,        DVDWindow::ID_REFRESH,              DVDWindow::onRefresh),
  FXMAPFUNC(SEL_TIMEOUT,        DVDWindow::ID_RAISE_TIMER,          DVDWindow::onCmdRaiseControl),


  //Play Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_PLAY,                 DVDWindow::onCmdPlay),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_STOP,                 DVDWindow::onCmdStop),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_PAUSE,                DVDWindow::onCmdPause),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NEXT,                 DVDWindow::onCmdNext),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,DVDWindow::ID_PREVIOUS,           DVDWindow::onCmdPrevious),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SEARCH_FORWARD,       DVDWindow::onCmdSearchForward),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SEARCH_BACKWARD,      DVDWindow::onCmdSearchBackward),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PLAY,                 DVDWindow::onUpdPlay),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_STOP,                 DVDWindow::onUpdStop),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PAUSE,                DVDWindow::onUpdPause),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NEXT,                 DVDWindow::onUpdNext),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PREVIOUS,             DVDWindow::onUpdPrevious),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SEARCH_FORWARD,       DVDWindow::onUpdSearchForward),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SEARCH_BACKWARD,      DVDWindow::onUpdSearchBackward),


  //Navigatiom Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ENTER,                DVDWindow::onCmdEnter),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_UP,               DVDWindow::onCmdNavUp),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_DOWN,             DVDWindow::onCmdNavDown),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_LEFT,             DVDWindow::onCmdNavLeft),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_RIGHT,            DVDWindow::onCmdNavRight),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_ENTER,                DVDWindow::onUpdEnter),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_UP,               DVDWindow::onUpdNavUp),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_DOWN,             DVDWindow::onUpdNavDown),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_LEFT,             DVDWindow::onUpdNavLeft),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_RIGHT,            DVDWindow::onUpdNavRight),


  //Menu Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_ROOT,            DVDWindow::onCmdMenuRoot),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_TITLE,           DVDWindow::onCmdMenuTitle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_SUBPICTURE,      DVDWindow::onCmdMenuSubpicture),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_AUDIO,           DVDWindow::onCmdMenuAudio),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_ANGLE,           DVDWindow::onCmdMenuAngle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_PART,            DVDWindow::onCmdMenuPart),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_ROOT,            DVDWindow::onUpdMenuRoot),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_TITLE,           DVDWindow::onUpdMenuTitle),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_SUBPICTURE,      DVDWindow::onUpdMenuSubpicture),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_AUDIO,           DVDWindow::onUpdMenuAudio),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_ANGLE,           DVDWindow::onUpdMenuAngle),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_PART,            DVDWindow::onUpdMenuPart),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_ANGLE,         DVDWindow::onCmdChangeAngle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_AUDIO,         DVDWindow::onCmdChangeAudio),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_SUBPICTURE,    DVDWindow::onCmdChangeSubpicture),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CROP,                 DVDWindow::onCmdCrop),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_CROP,                 DVDWindow::onUpdCrop),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SCREENSHOT,           DVDWindow::onCmdScreenShot),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SCREENSHOT,           DVDWindow::onUpdScreenShot),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_BROWSE_SCREENSHOTS,   DVDWindow::onCmdBrowseScreenshots),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_BROWSE_SCREENSHOTS,   DVDWindow::onUpdBrowseScreenshots),

  FXMAPFUNC(SEL_DOUBLECLICKED,  DVDWindow::ID_SCREENSHOT_LIST,      DVDWindow::onCmdShowScreenshot),


  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_TITLE_DIALOG,         DVDWindow::onCmdTitleDialog),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_TITLE_DIALOG,         DVDWindow::onUpdTitleDialog),
  FXMAPFUNC(SEL_CLICKED,        DVDWindow::ID_TITLE_LIST,           DVDWindow::onCmdTitleSelect),



  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_TOGGLE_FULLSCREEN,    DVDWindow::onCmdFullScreen),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_TOGGLE_FULLSCREEN,    DVDWindow::onUpdFullScreen),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_RAISE_CONTROL,        DVDWindow::onCmdRaiseControl),

  // Update Handlers

  FXMAPFUNCS(SEL_COMMAND,DVDWindow::ID_SHORTCUT_BEGIN,DVDWindow::ID_SHORTCUT_LAST,DVDWindow::onCmdEditShortCut),


  //Slide Handlers
  FXMAPFUNC(SEL_CHANGED,          DVDWindow::ID_SLIDER,               DVDWindow::onChgSlider),
  FXMAPFUNC(SEL_COMMAND,          DVDWindow::ID_SLIDER,               DVDWindow::onCmdTimePlay),
  FXMAPFUNC(SEL_UPDATE,           DVDWindow::ID_SLIDER,               DVDWindow::onUpdSlider),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,  DVDWindow::ID_SLIDER,               DVDWindow::onSliderPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,DVDWindow::ID_SLIDER,               DVDWindow::onSliderRelease),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_OPTIONS,              DVDWindow::onCmdOptions),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_POPUP_MENU,           DVDWindow::onCmdMenuPopup),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_GETBOOKMARKDIR,       DVDWindow::onCmdSelectDirectory),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_GETDVDROOTDIR,        DVDWindow::onCmdSelectDirectory),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_BOOKMARK,             DVDWindow::onCmdBookmark),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ADD_BOOKMARK,         DVDWindow::onCmdAddBookmark),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_ADD_BOOKMARK,         DVDWindow::onUpdAddBookmark),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CLEAR_BOOKMARKS,      DVDWindow::onCmdClearBookmarks),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_CLEAR_BOOKMARKS,      DVDWindow::onUpdClearBookmarks),
 

  };


// Object implementation
FXIMPLEMENT(DVDWindow,FXMainWindow,DVDWindowMap,ARRAYNUMBER(DVDWindowMap))

#define AUDIO_OFF 15
#define SUBPICTURE_OFF 63



#define TIMEOUT 1000

FXWindow * targetwindow;
DVDNav_t *dvdnav;
FXbool popupwindow;
FXEvent  popupevent;
FXbool doCrop;



//----------------------------------------------------------------------------------
// Constructor
//----------------------------------------------------------------------------------
DVDWindow::DVDWindow(FXApp* a):FXMainWindow(a,"Goggles",NULL,NULL,DECOR_TITLE|DECOR_MINIMIZE|DECOR_MAXIMIZE|DECOR_CLOSE|DECOR_BORDER|DECOR_MENU,10,10,0,0,3,3,3,3) {

  /// Init State Variables
  fullscreen=FALSE;
  pause=FALSE;
  is_seeking=FALSE;
  fspeed=1.0;
  bspeed=1.0;
  navigator=NULL;
  current_time=0;
  total_time=0;
  uop=(DVDUOP_t)0;
  popupwindow=FALSE;
  doCrop=FALSE;
  dvd_started=FALSE;
  show_info=TRUE;
  bookmark_no=0; //Last Bookmark entry...
  dvdbookmark=NULL;
  last_title=-1;
  last_chapter=-1;
  disable_dpms=FALSE;
  disable_screensaver=FALSE;

  screensaver_manager = new FXScreenSaver(getApp());
  dpms_manager = new FXDPMS(getApp());


  // Audio Menu Setup
  audio_id=AUDIO_OFF;
  audio_target.connect(audio_id);
  audio_target.setTarget(this);
  audio_target.setSelector(DVDWindow::ID_CHANGE_AUDIO);

  // Subpicture Menu Setup
  subpicture_id=SUBPICTURE_OFF;
  subpicture_target.connect(subpicture_id);
  subpicture_target.setTarget(this);
  subpicture_target.setSelector(DVDWindow::ID_CHANGE_SUBPICTURE);

  // Angle Menu Setup
  angle_id=0;
  angle_target.connect(angle_id);
  angle_target.setTarget(this);
  angle_target.setSelector(DVDWindow::ID_CHANGE_ANGLE);

  // Create Icons
  createIcons();

  // Set myself as the target
  setTarget(this);
  setSelector(ID_SELF);

  // Add tooltip to our application
  new FXToolTip(getApp());

  // Menu Bar
  FXMenuBar * menubar = new FXMenuBar(this,LAYOUT_FILL_X);
  
  FXVerticalFrame * main= new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN,0,0,0,0,0,0,0,0,0,0);

  /// BEGIN OF MENU


  // File Menu
  filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  new FXMenuCommand(filemenu,"&Open...",NULL,this,ID_OPEN);
  new FXMenuSeparator(filemenu);
  new FXMenuCommand(filemenu,"&Quit\tCtrl-Q\tQuit the application.",icon_exit,this,DVDWindow::ID_QUIT);

  getAccelTable()->addAccel(fxparseAccel("ctrl-Q"),this,FXSEL(SEL_COMMAND,DVDWindow::ID_QUIT));

  bookmarkmenu = new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCommand(bookmarkmenu,"&Set Bookmark",icon_bookset,this,ID_ADD_BOOKMARK);
  new FXMenuCommand(bookmarkmenu,"&Clear Bookmarks",icon_bookdel,this,ID_CLEAR_BOOKMARKS);
  FXMenuSeparator * booksep=new FXMenuSeparator(bookmarkmenu);
  booksep->setTarget(this);
  booksep->setSelector(ID_CLEAR_BOOKMARKS);

  // Option Menu
  optionmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Options",NULL,optionmenu);
  new FXMenuCheck(optionmenu,"&Fullscreen",this,ID_TOGGLE_FULLSCREEN);
  new FXMenuCommand(optionmenu,"&Hide Goggles",NULL,this,FXWindow::ID_LOWER);
  new FXMenuCommand(optionmenu,"&Browse Screenshots...",NULL,this,DVDWindow::ID_BROWSE_SCREENSHOTS);
  new FXMenuSeparator(optionmenu);
  new FXMenuCommand(optionmenu,"&Preferences...",NULL,this,DVDWindow::ID_OPTIONS);


  // Help Menu
  helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About Goggles...",NULL,this,DVDWindow::ID_ABOUT);



  // Audio Menu
  audiomenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(audiomenu,"None");

  // Subpicture Menu 
  subpicturemenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(subpicturemenu,"None");

  // Angle Menu 
  anglemenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(subpicturemenu,"None");




  // Goto Menu  
  gotomenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
//  new FXMenuTitle(menubar,"&Goto",icon_goto,gotomenu);
  new FXMenuCommand(gotomenu,"&Root Menu",icon_goroot,this,DVDWindow::ID_MENU_ROOT);
  new FXMenuCommand(gotomenu,"&Title Menu",icon_bookclose_menu,this,DVDWindow::ID_MENU_TITLE);
  new FXMenuCommand(gotomenu,"&Subpicture Menu",icon_subpicture,this,DVDWindow::ID_MENU_SUBPICTURE);
  new FXMenuCommand(gotomenu,"&Audio Menu",icon_audio,this,DVDWindow::ID_MENU_AUDIO);
  new FXMenuCommand(gotomenu,"A&ngle Menu",icon_angle,this,DVDWindow::ID_MENU_ANGLE);
  new FXMenuCommand(gotomenu,"&Chapter Menu",icon_bookopen_menu,this,DVDWindow::ID_MENU_PART);
//  new FXMenuCommand(gotomenu,"C&hapter/Title Browser...\tCtrl-T",NULL,this,ID_TITLE_DIALOG);
/*
  new FXMenuSeparator(gotomenu);
  new FXMenuCascade(gotomenu,"&Bookmarks",NULL,bookmarkmenu);
  new FXMenuCommand(gotomenu,"C&hapter/Title Browser...\tCtrl-T",NULL,this,ID_TITLE_DIALOG);
*/
/*  // Audio Menu
  audiomenu=new FXMenuPane(this);
  audiotitle=new FXMenuTitle(menubar,"&Audio",icon_audio,audiomenu);
  audiotitle->disable();
  new FXMenuCaption(audiomenu,"None");

  // Subpicture Menu 
  subpicturemenu=new FXMenuPane(this);
  subpicturetitle=new FXMenuTitle(menubar,"&Subpicture",icon_subpicture,subpicturemenu);
  subpicturetitle->disable();
  new FXMenuCaption(subpicturemenu,"None");

  // Angle Menu 
  anglemenu=new FXMenuPane(this);
  angletitle=new FXMenuTitle(menubar,"A&ngle",icon_angle,anglemenu);
  angletitle->disable();
  new FXMenuCaption(subpicturemenu,"None");

  // Option Menu
  optionmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Options",NULL,optionmenu);
  new FXMenuCheck(optionmenu,"&Fullscreen",this,ID_TOGGLE_FULLSCREEN);
  new FXMenuCommand(optionmenu,"&Hide Goggles",NULL,this,FXWindow::ID_LOWER);
//  new FXMenuSeparator(optionmenu);
//  new FXMenuCommand(optionmenu,"Crop",NULL,this,DVDWindow::ID_CROP);
  new FXMenuSeparator(optionmenu);
  new FXMenuCommand(optionmenu,"&Preferences...",NULL,this,DVDWindow::ID_OPTIONS);

  // Help Menu
  helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About Goggles...",NULL,this,DVDWindow::ID_ABOUT);

*/
  const FXuint toolbarstyle=FRAME_RAISED|BUTTON_TOOLBAR;

 
  FXMatrix * settingsframe = new FXMatrix(main,8,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_HEIGHT|PACK_UNIFORM_WIDTH,0,0,0,0, 0,0,0,0,0,0);
  new FXMenuButton(settingsframe,"\tGoto...\tGoto ..",icon_goto,gotomenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  new FXButton(settingsframe,"\tChapter - Title Browser\tChapter - Title Browser",icon_bookopen_menu,this,ID_TITLE_DIALOG,FRAME_RAISED|TEXT_BELOW_ICON|JUSTIFY_CENTER_X);
  new FXMenuButton(settingsframe,"\tBookmarks\tBookmarks",icon_bookset,bookmarkmenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  audiotitle=new FXMenuButton(settingsframe,"\tSelect Audio Stream\tSelect Audio Stream",icon_audio,audiomenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  subpicturetitle = new FXMenuButton(settingsframe,"\tSelect Subpicture Stream\tSelect Subpicture Stream",icon_subpicture,subpicturemenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  angletitle = new FXMenuButton(settingsframe,"\tSelect Angle\tSelect Angle",icon_angle,anglemenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  new FXButton(settingsframe,"\tTake Screenshot\tTake Screenshot",icon_screenshot,this,ID_SCREENSHOT,FRAME_RAISED|TEXT_BELOW_ICON|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);
  new FXFrame(settingsframe,LAYOUT_FILL_X|LAYOUT_FILL_COLUMN|FRAME_RAISED);

  audiotitle->disable();
  subpicturetitle->disable();
  angletitle->disable();

  FXHorizontalFrame* infoframe    =new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0,0,0);

  FXHorizontalFrame * slider_frame = new FXHorizontalFrame(main,LAYOUT_FILL_X|FRAME_RAISED,0,0,0,0,2,2,2,2,0,0);
  progressbar=new FXSlider(slider_frame,this,DVDWindow::ID_SLIDER,SLIDER_INSIDE_BAR|LAYOUT_FILL_X);
  progressbar->setRange(0,100);
  progressbar->setValue(0);


  FXHorizontalFrame* buttonframe =new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0,0,0);


  FXHorizontalFrame * play_frame = new FXHorizontalFrame(buttonframe,LAYOUT_FILL_X|FRAME_RAISED,0,0,0,0,0,0,0,0,0,0);
  new FXButton(play_frame,"\tPlay",icon_play,this,ID_PLAY,toolbarstyle);
  new FXButton(play_frame,"\tPause",icon_pause,this,ID_PAUSE,toolbarstyle);
  new FXButton(play_frame,"\tStop",icon_stop,this,ID_STOP,toolbarstyle);
  new FXVerticalSeparator(play_frame);
  new FXButton(play_frame,"\tSkip to previous chapter",icon_sprevious,this,ID_PREVIOUS,toolbarstyle);
  new FXButton(play_frame,"\tSearch Back",icon_previous,this,ID_SEARCH_BACKWARD,toolbarstyle);
  new FXButton(play_frame,"\tSearch Forward",icon_next,this,ID_SEARCH_FORWARD,toolbarstyle);
  new FXButton(play_frame,"\tSkip to next Chapter",icon_snext,this,ID_NEXT,toolbarstyle);


/*
  FXMatrix * navigate_frame=new FXMatrix(infoframe,3,MATRIX_BY_COLUMNS|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Up",icon_up,this,ID_NAV_UP,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);

  new FXButton(navigate_frame,"\tNavigate Left",icon_left,this,ID_NAV_LEFT,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tEnter/Activate",icon_enter,this,ID_ENTER,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Right",icon_right,this,ID_NAV_RIGHT,toolbarstyle,0,0,0,0,0,0,0,0);

  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Down",icon_down,this,ID_NAV_DOWN,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);

*/
   new FXImageFrame(infoframe,img_gogglessmall,FRAME_NONE|LAYOUT_RIGHT);

  FXVerticalFrame* infoframe2    =new FXVerticalFrame(infoframe,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,5,5,5,5,0,0);
  infoframe2->setBackColor(FXRGB(255,255,255));






  FXLabel     * templabel;
  FXMenuButton  * tempbutton;
  FXTextField   * field;

  FXHorizontalFrame *  dvdidframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|FRAME_NONE,0,0,0,0, 0,0,0,0,1,1);
  dvdidframe->setBackColor(FXRGB(255,255,255));

  templabel = new FXLabel(dvdidframe,"",icon_dvdsmall,ICON_ABOVE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);
  templabel->setBackColor(FXRGB(255,255,255));

  dvdidlabel = new FXTextField(dvdidframe,40,NULL,0,FRAME_NONE|JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN);
  dvdidlabel->setBackColor(FXRGB(255,255,255));
  dvdidlabel->setTextColor(FXRGB(104,117,105));
  dvdidlabel->setEditable(FALSE);



  /// CHAPTER & TITLE
  FXMatrix * locmat = new FXMatrix(infoframe2,4,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|FRAME_NONE,0,0,0,0, 0,0,0,0,1,1);
  locmat->setBackColor(FXRGB(255,255,255));
  templabel = new FXLabel(locmat,"",icon_bookclose,LAYOUT_FILL_Y|ICON_ABOVE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);
  templabel->setBackColor(FXRGB(255,255,255));
  titlelabel = new FXLabel(locmat,"Title -- ",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_LEFT|LABEL_NORMAL|JUSTIFY_CENTER_Y,0,0,0,0);
  titlelabel->setBackColor(FXRGB(255,255,255));
  titlelabel->setTextColor(FXRGB(104,117,105));

  templabel = new FXLabel(locmat,"",icon_bookopen,LAYOUT_FILL_Y|ICON_ABOVE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);
  templabel->setBackColor(FXRGB(255,255,255));

  chapterlabel = new FXLabel(locmat,"Chapter -- ",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_LEFT|LABEL_NORMAL|JUSTIFY_CENTER_Y,0,0,0,0);
  chapterlabel->setBackColor(FXRGB(255,255,255));
  chapterlabel->setTextColor(FXRGB(104,117,105));

  // SUBPICTURE
/*
  FXHorizontalFrame *  subpictureframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|FRAME_NONE,0,0,0,0, 0,0,0,0,1,1);
  subpictureframe->setBackColor(FXRGB(255,255,255));

  tempbutton = new FXMenuButton(subpictureframe,"",icon_subpicture,subpicturemenu,MENUBUTTON_TOOLBAR|FRAME_NONE|JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN);
  tempbutton->setBackColor(FXRGB(255,255,255));


  subpicturelabel = new FXLabel(subpictureframe,"Off",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_LEFT|LABEL_NORMAL|JUSTIFY_CENTER_Y,0,0,0,0);
  subpicturelabel->setBackColor(FXRGB(255,255,255));
  subpicturelabel->setTextColor(FXRGB(104,117,105));

  FXHorizontalFrame *  audioframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|FRAME_NONE,0,0,0,0,0,0,0,0,1,1);
  audioframe->setBackColor(FXRGB(255,255,255));

  tempbutton = new FXMenuButton(audioframe,"",icon_audio,audiomenu,MENUBUTTON_TOOLBAR|FRAME_NONE|JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN);
  tempbutton->setBackColor(FXRGB(255,255,255));

  audiolabel = new FXLabel(audioframe,"Off",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_LEFT|LABEL_NORMAL|JUSTIFY_CENTER_Y,0,0,0,0);
  audiolabel->setBackColor(FXRGB(255,255,255));
  audiolabel->setTextColor(FXRGB(104,117,105));
*/

  FXHorizontalFrame *  clockframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|FRAME_NONE,0,0,0,0,0,0,0,0,1,1);

  templabel = new FXLabel(clockframe,"",icon_clock,LAYOUT_FILL_Y|ICON_ABOVE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_BOTTOM,0,0,0,0);  
  templabel->setBackColor(FXRGB(255,255,255));
  templabel->setTextColor(FXRGB(104,117,105));

  infolabel = new FXLabel(clockframe," - - - ",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_LEFT|JUSTIFY_BOTTOM,0,0,0,0);

  infolabel->setBackColor(FXRGB(255,255,255));
  infolabel->setTextColor(FXRGB(104,117,105));

  clockframe->setBackColor(FXRGB(255,255,255));

/*
  FXHorizontalFrame * barframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|FRAME_LINE,0,0,0,0,1,1,1,1);
  barframe->setBackColor(FXRGB(255,255,255));

  progressbar = new FXProgressBar(barframe,NULL,0,FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT,0,0,0,5);
  progressbar->setTotal(100);
  progressbar->setProgress(0);
  progressbar->setBarColor(FXRGB(104,117,105));
*/

   

  


/*




  FXVerticalFrame* infoframe=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED,0,0,0,0,2,2,2,2,0,0);
  FXVerticalFrame* infoframe2=new FXVerticalFrame(infoframe,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN,0,0,0,0,0,0,0,0,0,0);
  infoframe2->setBackColor(FXRGB(255,255,255));

  FXLabel * templabel = new FXLabel(infoframe2,"",icon_goggles,LAYOUT_FILL_X|LAYOUT_FILL_Y|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y,0,0,0,0);
  templabel->setBackColor(FXRGB(255,255,255));

  infolabel = new FXLabel(infoframe2," ",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICON_ABOVE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y,0,0,0,0);
  infolabel->setBackColor(FXRGB(255,255,255));
  infolabel->setTextColor(FXRGB(104,117,105));


 

  FXHorizontalFrame * slider_frame = new FXHorizontalFrame(main,LAYOUT_FILL_X|FRAME_RAISED,0,0,0,0,2,2,2,2,0,0);
  progresslider=new FXSlider(slider_frame,this,DVDWindow::ID_SLIDER,SLIDER_INSIDE_BAR|LAYOUT_FILL_X);

//  FXHorizontalFrame * main_frame = new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_X,0,0,0,0,0,0,0,0,0,0);
  //new FXImageFrame(main_frame,img_fifthplanet,FRAME_RAISED);
 
//  FXVerticalFrame * control_frame = new FXVerticalFrame(main_frame,LAYOUT_FILL_X,0,0,0,0,0,0,0,0,0,0);
  FXHorizontalFrame * play_frame = new FXHorizontalFrame(main,LAYOUT_FILL_X|FRAME_RAISED,0,0,0,0,0,0,0,0,0,0);

  const FXuint toolbarstyle=FRAME_RAISED|BUTTON_TOOLBAR;

  new FXFrame(play_frame,FRAME_NONE);
  new FXButton(play_frame,"\tPlay",icon_play,this,ID_PLAY,toolbarstyle);
  new FXButton(play_frame,"\tPause",icon_pause,this,ID_PAUSE,toolbarstyle);
  new FXButton(play_frame,"\tStop",icon_stop,this,ID_STOP,toolbarstyle);
  new FXFrame(play_frame,FRAME_NONE);
  new FXVerticalSeparator(play_frame,SEPARATOR_GROOVE|LAYOUT_FILL_Y);
  new FXFrame(play_frame,FRAME_NONE);

  new FXButton(play_frame,"\tSkip to previous chapter",icon_sprevious,this,ID_PREVIOUS,toolbarstyle);
  new FXButton(play_frame,"\tSearch Back",icon_previous,this,ID_SEARCH_BACKWARD,toolbarstyle);
  new FXButton(play_frame,"\tSearch Forward",icon_next,this,ID_SEARCH_FORWARD,toolbarstyle);
  new FXButton(play_frame,"\tSkip to next Chapter",icon_snext,this,ID_NEXT,toolbarstyle);
  new FXFrame(play_frame,FRAME_NONE);

  FXHorizontalFrame * control_frame2 = new FXHorizontalFrame(control_frame,LAYOUT_FILL_X,0,0,0,0,0,0,0,0,0,0);
 
  FXMatrix * navigate_frame=new FXMatrix(control_frame2,3,MATRIX_BY_COLUMNS|FRAME_RAISED,0,0,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Up",icon_up,this,ID_NAV_UP,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);

  new FXButton(navigate_frame,"\tNavigate Left",icon_left,this,ID_NAV_LEFT,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tEnter/Activate",icon_enter,this,ID_ENTER,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Right",icon_right,this,ID_NAV_RIGHT,toolbarstyle,0,0,0,0,0,0,0,0);

  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXButton(navigate_frame,"\tNavigate Down",icon_down,this,ID_NAV_DOWN,toolbarstyle,0,0,0,0,0,0,0,0);
  new FXFrame(navigate_frame,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);

  FXHorizontalFrame * infoframe=new FXHorizontalFrame(control_frame2,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED,0,0,0,0,5,5,5,5,0,0);
  infolabel = new FXLabel(infoframe,"",NULL,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN);
  infolabel->setBackColor(FXRGB(255,255,255));
*/
  
  }


//----------------------------------------------------------------------------------
// Destructor
//----------------------------------------------------------------------------------
DVDWindow::~DVDWindow(){
  delete filemenu;
  delete optionmenu;
  delete gotomenu;
  delete audiomenu;
  delete anglemenu;
  delete subpicturemenu;
  delete helpmenu;
  delete bookmarkmenu;
  deleteIcons();  
  
  getApp()->removeTimeout(this,DVDWindow::ID_REFRESH);
  getApp()->removeTimeout(this,DVDWindow::ID_RAISE_TIMER); 
  }


//----------------------------------------------------------------------------------
// Create
//----------------------------------------------------------------------------------
void DVDWindow::create(){
  readRegistry();

  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  targetwindow=this;

  if (disable_dpms) dpms_manager->disable();
  if (disable_screensaver) screensaver_manager->disable();
  if (start_dvd) openDVD();
  }

//----------------------------------------------------------------------------------
// Create Icons
//----------------------------------------------------------------------------------
void DVDWindow::createIcons(){
  icon_play       =new FXPNGIcon(getApp(),&right_png);
  icon_stop       =new FXPNGIcon(getApp(),&stop_png);
  icon_pause      =new FXPNGIcon(getApp(),&pause_png);
  icon_next       =new FXPNGIcon(getApp(),&next_png);
  icon_previous   =new FXPNGIcon(getApp(),&prev_png);
  icon_snext      =new FXPNGIcon(getApp(),&skipnext_png);
  icon_sprevious  =new FXPNGIcon(getApp(),&skipprev_png);
  icon_enter      =new FXPNGIcon(getApp(),&stop_png);
  icon_left       =new FXPNGIcon(getApp(),&left_png);
  icon_right      =new FXPNGIcon(getApp(),&right_png);
  icon_up         =new FXPNGIcon(getApp(),&up_png);
  icon_down       =new FXPNGIcon(getApp(),&down_png);
  icon_menu       =new FXPNGIcon(getApp(),&menu_png);
  icon_sub        =new FXPNGIcon(getApp(),&subtitles_png);
  icon_max        =new FXPNGIcon(getApp(),&fullscreen_png);
  icon_win        =new FXPNGIcon(getApp(),&window_png);
  icon_exit       =new FXPNGIcon(getApp(),&exit_png);
  icon_bookset    =new FXGIFIcon(getApp(),&bookset_gif);
  icon_bookdel    =new FXGIFIcon(getApp(),&bookdel_gif);
  icon_goggles    =new FXPNGIcon(getApp(),&goggleslogo_png); 
  icon_goroot     =new FXPNGIcon(getApp(),&gohome_png);
  icon_goto       =new FXPNGIcon(getApp(),&goto_png);
  icon_angle      =new FXPNGIcon(getApp(),&angle_png);
  icon_subpicture =new FXPNGIcon(getApp(),&subpicture_png);
  icon_audio      =new FXPNGIcon(getApp(),&audio_png);
  icon_dvdsmall   =new FXPNGIcon(getApp(),&dvd_small_png);
  icon_clock      =new FXPNGIcon(getApp(),&clock_png);
  icon_screenshot =new FXPNGIcon(getApp(),&frame_image_png);

  icon_bookopen   =new FXPNGIcon(getApp(),&bookopen_png);
  icon_bookclose  =new FXPNGIcon(getApp(),&bookclose_png);
  icon_bookopen_menu   =new FXPNGIcon(getApp(),&bookopen_png);
  icon_bookclose_menu  =new FXPNGIcon(getApp(),&bookclose_png);

  img_fox         =new FXPNGImage(getApp(),&poweredbyfox_png);
  img_ogle        =new FXPNGImage(getApp(),&ogle_png);
  img_fifthplanet =new FXPNGImage(getApp(),&fifthplanet_png);
  img_gogglessmall=new FXPNGImage(getApp(),&goggleslogosmall_png);

  FXColor basecolor = getApp()->getBaseColor();
  icon_goroot->blend(basecolor);
  icon_goto->blend(basecolor);
  icon_bookopen->blend(FXRGB(255,255,255));
  icon_bookclose->blend(FXRGB(255,255,255));
  icon_bookopen_menu->blend(basecolor);
  icon_bookclose_menu->blend(basecolor);
  icon_angle->blend(basecolor);
  icon_audio->blend(basecolor);
  icon_screenshot->blend(basecolor);
  icon_dvdsmall->blend(FXRGB(255,255,255));
  icon_clock->blend(FXRGB(255,255,255));
  icon_subpicture->blend(basecolor);
  icon_right->blend(basecolor);
  icon_pause->blend(basecolor);
  }

//----------------------------------------------------------------------------------
// Destroy Icons
//----------------------------------------------------------------------------------
void DVDWindow::deleteIcons(){
  delete img_fox;
  delete img_ogle;
  delete img_fifthplanet;
  delete icon_play;
  delete icon_stop;
  delete icon_pause;
  delete icon_next;
  delete icon_snext;
  delete icon_previous;
  delete icon_sprevious;
  delete icon_enter;
  delete icon_left;
  delete icon_right;
  delete icon_up;
  delete icon_down;
  delete icon_max;
  delete icon_win;
  delete icon_menu;
  delete icon_sub;
  delete icon_exit;
  delete icon_goto;
  delete icon_goroot;
  delete icon_bookclose_menu;
  delete icon_bookclose;
  delete icon_bookopen_menu;
  delete icon_bookopen;
  delete icon_angle;
  delete icon_subpicture;
  delete icon_audio;
  delete icon_bookset;
  delete icon_bookdel;
  delete icon_goggles;
  delete icon_dvdsmall;
  delete icon_clock;

  }


//----------------------------------------------------------------------------------
// Read the registry - FIXME add last window position
//----------------------------------------------------------------------------------
void DVDWindow::readRegistry(){
  FXuint xx,yy,ww,hh;

  initLanguageNames();
  initCountryNames();

  // Get Settings
  dvdroot=getApp()->reg().readStringEntry("OGLE","dvdroot",DEFAULT_DVD_DEVICE);
  bookmarkdir=getApp()->reg().readStringEntry("OGLE","bookmarkdir","");
  auto_show=getApp()->reg().readIntEntry("OGLE","autoshow",0);
  auto_disable=getApp()->reg().readIntEntry("OGLE","autodisable",1);
  auto_bookmark=getApp()->reg().readIntEntry("OGLE","autobookmark",0);
  auto_audiostream=getApp()->reg().readIntEntry("OGLE","autoaudiostream",1);
  disable_dpms=getApp()->reg().readIntEntry("OGLE","dpms",0);
  disable_screensaver=getApp()->reg().readIntEntry("OGLE","screensaver",0);
  filter_subpicture_entry=getApp()->reg().readIntEntry("OGLE","filtersubpicture",1);
  start_dvd=getApp()->reg().readIntEntry("OGLE","autostart",0);
  start_fullscreen=getApp()->reg().readIntEntry("OGLE","startfullscreen",0);
  screenshot_with_spu=getApp()->reg().readIntEntry("OGLE","screenshot_with_spu",0);

  // Read in Shortcuts
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Fullscreen",DEFAULT_SHORTCUT_FULLSCREEN)),this,FXSEL(SEL_COMMAND,ID_TOGGLE_FULLSCREEN));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Pause",DEFAULT_SHORTCUT_PAUSE)),this,FXSEL(SEL_COMMAND,ID_PAUSE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Stop",DEFAULT_SHORTCUT_STOP)),this,FXSEL(SEL_COMMAND,ID_STOP));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Raise",DEFAULT_SHORTCUT_RAISE)),this,FXSEL(SEL_COMMAND,ID_RAISE_CONTROL));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Next",DEFAULT_SHORTCUT_NEXT)),this,FXSEL(SEL_COMMAND,ID_NEXT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Previous",DEFAULT_SHORTCUT_PREVIOUS)),this,FXSEL(SEL_COMMAND,ID_PREVIOUS));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","TitleMenu",DEFAULT_SHORTCUT_TITLEMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_TITLE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","RootMenu",DEFAULT_SHORTCUT_ROOTMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_ROOT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","AudioMenu",DEFAULT_SHORTCUT_AUDIOMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_AUDIO));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","AngleMenu",DEFAULT_SHORTCUT_ANGLEMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_ANGLE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SubtitleMenu",DEFAULT_SHORTCUT_SUBPICTUREMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_SUBPICTURE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SearchForward",DEFAULT_SHORTCUT_SEARCHFORWARD)),this,FXSEL(SEL_COMMAND,ID_SEARCH_FORWARD));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SearchBackward",DEFAULT_SHORTCUT_SEARCHBACKWARD)),this,FXSEL(SEL_COMMAND,ID_SEARCH_BACKWARD));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Enter",DEFAULT_SHORTCUT_ENTER)),this,FXSEL(SEL_COMMAND,ID_ENTER));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavUp",DEFAULT_SHORTCUT_NAVUP)),this,FXSEL(SEL_COMMAND,ID_NAV_UP));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavDown",DEFAULT_SHORTCUT_NAVDOWN)),this,FXSEL(SEL_COMMAND,ID_NAV_DOWN));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavLeft",DEFAULT_SHORTCUT_NAVLEFT)),this,FXSEL(SEL_COMMAND,ID_NAV_LEFT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavRight",DEFAULT_SHORTCUT_NAVRIGHT)),this,FXSEL(SEL_COMMAND,ID_NAV_RIGHT));
  }


//----------------------------------------------------------------------------------
// Write the registry - FIXME add last window position
//----------------------------------------------------------------------------------
void DVDWindow::writeRegistry(){
  getApp()->reg().writeStringEntry("OGLE","bookmarkdir",bookmarkdir.text());
  getApp()->reg().writeStringEntry("OGLE","dvdroot",dvdroot.text());
  getApp()->reg().writeIntEntry("OGLE","autoshow",auto_show);
  getApp()->reg().writeIntEntry("OGLE","dpms",disable_dpms);
  getApp()->reg().writeIntEntry("OGLE","screensaver",disable_screensaver);
  getApp()->reg().writeIntEntry("OGLE","startfullscreen",start_fullscreen);
  getApp()->reg().writeIntEntry("OGLE","autostart",start_dvd);
  getApp()->reg().writeIntEntry("OGLE","autobookmark",auto_bookmark);
  getApp()->reg().writeIntEntry("OGLE","filtersubpicture",filter_subpicture_entry);
  getApp()->reg().writeIntEntry("OGLE","autoaudiostream",auto_audiostream);
  getApp()->reg().writeIntEntry("OGLE","screenshot_with_spu",screenshot_with_spu);
  }


//----------------------------------------------------------------------------------
// Quit
//----------------------------------------------------------------------------------
long DVDWindow::onCmdQuit(FXObject *,FXSelector,void*){
  writeRegistry(); /// Write our settings
  saveBookmarks(); /// Save any bookmarks we might have.
  if(navigator && (DVDCloseNav((DVDNav_t*)navigator)!=DVD_E_Ok)){
    fxwarning("Unable to close OGLE!\n");
    return 0;
    }
  targetwindow=NULL;

  delete dpms_manager;
  delete screensaver_manager;

  getApp()->exit(0);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open DVD
//----------------------------------------------------------------------------------
FXbool DVDWindow::openDVD(){
  if (navigator && DVDSetDVDRoot((DVDNav_t*)navigator,(char*)dvdroot.text())!=DVD_E_Ok) {
      FXMessageBox::error(this,MBOX_OK,"DVD Error","Unable to open dvd for playing.");
      return FALSE;
      }

  initOgle();

  FXchar volid[33];
  FXint  status;

  if (DVDGetVolumeIdentifiers((DVDNav_t*)navigator,0,&status,volid,NULL)==DVD_E_Ok){
    if (status!=0) {
      setTitle(FXStringFormat("Goggles - %s",volid));
      dvdidlabel->setText(volid);
      volumeid=volid;
      }
    }

  /// Store the DISC ID
  FXchar dvdid_str[33];

  if (DVDGetDiscID((DVDNav_t*)navigator,dvdid) != DVD_E_Ok){
      FXMessageBox::error(this,MBOX_OK,"DVD Error","Unable to retrieve DVD ID.");
      return FALSE;
      }

  for (FXint i=0;i<16;i++)
    sprintf(&dvdid_str[i*2],"%02x",dvdid[i]);

  dvdid_string=FXStringFormat("%s",dvdid_str);  

  initBookmarks();
  getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
  dvd_started=TRUE;
  return TRUE;
  }

//----------------------------------------------------------------------------------
// Close DVD - FIXME FUTURE THING
//----------------------------------------------------------------------------------
FXbool DVDWindow::closeDVD(){
  }


//----------------------------------------------------------------------------------
// Init Ogle -  Setups various Ogle settings
//----------------------------------------------------------------------------------
void DVDWindow::initOgle(){
  if (!navigator) return;

  DVDPlayerRegion_t   region=getApp()->reg().readIntEntry("OGLE","player region",1);
  if (region > 6) region=1;
  DVDPlayerRegionSelect((DVDNav_t*)navigator,region);

  DVDLangID_t a_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default audio language",DEFAULTLANGUAGE));
  DVDLangID_t m_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default menu language",DEFAULTLANGUAGE));
  DVDLangID_t s_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default subpicture language",DEFAULTLANGUAGE));

  DVDDefaultAudioLanguageSelect((DVDNav_t*)navigator,a_lcode);
  DVDDefaultMenuLanguageSelect((DVDNav_t*)navigator,m_lcode);
  DVDDefaultSubpictureLanguageSelect((DVDNav_t*)navigator,s_lcode);

  DVDCountryID_t p_ccode=getCountryCode(getApp()->reg().readStringEntry("OGLE","parental country",DEFAULTCOUNTRY));
  DVDParentalCountrySelect((DVDNav_t*)navigator,p_ccode);

  DVDParentalLevel_t level=(DVDParentalLevel_t)getApp()->reg().readIntEntry("OGLE","parental level",DVD_PARENTAL_LEVEL_None);
  DVDParentalLevelSelect((DVDNav_t*)navigator,level);
  }

/*
//----------------------------------------------------------------------------------
// Init Menus - Initialization of the Audio/Angle/Subpicture Menu
//----------------------------------------------------------------------------------

void DVDWindow::initMenus(){
  audiomenu->setTarget(this);
  audiomenu->setSelector(DVDWindow::ID_QUERY_AUDIO_MENU);
  subpicturemenu->setTarget(this);
  subpicturemenu->setSelector(DVDWindow::ID_QUERY_SUBPICTURE_MENU);
  anglemenu->setTarget(this);
  anglemenu->setSelector(DVDWindow::ID_QUERY_ANGLE_MENU);
  }
*/


//----------------------------------------------------------------------------------
// GUI Refresh
//----------------------------------------------------------------------------------
long DVDWindow::onRefresh(FXObject *,FXSelector,void*){
  FXbool updatestate=FALSE;
  DVDResult_t res;
  static DVDDomain_t last_dom=DVD_DOMAIN_Stop;

  if (!navigator || !dvd_started) {
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }
  

  /// Retrieve Current UOPS  
  res = DVDGetCurrentUOPS((DVDNav_t*)navigator,&uop);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentUOPS",res);
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }

  /// Retrieve Current Domain
  res = DVDGetCurrentDomain((DVDNav_t*)navigator,&dom);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentDomain",res);
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }

  if (dom!=last_dom){
    last_dom=dom;
    updatestate=TRUE;
    }


  if (dom==DVD_DOMAIN_VTSTitle) {
    DVDGetCurrentLocation((DVDNav_t*)navigator,&location);  

    titlelabel->setText(FXStringFormat("Title %d ",location.title));
    chapterlabel->setText(FXStringFormat("Chapter %.2d ",location.ptt));
    if (!is_seeking) infolabel->setText(FXStringFormat("%d:%.2d:%.2d of %d:%.2d:%.2d - %gx",location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds,location.title_total.Hours,location.title_total.Minutes,location.title_total.Seconds,fspeed));
    timeinfo=FXStringFormat("Chapter %.2d - %d:%.2d:%.2d",location.ptt,location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds);    

    FXint total=location.title_total.Seconds+(location.title_total.Minutes*60)+(location.title_total.Hours*3600);
    current_time=location.title_current.Seconds+(location.title_current.Minutes*60)+(location.title_current.Hours*3600);
    progressbar->setRange(0,total);
    //progressbar->setValue(current_time);
    progressbar->enable();

    if (location.ptt!=last_chapter){
      last_chapter=location.ptt;
      updatestate=TRUE;
      }

    if (location.title!=last_title){
       last_title=location.title;
       updatestate=TRUE;
       }

    }
  else {
    titlelabel->setText("Title  -- ");
    chapterlabel->setText("Chapter -- ");
    if (!is_seeking) infolabel->setText(" - - -");
    timeinfo="";
    progressbar->setRange(0,100);
    //progressbar->setValue(0);
    progressbar->disable();
    }
  
  if (auto_disable){
  
    if (uop&UOP_FLAG_AngleChange)
      angletitle->enable();
    else
      angletitle->disable();

    if (uop&UOP_FLAG_SubPicStreamChange)
      subpicturetitle->enable();
    else
      subpicturetitle->disable();

    if (uop&UOP_FLAG_AudioStreamChange)
      audiotitle->enable(); 
    else
      audiotitle->disable();
    
    }
  else {
    audiotitle->enable();
    angletitle->enable();
    subpicturetitle->enable();
    }

  if (updatestate){
    update_subpicture_menu();
    update_audio_menu();
    update_angle_menu();
    }

  if (popupwindow) {
     handle(NULL,FXSEL(SEL_COMMAND,DVDWindow::ID_POPUP_MENU),(void*)&popupevent);
     popupwindow=FALSE;
     }

  /// Add new timer...
  getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
  return 1;
  }


//----------------------------------------------------------------------------------
// Dialog Open DVD
//----------------------------------------------------------------------------------
long DVDWindow::onCmdOpen(FXObject *,FXSelector,void*){
  if (dvd_started) return 1;

  FXString dvdroot_backup=dvdroot;

  FXDataTarget target_dvdroot(dvdroot);

  FXDialogBox dialog(this,"Open DVD",DECOR_ALL);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXLabel(main,"DVD mount point, device or Directory:");
  FXHorizontalFrame* dvdrootframe=new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXTextField(dvdrootframe,15,&target_dvdroot,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK);
  new FXButton(dvdrootframe,"...\tBrowse",NULL,this,ID_GETDVDROOTDIR);

  // Bottom part
  new FXHorizontalSeparator(main,SEPARATOR_RIDGE|LAYOUT_FILL_X);
  FXHorizontalFrame *closebox=new FXHorizontalFrame(main,LAYOUT_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH);
  new FXButton(closebox," &Open ",NULL,&dialog,FXDialogBox::ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);
  new FXButton(closebox," &Cancel ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);

  if (dialog.execute(PLACEMENT_SCREEN)){
    if (dvdroot.empty()) {
      FXMessageBox::error(this,MBOX_OK,"DVD Error","You need to specify the dvd device or directory you want to play from. You can do this in the preferences panel.");
      }
    else {
      openDVD();
      }
    }
  dvdroot=dvdroot_backup;
  return 1;
  }

long DVDWindow::onUpdOpen(FXObject * sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_DISABLE):FXSEL(SEL_COMMAND,ID_ENABLE),NULL);
  return 1;
  }







//----------------------------------------------------------------------------------
// Play
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPlay(FXObject*sender,FXSelector selector,void* ptr){
  if (!dvd_started){
    if (dvdroot.empty()) {
      return onCmdOpen(sender,selector,ptr);
      return 1;
      }
    else {
      openDVD();
      }
    return 1;
    }

  DVDResult_t res;

  if (fspeed>1.0 || bspeed>1.0) {
    fspeed=bspeed=1.0;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    return 1;
    }

  if (pause) {
    DVDPauseOff((DVDNav_t*)navigator);
    pause=FALSE;
    return 1;
    }

  if (uop&UOP_FLAG_Resume){
    res=DVDResume((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) DVDPerror("DVDResume", res);
    return 1;
    }


  return 1;
  }

long DVDWindow::onUpdPlay(FXObject* sender,FXSelector,void*){
  FXbool enable=(navigator!=NULL) && ( (!dvd_started) || (pause) || (bspeed>1.0) || (fspeed>1.0) || ((dom!=DVD_DOMAIN_VTSTitle) && (uop&UOP_FLAG_Resume)) );
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Stop
//----------------------------------------------------------------------------------
long DVDWindow::onCmdStop(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDStop((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDStop", res);
  return 1;
  }

long DVDWindow::onUpdStop(FXObject* sender,FXSelector,void*){
//  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_Stop));
//  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Pause
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPause(FXObject*,FXSelector,void*){
  DVDResult_t res;
  if (pause) {
    res = DVDPauseOff((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) {
        DVDPerror("DVDPauseOff", res);
        return 1;
        }
    pause=FALSE;
    }
  else {
    DVDResult_t res=DVDPauseOn((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) {
        DVDPerror("DVDPauseOn", res);
        return 1;
        }
    pause=TRUE;
    }
  return 1;
  }

long DVDWindow::onUpdPause(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_PauseOn) && (pause==FALSE));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Next
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNext(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDNextPGSearch((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDNextPGSearch",res);
  return 1;
  }

long DVDWindow::onUpdNext(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_NextPGSearch) );
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Previous
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPrevious(FXObject*,FXSelector,void*ptr){
  DVDResult_t result;
  FXEvent * event = reinterpret_cast<FXEvent*>(ptr);
  printf("Click count=%d\n",event->click_count);
  if (event->click_count==1){
    result=DVDTopPGSearch((DVDNav_t*)navigator);
    if (result!=DVD_E_Ok) DVDPerror("DVDTopPGSearch", result);
    }
  else{
    result=DVDPrevPGSearch((DVDNav_t*)navigator);
    if (result!=DVD_E_Ok) DVDPerror("DVDPrevPGSearch", result);
    }
  return 0;
  }

long DVDWindow::onUpdPrevious(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_PrevOrTopPGSearch));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Search Forward
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSearchForward(FXObject*,FXSelector,void*){
  if (bspeed > 1.0){
    bspeed-=0.5;
    DVDBackwardScan((DVDNav_t*)navigator,bspeed);
    }
  else {
    fspeed+=0.5;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    }
  return 1;
  }

long DVDWindow::onUpdSearchForward(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (fspeed<8.0) /*&& (uop&UOP_FLAG_ForwardScan)*/);
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Search Backward
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSearchBackward(FXObject*,FXSelector,void*){
  if (fspeed > 1.0) {
    fspeed-=0.5;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    }
  else { /// Don't do this yet..
//    bspeed+=0.5;
//    DVDBackwardScan((DVDNav_t*)navigator,bspeed);
    }
  return 1;
  }

long DVDWindow::onUpdSearchBackward(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (bspeed<3.0) /*&& (uop&UOP_FLAG_BackwardScan)*/);
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Enter
//----------------------------------------------------------------------------------
long DVDWindow::onCmdEnter(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDButtonActivate((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDButtonActivate", res);
  return 1;
  }

long DVDWindow::onUpdEnter(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
//  Navigate Up
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavUp(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDUpperButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDUpperButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavUp(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Down
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavDown(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDLowerButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDLowerButtonSelect", res);
  return 1;
  }


long DVDWindow::onUpdNavDown(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Left
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavLeft(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDLeftButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDLeftButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavLeft(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Right
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavRight(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDRightButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDRightButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavRight(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Toggle Fullscreen
//----------------------------------------------------------------------------------
long DVDWindow::onCmdFullScreen(FXObject*,FXSelector,void*){
  fullscreen=!fullscreen;
  if (fullscreen) {
    DVDSetZoomMode(dvdnav,(ZoomMode_t)(ZoomModeFullScreen));
    if (auto_show) getApp()->addTimeout(this,DVDWindow::ID_RAISE_TIMER,1000);
    }
  else {
    DVDSetZoomMode(dvdnav,(ZoomMode_t)(ZoomModeResizeAllowed));
    }
  } 

long DVDWindow::onUpdFullScreen(FXObject*sender,FXSelector,void*){
  FXbool enabled=((navigator!=NULL) && (dvd_started));
  sender->handle(this,enabled?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  sender->handle(this,fullscreen?FXSEL(SEL_COMMAND,FXWindow::ID_CHECK):FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }


long DVDWindow::onCmdRaiseControl(FXObject*,FXSelector,void*){
//  if (isMinimized()){
//    restore();
//    raise();
//    }
//  else {
//    raise();
//    }
  raise();
  return 1;
  }



//----------------------------------------------------------------------------------
// Open Root Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuRoot(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Root);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall", res);
  return 1;
  }

long DVDWindow::onUpdMenuRoot(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_RootMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Title Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuTitle(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Title);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  return 1;
  }

long DVDWindow::onUpdMenuTitle(FXObject *sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_TitleMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Open Subpicture Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuSubpicture(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Subpicture);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  return 1;
  }

long DVDWindow::onUpdMenuSubpicture(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_SubPicMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Audio Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuAudio(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Audio);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall", res);
  return 1;
  }

long DVDWindow::onUpdMenuAudio(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_AudioMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



//----------------------------------------------------------------------------------
// Open Angle Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuAngle(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Angle);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  return 1;
  }

long DVDWindow::onUpdMenuAngle(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_AngleMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Chapter Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuPart(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Part);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  return 1;
  }

long DVDWindow::onUpdMenuPart(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_ChapterMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }




//----------------------------------------------------------------------------------
// Crop Screen
//----------------------------------------------------------------------------------
long DVDWindow::onCmdCrop(FXObject*,FXSelector,void*) {
  return 1;
  }

long DVDWindow::onUpdCrop(FXObject*sender,FXSelector,void*){
  FXbool enable=false;
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Init Bookmarks
//----------------------------------------------------------------------------------
void DVDWindow::initBookmarks(){
  if (navigator==NULL) return;
/*
  FXuchar dvdid[16];

  if (DVDGetDiscID((DVDNav_t*)navigator,dvdid) != DVD_E_Ok){
    return;
    }
*/

  if (!bookmarkdir.empty()){
    bookmarkdir = FXFile::absolute(bookmarkdir);
    if (!FXFile::exists(bookmarkdir)){
      return;
      }
    }

  if (bookmarkdir.empty())
    dvdbookmark = DVDBookmarkOpen(dvdid,NULL,0);
  else
    dvdbookmark = DVDBookmarkOpen(dvdid,(char*)bookmarkdir.text(),0);

  if (dvdbookmark){
    FXuint counter=0;
    FXbool autobook=FALSE;
    char * navstate=NULL;
    FXchar * usercomment=NULL;
    FXchar * appname="Goggles";
    FXchar * extra_appinfo=NULL;
    FXchar * appinfo=NULL;
    FXMenuCommand * command;
    bookmark_no=0;
    FXbool autobookmarkfound=FALSE;


    while(DVDBookmarkGet(dvdbookmark,bookmark_no,&navstate,&usercomment,appname,&appinfo)!=-1){
      autobook=FALSE;
      DVDBookmarkGet(dvdbookmark,bookmark_no, NULL, NULL,"common",&extra_appinfo);
      if (!autobookmarkfound && extra_appinfo && FXString(extra_appinfo)=="autobookmark" && (!gotomenu->getLast()->getUserData())){
        FXMenuSeparator * separator = new FXMenuSeparator(gotomenu);
        separator->create();
        command = new FXMenuCommand(gotomenu,"R&esume Last Session...",NULL,this,ID_BOOKMARK);
        FXFREE(&extra_appinfo);
        autobook=TRUE;
        autobookmarkfound=TRUE;
        }
      else {
        if (autobookmarkfound) counter=bookmark_no; else counter=bookmark_no+1;
        command = new FXMenuCommand(bookmarkmenu,FXStringFormat("%d - %s",counter,usercomment),NULL,this,ID_BOOKMARK);
        }

      command->setUserData(new bookmarkentry(navstate,bookmark_no,autobook));
      command->create();   

      FXFREE(&usercomment); 
      FXFREE(&appinfo);
      bookmark_no++;

      }
    }
  }
 
//----------------------------------------------------------------------------------
// Save Bookmarks
//----------------------------------------------------------------------------------
void DVDWindow::saveBookmarks(){
  FXbool addautobookmark=(auto_bookmark && (dom==DVD_DOMAIN_VTSTitle));
  FXWindow * window=NULL;
  FXchar   * navdata=NULL;
  if (!navigator) return;

  saveAutoBookmark(); 


  /// Save Bookmarks if we have a bookmark file or we need to save a autobookmark
  if (dvdbookmark){
    DVDBookmarkSave(dvdbookmark,0);
    
    window=bookmarkmenu;   
    while(window->getLast()->getUserData()){
      delete (bookmarkentry*)window->getLast()->getUserData();
      delete window->getLast();
      window=bookmarkmenu;   
      }      

    bookmark_no=0;
    DVDBookmarkClose(dvdbookmark);
    dvdbookmark=NULL;
    }
  }

//----------------------------------------------------------------------------------
// Go To Bookmark
//----------------------------------------------------------------------------------
long DVDWindow::onCmdBookmark(FXObject*sender,FXSelector,void*){
  bookmarkentry * bmk = (bookmarkentry*)(((FXWindow*)sender)->getUserData());
  if (bmk==NULL) return 1;
  DVDSetState((DVDNav_t*)navigator,bmk->navstate);
  return 1;  
  }

//----------------------------------------------------------------------------------
// Add a Bookmark
//----------------------------------------------------------------------------------
long DVDWindow::onCmdAddBookmark(FXObject*sender,FXSelector,void*){
  addBookmark(FALSE);
  }

void DVDWindow::saveAutoBookmark(){

  if (gotomenu->getLast()->getUserData()){
    bookmarkentry * bmk = (bookmarkentry*)(gotomenu->getLast()->getUserData());
    DVDBookmarkRemove(dvdbookmark,bmk->entry);
    delete bmk;
    }

  if (auto_bookmark && (dom==DVD_DOMAIN_VTSTitle)){ 
    addBookmark(TRUE);
    }

  }

//----------------------------------------------------------------------------------
// addBookmark -  autobookmark should only be true when we exit the application
//----------------------------------------------------------------------------------
void DVDWindow::addBookmark(FXbool autobookmark){
  FXchar *navstate=NULL;
  FXMenuCommand * command=NULL;

/*
  if (DVDGetDiscID((DVDNav_t*)navigator,dvdid) != DVD_E_Ok){
    return;
    }
*/

  if (DVDGetState((DVDNav_t*)navigator,&navstate) != DVD_E_Ok) {
    return;
    }

  if (!dvdbookmark){

    if (!bookmarkdir.empty()){
      bookmarkdir = FXFile::absolute(bookmarkdir);
      if (!FXFile::exists(bookmarkdir)){
        return;
        }
      }

    if (bookmarkdir.empty())
      dvdbookmark = DVDBookmarkOpen(dvdid,NULL,1);
    else
      dvdbookmark = DVDBookmarkOpen(dvdid,(char*)bookmarkdir.text(),1);

    if (!dvdbookmark) {
      FXFREE(&navstate);
      return;
      }
    }

  if (autobookmark){
    FXuint counter;
    DVDBookmarkAdd(dvdbookmark,navstate,"bookmark","Goggles",NULL);
    counter=DVDBookmarkGetNr(dvdbookmark);
    DVDBookmarkSetAppInfo(dvdbookmark,counter-1,"common","autobookmark");
    FXFREE(&navstate);
    return;
    }
  else {
    if (DVDBookmarkAdd(dvdbookmark,navstate,(char*)timeinfo.text(),"Goggles",NULL)==-1){
      FXFREE(&navstate);
      return;
      }
    else {
      command = new FXMenuCommand(bookmarkmenu,FXStringFormat("%d - %s",(bookmark_no+1),timeinfo.text()),NULL,this,ID_BOOKMARK);
      bookmark_no++;
      command->setUserData(new bookmarkentry(navstate,bookmark_no,FALSE));
      command->create();
      }
    }
}

long DVDWindow::onUpdAddBookmark(FXObject*sender,FXSelector,void*){
  FXbool enable=(dvd_started && (dom==DVD_DOMAIN_VTSTitle));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }
  


//----------------------------------------------------------------------------------
// Clear Bookmarks
//----------------------------------------------------------------------------------
long DVDWindow::onCmdClearBookmarks(FXObject*sender,FXSelector,void*){
  FXchar * navdata=NULL;
  FXWindow * window=NULL;
  FXASSERT(dvdbookmark);
  FXuint result = FXMessageBox::question(this,MBOX_YES_NO,"Clear Bookmarks?","Are you sure you want to clear the bookmarks for this DVD?");
  if (result==MBOX_CLICKED_YES){
    
    // Delete Menu Entries
    window=bookmarkmenu;   
    while(window->getLast()->getUserData()){
      bookmarkentry * bmk = (bookmarkentry*) window->getLast()->getUserData();
      DVDBookmarkRemove(dvdbookmark,bmk->entry);
      delete (bookmarkentry*)window->getLast()->getUserData();
      delete window->getLast();
      window=bookmarkmenu;   
      }      

    if (gotomenu->getLast()->getUserData()){
      bookmarkentry * bmk = (bookmarkentry*) gotomenu->getLast()->getUserData();
      bmk->entry=0;
      bookmark_no=1;
      }
    else {
      bookmark_no=0;
      }
    }
  return 1;
  }

long DVDWindow::onUpdClearBookmarks(FXObject*sender,FXSelector,void*){
  if ((gotomenu->getLast()->getUserData() && bookmark_no>1) || (!gotomenu->getLast()->getUserData() && bookmark_no>0))
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SHOW),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_HIDE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Make a screenshot
//----------------------------------------------------------------------------------
long DVDWindow::onCmdScreenShot(FXObject*,FXSelector,void*){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "screenshots";
  if (!FXFile::exists(dir)){
    if (!FXFile::createDirectory(dir,0755)){
      return 1;
      }
    }  
  dir += PATHSEPSTRING + dvdid_string;

  if (!FXFile::exists(dir)){
    if (!FXFile::createDirectory(dir,0755)){
      return 1;
      }
    }

  if (timeinfo.empty()){
    dir = dir + PATHSEPSTRING + "menu%02i.jpg";
    }
  else {
    dir = dir + PATHSEPSTRING + FXStringFormat("%d_%d_%d_%d_%d_%%02i.jpg",location.title,location.ptt,location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds);
    }

  DVDResult_t res;
  if (screenshot_with_spu)
    res = DVDSaveScreenshot((DVDNav_t*)navigator,ScreenshotModeWithSPU,(char*)dir.text());
  else
    res = DVDSaveScreenshot((DVDNav_t*)navigator,ScreenshotModeWithoutSPU,(char*)dir.text());

  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDSaveScreenshot",res);
    return 1;
    }
  return 1;
  }


long DVDWindow::onUpdScreenShot(FXObject*sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



long DVDWindow::onCmdBrowseScreenshots(FXObject*,FXSelector,void*){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "screenshots" + PATHSEPSTRING + dvdid_string;

  FXDialogBox dialog(this,"Screenshots",DECOR_ALL,0,0,400,300);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXVerticalFrame * smain=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
  FXFileList * list = new FXFileList(smain,this,ID_SCREENSHOT_LIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICONLIST_BIG_ICONS|FILELIST_SHOWFILES);
  new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
  list->setDirectory(dir);
  list->setPattern("*.jpg");
  dialog.execute();
  return 1;
  }


long DVDWindow::onUpdBrowseScreenshots(FXObject*sender,FXSelector,void*){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "screenshots" + PATHSEPSTRING + dvdid_string;
  if (FXFile::exists(dir) && !dvdid_string.empty())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);    
  return 1;
  }


long DVDWindow::onCmdShowScreenshot(FXObject*sender,FXSelector,void*ptr){
  FXFileList * filelist=reinterpret_cast<FXFileList*>(sender);
  FXint index=(FXint)(FXival)ptr;
  FXint xdpi,ydpi;
  FXString filename = filelist->getItemPathname(index);
 
  FXJPGImage * image=new FXJPGImage(getApp(),NULL,IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP);

  if(image){
    FXFileStream stream;
    if(stream.open(filename,FXStreamLoad)){
      getApp()->beginWaitCursor();
      image->loadPixels(stream);
/*
      image->getPixelSize(xdpi,ydpi);
      if ((xdpi!=100) || (ydpi!=100)){
       printf("New width=%g %d\n",(image->getWidth() *(100.0/xdpi)),image->getWidth());
        printf("New height=%g\n",(image->getHeight() * (100.0/ydpi)));
        image->scale((image->getWidth() *(100.0/xdpi)),(image->getHeight() * (100.0/ydpi)),1);      
        }
*/
      stream.close();
      image->create();
      getApp()->endWaitCursor();
      FXDialogBox dialog(this,FXStringFormat("Screenshot: %s",filename.text()),DECOR_ALL,0,0,750,550);
      FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0,0);
      FXVerticalFrame * smain=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
      new FXImageView(smain,image,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|IMAGEVIEW_NORMAL);  
      new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
      dialog.execute(PLACEMENT_SCREEN);
      }
    delete image;
    }
  return 1;
  }



//----------------------------------------------------------------------------------
// Change Audio Stream  - FIXME
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeAudio(FXObject* sender,FXSelector,void*){
   
  if (navigator==NULL) return 1;
  
  DVDResult_t res;
  DVDStream_t stream;

  int number_of_streams;

  /// WHY DO I GET THE CURRENT AUDIOSTREAM???
  res = DVDGetCurrentAudio((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentAudio",res);
    return 1;
    }

  res = DVDAudioStreamChange((DVDNav_t*)navigator,audio_id);
  if(res != DVD_E_Ok) {
      DVDPerror("Goggles: DVDAudioStreamChange", res);
      return 1;
      }
  
  return 1;
  }


//----------------------------------------------------------------------------------
// Change Subpicture Stream
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeSubpicture(FXObject*,FXSelector,void*){
  DVDResult_t res;
  if (navigator==NULL) return 1;  
  if (subpicture_id==SUBPICTURE_OFF){
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVDFalse);          
    if (res!=DVD_E_Ok) DVDPerror("DVDSetSubpictureState",res);
    }
  else {
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVDTrue);
    if (res!=DVD_E_Ok) DVDPerror("DVDSetSubpictureState",res);
    res=DVDSubpictureStreamChange((DVDNav_t*)navigator,subpicture_id);
    if (res!=DVD_E_Ok) DVDPerror("DVDSubpictureStreamChange",res);
    }
  return 1;
  }



//----------------------------------------------------------------------------------
// Change Angle
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeAngle(FXObject*,FXSelector,void*){
  if (navigator==NULL) return 1;
  DVDResult_t res=DVDAngleChange((DVDNav_t*)navigator, angle_id);
  if (res!=DVD_E_Ok) DVDPerror("DVDAngleChange",res);
  return 1;
  }


//----------------------------------------------------------------------------------
// Change Title Stream
//----------------------------------------------------------------------------------
void DVDWindow::openTitle(FXint title,FXint chapter){
  if (navigator==NULL) return;
  DVDResult_t res=DVDPTTPlay((DVDNav_t*)navigator,title,chapter);
  if (res!=DVD_E_Ok) DVDPerror("DVDPTTPlay", res);
  }


//----------------------------------------------------------------------------------
// Titles Dialog -- FIXME maybe don't destroy this window everytime...
//----------------------------------------------------------------------------------
long DVDWindow::onCmdTitleDialog(FXObject*,FXSelector,void*){
  DVDResult_t res;
  FXint num_titles;
  FXint num_ptts;
  FXTreeItem * titleitem;
  FXTreeItem * currentitem=NULL;
  FXTreeItem * chapteritem;

  FXDialogBox dialog(getApp(),"Select Chapter/Title",DECOR_ALL);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXLabel(main,"To jump to a specific chapter,\nclick the corresponding item:",NULL,LABEL_NORMAL|JUSTIFY_CENTER_X);
  FXVerticalFrame * sunkenlistframe=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
  FXTreeList * list = new FXTreeList(sunkenlistframe,15,this,ID_TITLE_LIST,TREELIST_ROOT_BOXES|TREELIST_SHOWS_BOXES|TREELIST_SHOWS_LINES|TREELIST_SINGLESELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  FXTreeItem * rootitem=list->addItemLast(NULL,volumeid,icon_dvdsmall,icon_dvdsmall);

  /// Fill the treelist
  res = DVDGetTitles((DVDNav_t*)navigator, &num_titles);
  if (res != DVD_E_Ok) {
    DVDPerror("DVDGetTitles", res);
    return 1;
    } 

  for (FXint i=1;i<=num_titles;i++){
    res = DVDGetNumberOfPTTs((DVDNav_t*)navigator,i,&num_ptts);
    if(res!=DVD_E_Ok) {
      DVDPerror("DVDGetNumberOfPTTs", res);
      return 1;
      } 

    titleitem=list->addItemLast(rootitem,FXStringFormat("Title %d",i),icon_bookclose,icon_bookclose,(void*)(FXival)i);
    for (FXint j=1;j<=num_ptts;j++){
      chapteritem=list->addItemLast(titleitem,FXStringFormat("Chapter %d",j),icon_bookopen,icon_bookclose,(void*)(FXival)j);
      if ((last_chapter==j) && (last_title==i)) {
        currentitem=chapteritem;
        list->expandTree(titleitem);
//        list->selectItem(currentitem);
        list->openItem(currentitem);
        }
      }
    }    
  list->expandTree(rootitem);


  new FXButton(main,"    &Close    \tClose Dialog",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_NORMAL|BUTTON_INITIAL|LAYOUT_CENTER_X);
  dialog.create();
  if (currentitem) list->makeItemVisible(currentitem);

  dialog.execute(PLACEMENT_SCREEN);
  return 1;
  }


long DVDWindow::onCmdTitleSelect(FXObject*,FXSelector,void* ptr){
  FXTreeItem * item=(FXTreeItem*)ptr;
  if (item->getParent()!=NULL){
    FXint title,chapter;
    if (item->getParent()->getData()){
      title=(FXival)item->getParent()->getData();
      chapter=(FXival)item->getData();
      }
    else{ // If we select a title.. by default Chapter 1 is being played...
      title=(FXival)item->getData(); 
      chapter=1;  
      }
    openTitle(title,chapter);
    }
  return 1;
  }

long DVDWindow::onUpdTitleDialog(FXObject*sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



//----------------------------------------------------------------------------------
// Construct Subpicture Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_subpicture_menu(){

  // delete current ones
  while(subpicturemenu->getFirst()){
    delete subpicturemenu->getFirst();
    }  

  if (navigator==NULL) return;


  FXMenuRadio *   command;
  FXString          name;
  DVDResult_t       res;
  DVDStream_t       stream;
  DVDBool_t enabled,shown;
  subpicture_id=SUBPICTURE_OFF;


  int number_of_streams=0;
  int count=0;

  FXMenuRadio * cap = new FXMenuRadio(subpicturemenu,"Off",&subpicture_target,FXDataTarget::ID_OPTION+SUBPICTURE_OFF);
  cap->create();


  res = DVDGetCurrentSubpicture((DVDNav_t*)navigator, &number_of_streams,&stream,&shown);
  if(res != DVD_E_Ok) {
    DVDPerror("Could not retrieve audio formats\n",res);
    return;
    }

  for (count=0;count<number_of_streams;count++){
    res = DVDIsSubpictureStreamEnabled((DVDNav_t*)navigator, (DVDStream_t)count , &enabled);
    if(res != DVD_E_Ok) {
      DVDPerror("DVDIsSubpictureStreamEnabled Failure\n",res);
      break;
      }
    if (!enabled) continue;

    name = getSubpictureName(count);
    if (filter_subpicture_entry && name.empty()) continue;

    command=new FXMenuRadio(subpicturemenu,name,&subpicture_target,FXDataTarget::ID_OPTION+count);
    if (stream==count && shown) subpicture_id=count;
    command->create();
    }
}


//----------------------------------------------------------------------------------
// Construct Audio Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_audio_menu(){

  // delete current ones
  while(audiomenu->getFirst()){
    delete audiomenu->getFirst();
    }  

  if (navigator==NULL) return;

  DVDResult_t res;
  DVDStream_t stream;
  DVDAudioAttributes_t Attr;

  int number_of_streams;
  int count=0;
  DVDBool_t enabled;
  FXString audioformat;
  FXString audioext;
  FXString audiomode;
  FXString audioname;
  FXbool audio_enabled=FALSE;
  FXint firststream=0;
  FXint actualstreams=0;

  res = DVDGetCurrentAudio((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("Could not retrieve audio formats\n",res);
    return;
    }

  if (number_of_streams==0) {
     FXMenuRadio * cap = new FXMenuRadio(audiomenu,"Off",&audio_target,FXDataTarget::ID_OPTION+AUDIO_OFF);
     cap->create();
     return;
     }

  for (count=0;count<number_of_streams;count++){
    res = DVDIsAudioStreamEnabled((DVDNav_t*)navigator, (DVDStream_t)count , &enabled);
    if(res != DVD_E_Ok) {
      DVDPerror("DVDIsAudioStreamEnabled Failure\n",res);
      break;
      }
    if (enabled) {
      audioname=getAudioName(count);    
      FXMenuCommand * command = new FXMenuRadio(audiomenu,audioname,&audio_target,FXDataTarget::ID_OPTION+count);
      if (stream==count) {
         audio_id=count;
         audio_enabled=TRUE;
         }
      command->create();
      actualstreams++;
      if (actualstreams==1) firststream=count;      
      }
    }
  
  /// Turn on the First Audio Stream if nothing was enabled.
  if ((actualstreams>0) && !audio_enabled && auto_audiostream){
    res = DVDAudioStreamChange((DVDNav_t*)navigator,firststream);
    if(res != DVD_E_Ok) {
      DVDPerror("Goggles: DVDAudioStreamChange", res);
      return;
      }
    audio_id=firststream;
    }
  audiomenu->recalc();   
  audiomenu->update();
  audiomenu->forceRefresh();
  }


//----------------------------------------------------------------------------------
// Construct Angle Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_angle_menu(){

  // delete current ones
  while(anglemenu->getFirst()){
    delete anglemenu->getFirst();
    }  


  if (navigator==NULL) return;

  DVDResult_t res;
  DVDAngle_t stream;

  int number_of_streams=0;
  int count=0;

  res = DVDGetCurrentAngle((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetCurrentAngle\n",res);
    return;
    }

  if (number_of_streams==0){
     FXMenuRadio * cap = new FXMenuRadio(anglemenu,"None",&audio_target,FXDataTarget::ID_OPTION+AUDIO_OFF);
     cap->create();
     return;
     }


  while(count<number_of_streams) {
      FXMenuRadio * command = new FXMenuRadio(anglemenu,FXStringFormat("Angle %d",count+1),&angle_target,FXDataTarget::ID_OPTION+count);
      command->create();
      count++;
      }
  }


long DVDWindow::onCmdTimePlay(FXObject*,FXSelector,void*ptr){
//  DVDTimecode_t code;
/*
  FXuint hours=value/3600;
  FXuint minutes=(value/60)-(hours*60);
  FXuint seconds=value-((minutes*60)+(hours*3600));

  code.Hours=hours;
  code.Minutes=minutes;
  code.Seconds=seconds;
  code.Frames=0;

  res = DVDTimeSearch((DVDNav_t*)navigator,code); 
  if (res != DVD_E_Ok){
    DVDPerror("DVDTimeSearch",res);
    return 1;
    }
*/
  DVDResult_t res;
  FXuint seconds=(FXuint)(FXuval)ptr;
  FXuint skip=seconds-current_time;
  res=DVDTimeSkip((DVDNav_t*)navigator,skip);
  if (res!=DVD_E_Ok){
    DVDPerror("DVDTimeSkip",res);
    }
  return 1;
  }

long DVDWindow::onChgSlider(FXObject*,FXSelector,void*ptr){
  FXuint hours;
  FXuint minutes;
  FXuint seconds;

  FXuint temp_current=(FXuint)(FXuval)(ptr);

  hours = (FXuint) floor(temp_current/3600.);
  temp_current -= (FXuint) (3600.*hours);
  
  minutes = (FXuint) floor(temp_current / 60.);
  temp_current -= (FXuint) (60.*minutes);

  seconds = temp_current;
  
  infolabel->setText(FXStringFormat("%d:%.2d:%.2d of %d:%.2d:%.2d - %gx",hours,minutes,seconds,location.title_total.Hours,location.title_total.Minutes,location.title_total.Seconds,fspeed));
  return 1;
  }
   
long DVDWindow::onUpdSlider(FXObject* sender,FXSelector,void*){
  if (dvd_started)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  progressbar->setValue(current_time);
  return 1;
  }

long DVDWindow::onSliderPress(FXObject*,FXSelector,void*ptr){
  is_seeking=!is_seeking;
  return 0;
  }

long DVDWindow::onSliderRelease(FXObject*,FXSelector,void*ptr){
  is_seeking=FALSE;
  return 0;
  }



//----------------------------------------------------------------------------------
// Right Click Popup Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuPopup(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXMenuPane pane(this);
  new FXMenuCascade(&pane,"&Goto",icon_goto,gotomenu);
  FXMenuCascade *audiocascade=new FXMenuCascade(&pane,"&Audio",icon_audio,audiomenu);
  FXMenuCascade *subpicturecascade=new FXMenuCascade(&pane,"&Subpicture",icon_subpicture,subpicturemenu);
  FXMenuCascade *anglecascade=new FXMenuCascade(&pane,"&Angle",icon_angle,anglemenu);
  new FXMenuSeparator(&pane);
  new FXMenuCheck(&pane,"&Fullscreen",this,ID_TOGGLE_FULLSCREEN);

//  new FXMenuCascade(&pane,"&Options",NULL,optionmenu);
//  new FXMenuCascade(&pane,"&Help",NULL,helpmenu);

  if (!angletitle->isEnabled())       anglecascade->disable();   
  if (!subpicturetitle->isEnabled())  subpicturecascade->disable();
  if (!audiotitle->isEnabled())       audiocascade->disable();  

  pane.create();
  pane.popup(NULL,event->root_x+3,event->root_y+3);
  getApp()->runPopup(&pane);
  return 1;
  }





//----------------------------------------------------------------------------------
// ShortCut Editor Handler
//
// A New shortcut has been entered. We need to parse and if right adjust current 
// shortcut.
// Else give feedback..
//
//----------------------------------------------------------------------------------
long DVDWindow::onCmdEditShortCut(FXObject*,FXSelector selector,void* ptr){
  FXString shortcut=FXString((FXchar*)ptr);
  
  FXString regentry;
  FXString defregentry;
  FXSelector selentry=0;
  FXHotKey key=fxparseAccel(shortcut);


  if (key) {

    /// Find Duplicate if found, don't change the current one...
    if (getAccelTable()->hasAccel(key)){
      FXMessageBox::error(this,MBOX_OK,"Shortcut already in use!","The Shortcut you're trying to enter is already being used.");
      return 1;
      }

    /// Not a duplicate
    switch(FXSELID(selector)){
      case ID_SHORTCUT_FULLSCREEN     : selentry=FXSEL(SEL_COMMAND,ID_TOGGLE_FULLSCREEN); regentry="FullScreen";      defregentry=DEFAULT_SHORTCUT_FULLSCREEN;    break;
      case ID_SHORTCUT_RAISE          : selentry=FXSEL(SEL_COMMAND,ID_RAISE_CONTROL);     regentry="Raise";           defregentry=DEFAULT_SHORTCUT_RAISE;         break;
      case ID_SHORTCUT_TITLEMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_TITLE);        regentry="TitleMenu";       defregentry=DEFAULT_SHORTCUT_TITLEMENU;     break;
      case ID_SHORTCUT_ROOTMENU       : selentry=FXSEL(SEL_COMMAND,ID_MENU_ROOT);         regentry="RootMenu";        defregentry=DEFAULT_SHORTCUT_ROOTMENU;      break;
      case ID_SHORTCUT_AUDIOMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_AUDIO);        regentry="AudioMenu";       defregentry=DEFAULT_SHORTCUT_AUDIOMENU;     break;
      case ID_SHORTCUT_ANGLEMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_ANGLE);        regentry="AngleMenu";       defregentry=DEFAULT_SHORTCUT_ANGLEMENU;     break;
      case ID_SHORTCUT_SUBPICTUREMENU : selentry=FXSEL(SEL_COMMAND,ID_MENU_SUBPICTURE);   regentry="SubtitleMenu";    defregentry=DEFAULT_SHORTCUT_SUBPICTUREMENU;break;
      case ID_SHORTCUT_PAUSE          : selentry=FXSEL(SEL_COMMAND,ID_PAUSE);             regentry="Pause";           defregentry=DEFAULT_SHORTCUT_PAUSE;         break;
      case ID_SHORTCUT_STOP           : selentry=FXSEL(SEL_COMMAND,ID_STOP);              regentry="Stop";            defregentry=DEFAULT_SHORTCUT_STOP;          break;
      case ID_SHORTCUT_NEXT           : selentry=FXSEL(SEL_COMMAND,ID_NEXT);              regentry="Next";            defregentry=DEFAULT_SHORTCUT_NEXT;          break;
      case ID_SHORTCUT_PREVIOUS       : selentry=FXSEL(SEL_COMMAND,ID_PREVIOUS);          regentry="Previous";        defregentry=DEFAULT_SHORTCUT_PREVIOUS;      break;
      case ID_SHORTCUT_SEARCHFORWARD  : selentry=FXSEL(SEL_COMMAND,ID_SEARCH_FORWARD);    regentry="SearchForward";   defregentry=DEFAULT_SHORTCUT_SEARCHFORWARD; break;
      case ID_SHORTCUT_SEARCHBACKWARD : selentry=FXSEL(SEL_COMMAND,ID_SEARCH_BACKWARD);   regentry="SearchBackward";  defregentry=DEFAULT_SHORTCUT_SEARCHBACKWARD;break;
      case ID_SHORTCUT_ENTER          : selentry=FXSEL(SEL_COMMAND,ID_ENTER);             regentry="Enter";           defregentry=DEFAULT_SHORTCUT_ENTER;         break;
      case ID_SHORTCUT_UP             : selentry=FXSEL(SEL_COMMAND,ID_NAV_UP);            regentry="NavUp";           defregentry=DEFAULT_SHORTCUT_NAVUP;         break;
      case ID_SHORTCUT_DOWN           : selentry=FXSEL(SEL_COMMAND,ID_NAV_DOWN);          regentry="NavDown";         defregentry=DEFAULT_SHORTCUT_NAVDOWN;       break;    
      case ID_SHORTCUT_LEFT           : selentry=FXSEL(SEL_COMMAND,ID_NAV_LEFT);          regentry="NavLeft";         defregentry=DEFAULT_SHORTCUT_NAVLEFT;       break;
      case ID_SHORTCUT_RIGHT          : selentry=FXSEL(SEL_COMMAND,ID_NAV_RIGHT);         regentry="NavRight";        defregentry=DEFAULT_SHORTCUT_NAVRIGHT;      break;
      }

    /// Remove Old One
    getAccelTable()->removeAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys",regentry.text(),defregentry.text())));
  
    /// Replace Accellerator Key
    getAccelTable()->addAccel(key,this,selentry);

    /// Add Key to Registry
    getApp()->reg().writeStringEntry("HotKeys",regentry.text(),shortcut.text());


    }
  else {
    getApp()->beep();
    }
  return 1;
  }

//----------------------------------------------------------------------------------
// Directory Selector Dialog
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSelectDirectory(FXObject*,FXSelector selector,void*){
  if (FXSELID(selector)==ID_GETDVDROOTDIR){
    FXFileDialog dialog(this,"Select DVD device, DVD mount point or directory...");
    dialog.setFilename(dvdroot);
    if (dialog.execute()){
      dvdroot = dialog.getFilename();
      } 
    return 1;
    }
  else if (FXSELID(selector)==ID_GETBOOKMARKDIR){
    FXDirDialog dialog(this,"Select Bookmark Directory...");
    dialog.setDirectory(bookmarkdir);
    if (dialog.execute()){
      bookmarkdir = dialog.getDirectory();
      } 
    return 1;
    }
  return 1;
  }



//----------------------------------------------------------------------------------
// About Dialog
//----------------------------------------------------------------------------------
long DVDWindow::onCmdAbout(FXObject *,FXSelector,void*){
  FXDialogBox dialog(this,"About Goggles");
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXHorizontalFrame * logoframe=new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
  new FXImageFrame(logoframe,img_fox,FRAME_SUNKEN);
  FXImageFrame * frame =new FXImageFrame(logoframe,img_ogle,FRAME_SUNKEN);
  frame->setBackColor(FXRGB(255,255,255));
  FXVerticalFrame * textframe=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXLabel(textframe,FXStringFormat("Goggles  v%d.%d.%d - %s - %s\nCopyright (C) 2002-2003 Sander Jansen. All Rights Reserved\n\nGoggles uses FOX Toolkit version %d.%d.%d\n%s\n\nOriginal \"Goggles\" Logo designed by Gyurka Jansen\n(http://glas.its.tudelft.nl/~gyurka).\n\nSupport: sander@knology.net",GOGGLES_MAJOR,GOGGLES_MINOR,GOGGLES_LEVEL,BUILD_DATE,BUILD_TIME,FOX_MAJOR,FOX_MINOR,FOX_LEVEL,getApp()->copyright),NULL,LAYOUT_FILL_X|JUSTIFY_LEFT);
  new FXSeparator(main,SEPARATOR_LINE|LAYOUT_FILL_X);
  new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
  dialog.execute(PLACEMENT_SCREEN);
  return 1;
  }




//----------------------------------------------------------------------------------
// Get the Subpicture Name for Stream
//----------------------------------------------------------------------------------
FXString DVDWindow::getSubpictureName(FXuint id){
  FXString subpicture_ext;
  DVDResult_t res;
  DVDSubpictureAttributes_t Attr;

  res = DVDGetSubpictureAttributes((DVDNav_t*)navigator, (DVDStream_t)id , &Attr);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetSubpictureAttributes Failure\n",res);
    return FXString("Unknown");
    }
  
  switch(Attr.LanguageExtension){
    case DVD_SUBPICTURE_LANG_EXT_NotSpecified               : subpicture_ext=""; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalCaptions             : subpicture_ext=" Captions"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigCaptions                : subpicture_ext=" Captions (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensCaptions          : subpicture_ext=" Captions (Children's)"; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalCC                   : subpicture_ext=" Closed Captions"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigCC                      : subpicture_ext=" Closed Captions (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensCC                : subpicture_ext=" Closed Captions (Children's)"; break;
    case DVD_SUBPICTURE_LANG_EXT_Forced                     : subpicture_ext=" Forced"; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalDirectorsComments    : subpicture_ext=" Director's Comments"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigDirectorsComments       : subpicture_ext=" Director's Comments (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensDirectorsComments : subpicture_ext=" Director's Comments (Children's)"; break;
    }
  return FXString(getLanguageName(Attr.Language) + subpicture_ext);
  }



//----------------------------------------------------------------------------------
// Get the Audio Name for Stream
//----------------------------------------------------------------------------------
FXString DVDWindow::getAudioName(FXuint id){
  FXString audiomode;
  FXString audioformat;
  FXString audioext;
  FXString audiotype;

  DVDResult_t res;
  DVDAudioAttributes_t Attr;


  res = DVDGetAudioAttributes((DVDNav_t*)navigator, (DVDStream_t)id , &Attr);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetAudioAttributes Failure\n",res);
    return FXString("Unknown");
    }
  
  switch(Attr.AudioFormat) {
    case DVD_AUDIO_FORMAT_AC3       : audioformat="AC3";            break;
    case DVD_AUDIO_FORMAT_MPEG1     : audioformat="MPEG1";          break;
    case DVD_AUDIO_FORMAT_MPEG1_DRC : audioformat="MPEG1 DRC";      break;
    case DVD_AUDIO_FORMAT_MPEG2     : audioformat="MPEG2";          break;
    case DVD_AUDIO_FORMAT_MPEG2_DRC : audioformat="MPEG2 DRC";      break;
    case DVD_AUDIO_FORMAT_LPCM      : audioformat="LPCM";           break;
    case DVD_AUDIO_FORMAT_DTS       : audioformat="DTS";            break;
    case DVD_AUDIO_FORMAT_SDDS      : audioformat="SDDS";           break;
    case DVD_AUDIO_FORMAT_Other     : audioformat="Other";          break;
    default                         : audioformat="???"; break;
    }
      
  switch(Attr.LanguageExtension){
    case DVD_AUDIO_LANG_EXT_NotSpecified        : audioext="";break;
    case DVD_AUDIO_LANG_EXT_NormalCaptions      : audioext="";break;
    case DVD_AUDIO_LANG_EXT_VisuallyImpaired    : audioext=" Visually Impaired";break;
    case DVD_AUDIO_LANG_EXT_DirectorsComments1  : audioext=" Director's Commentary 1";break;
    case DVD_AUDIO_LANG_EXT_DirectorsComments2  : audioext=" Director's Commentary 2";break;
    }

  switch(Attr.AppMode){
    case DVD_AUDIO_APP_MODE_None        : audiomode="";break;
    case DVD_AUDIO_APP_MODE_Karaoke     : audiomode=" Karaoke";break;
    case DVD_AUDIO_APP_MODE_Surround    : audiomode=" Surround";break;
    case DVD_AUDIO_APP_MODE_Other       : audiomode=" Other";break;
    }
/*  
  switch(Attr.NumberOfChannels){
    case 0:  audiotype=""; break;
    case 1:  audiotype=" 1.0"; break;
    case 2:  audiotype=" 2.0"; break;
    case 3:  audiotype=" 3.0"; break;
    case 4:  audiotype=" 4.0"; break;
    case 5:  audiotype=" 5.1"; break;
    case 6:  audiotype=" 6.1"; break;
    }
*/

  return FXString(getLanguageName(Attr.Language)+" ("+audioformat + audiotype + audiomode + ")" + audioext);     
  }



