.TH NEARNEIGHBOR l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
nearneighbor \- A "Nearest neighbor" gridding algorithm
.SH SYNOPSIS
\fBnearneighbor\fP [ \fIxyzfile(s)\fP ] \fB\-G\fP\fIout_grdfile\fP \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]]  
\fB\-N\fP\fIsectors\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] \fB\-S\fP\fIsearch_radius\fP[\fBm\fP|\fBc\fP|\fBk\fP|\fBK\fP] 
[ \fB\-E\fP\fIempty\fP ] [ \fB\-F\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-L\fP\fIflag\fP ] [ \fB\-V\fP ] [ \fB\-W\fP ] 
[ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBnearneighbor\fP reads arbitrarily located (x,y,z[,w]) triples [quadruplets]
from standard input [or \fIxyzfile(s)\fP] and uses a nearest neighbor algorithm to assign 
an average value to each node that have one or more points within a radius centered on the node.
The average value is computed as a weighted mean of the nearest point from each sector inside the search radius.  The
weighting function used is w(r) = 1 / (1 + d ^ 2), where d = 3 * r / search_radius and r is
distance from the node.  This weight is modulated by the observation points' weights [if supplied].\"'
.TP
\fIxyzfile(s)\fP
3 [or 4, see \fB\-W\fP] column ASCII file(s) [or binary, see \fB\-b\fP] holding (x,y,z[,w]) data values.  If no file is specified, \fBnearneighbor\fP
will read from standard input.
.TP
.B \-G
Give the name of the output grdfile.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-N
The circular area centered on each node is divided into several sectors.  Average values
will only be computed if there is at least one value inside each of the sectors for a
given node.  Nodes that fail this test are assigned the value NaN (but see \fB\-E\fP).  [Default is quadrant
search, i.e., \fIsectors\fP = 4].  Note that only the nearest value per sector enters into the averaging, not all values inside the circle.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.TP
.B \-S
Sets the \fIsearch_radius\fP in same units as the grid spacing; append \fBm\fP to indicate minutes
or \fBc\fP to indicate seconds.  Append \fBk\fP to indicate km (implies \fB\-R\fP and \fB\-I\fP are in degrees, and
we will use a fast flat Earth approximation to calculate distance).  For more accuracy, use uppercase \fBK\fP
if distances should be calculated along geodesics.
However, if the current \fBELLIPSOID\fP is set to Sphere then spherical great circle calculations are used.
.SH OPTIONS
.TP
.B \-E
Set the value assigned to empty nodes [NaN].
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-L
Boundary condition \fIflag\fP may be \fIx\fP or \fIy\fP or \fIxy\fP indicating data is periodic in range of 
x or y or both set by \fB\-R\fP, or \fIflag\fP may be \fIg\fP indicating geographical conditions (x and y are 
lon and lat).  [Default is no boundary conditions].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-W
Input data have a 4th column containing observation point weights.  These are multiplied
with the geometrical weight factor to determine the actual weights used in the calculations.
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 (or 4 if \fB\-W\fP is set) columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH GRID VALUES PRECISION
Regardless of the precision of the input data, GMT programs that create
gridded files will internally hold the grids in 4-byte floating point
arrays.  This is done to conserve memory and futhermore most if not all
real data can be stored using 4-byte floating point values.  Data with
higher precision (i.e., double precision values) will loose that precision
once GMT operates on the grid or writes out new grids.  To limit loss
of precision when processing data you should always consider normalizing
the data prior to processing.
.SH EXAMPLES
.sp
To create a gridded data set from the file seaMARCII_bathy.lon_lat_z using a 0.5 min grid,
a 5 km search radius, using an octant search, and set empty nodes to -9999:
.sp
\fBnearneighbor\fP seaMARCII_bathy.lon_lat_z \fB\-R\fP242/244/-22/-20 \fB\-I\fP.5\fBm \-E\fP-9999 \fB\-G\fPbathymetry.grd
\fB\-S\fP5k \fB\-N\fP8
.br
.sp
To make a global gridded file from the data in geoid.xyz using a 1 degree grid,
a 200 km search radius, spherical distances, using an quadrant search, and set empty nodes to NaN, run
.sp
\fBnearneighbor\fP geoid.xyz \fB\-R\fP0/360/-90/90 \fB\-I\fP1 \fB\-L\fPg \fB\-G\fPgeoid.grd
\fB\-S\fP20K \fB\-N\fP4
.SH "SEE ALSO"
.IR blockmean (l),
.IR blockmedian (l),
.IR blockmode (l),
.IR GMT (l),
.IR surface (l),
.IR triangulate (l)
