.TH GRDREFORMAT l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
grdreformat \- Converting between different grdfile formats.
.SH SYNOPSIS
\fBgrdreformat\fP \fIingrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/NaNvalue\fP]]] 
\fIoutgrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/NaNvalue\fP]]] 
 [ \fB\-N\fP ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdreformat\fP reads a grdfile in one format and writes it out using another format.  As an option the
user may select a subset of the data to be written and to specify scaling, translation, and NaN-value.
.TP
\fIingrdfile\fP
The grdfile to be read.  Append format =\fIid\fP code if not a standard COARDS-compliant netCDF grdfile.
If =\fIid\fP is set (see below), you may optionally append \fIscale\fP and \fIoffset\fP.
These options will scale the data and then offset them with the specified amounts after reading.
.br
If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represents 'Not-a-Number' (for floating-point grids this
is unnecessary since the IEEE NaN is used; however integers need a value which means no data available.)
.TP
\fIoutgrdfile\fP
The grdfile to be written.  Append format =\fIid\fP code if not a standard COARDS-compliant netCDF grdfile.
If =\fIid\fP is set (see below), you may optionally append \fIscale\fP and \fIoffset\fP.
These options are particularly 
practical when storing the data as integers, first removing an offset and then scaling down the values.
Since the scale and offset are applied in reverse order when reading, this does not affect the data
values (except for round-offs).
.br
If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represents 'Not-a-Number' (for floating-point grids this
is unnecessary since the IEEE NaN is used; however integers need a value which means no data available.)
.SH OPTIONS
.TP
.B \-N
Suppress the writing of the \fBGMT\fP header structure.  This is useful when you want to write a native grid to
be used by \fBgrdraster\fP.  It only applies to native grids and is ignored for netCDF output.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH FORMAT IDENTIFIER
By default, grids will be written as floating point data stored in binary files using the netCDF format and
meta-data structure. This format is conform the COARDS conventions. \fBGMT\fP versions prior to 4.1 produced
netCDF files that did not conform to these conventions. Although these files are still supported, their use is
depreciated. To write other than floating point COARDS-compliant netCDF files, append the =\fIid\fP suffix
to the filename \fIoutgrdfile\fP.
.br
When reading files, \fBgrdreformat\fP and other \fBGMT\fP programs will automatically recognize any type
of netCDF grdfile. These can be in either COARDS-compliant or pre-4.1 format, and contain floating-point or
integer data. To read other types of grdfiles, append the =\fIid\fP suffix to the filename \fIingrdfile\fP.
.br
.sp
\fIid\fP	\fIGMT 4 netCDF standard formats\fP
.br
nb	GMT netCDF format (byte) (COARDS-compliant)
.br
ns	GMT netCDF format (short) (COARDS-compliant)
.br
ni	GMT netCDF format (integer) (COARDS-compliant)
.br
nf	GMT netCDF format (float) (COARDS-compliant)
.br
nd	GMT netCDF format (double) (COARDS-compliant)
.br
.sp
\fIid\fP	\fIGMT 3 netCDF legacy formats\fP
.br
cb	GMT netCDF format (byte) (depreciated)
.br
cs	GMT netCDF format (short) (depreciated)
.br
ci	GMT netCDF format (integer) (depreciated)
.br
cf	GMT netCDF format (float) (depreciated)
.br
cd	GMT netCDF format (double) (depreciated)
.br
.sp
\fIid\fP	\fIGMT native binary formats\fP
.br
bm	GMT native, C-binary format (bit-mask)
.br
bb	GMT native, C-binary format (byte)
.br
bs	GMT native, C-binary format (short)
.br
bi	GMT native, C-binary format (integer)
.br
bf	GMT native, C-binary format (float)
.br
bd	GMT native, C-binary format (double)
.br
.sp
\fIid\fP	\fIMiscellaneous formats\fP
.br
rb	SUN rasterfile format (8-bit standard)
.br
rf	GEODAS grid format GRD98 (NGDC)
.br
sf	Golden Software Surfer format 6 (float)
.br
sd	Golden Software Surfer format 7 (double, read-only)
.br
.SH GMT STANDARD NETCDF FILES
The standard format used for gdrfiles is based on netCDF and conforms to the COARDS conventions. Files written
in this format can be read by numerous third-party programs and are platform-independent. Some disk-space
can be saved by storing the data as bytes or shorts in stead of integers. Use the \fIscale\fP and \fIoffset\fP
parameters to make this work without loss of data range or significance. For more details, see Appendix B.
.PP
\fBMulti-variable grid files\fP
.br
By default, \fBGMT\fP programs will read the first 2-dimensional grid contained in a COARDS-compliant netCDF file.
Alternatively, use \fIingrdfile\fP\fB?\fP\fIvarname\fP (ahead of any optional suffix \fB=\fP\fIid\fP)
to specify the requested variable \fIvarname\fP.
Since \fB?\fP has special meaning as a wildcard, escape this meaning by placing the full filename and suffix
between quotes.
.PP
\fB3-Dimensional grids\fP
.br
To extract one \fIlayer\fP or \fIlevel\fP from a 3-dimensional grid stored in a COARDS-compliant netCDF file,
append both the name of the variable and the index associated with the layer (starting at zero) in the form:
\fIingrdfile\fP\fB?\fP\fIvarname\fP\fB[\fP\fIlayer\fP\fB]\fP.
Alternatively, specify the value associated with that layer using parentheses in stead of brackets:
\fIingridfile\fP\fB?\fP\fIvarname\fP\fB(\fP\fIlevel\fP\fB)\fP.
Since question marks, brackets and parentheses have special meanings on the command line, escape these meanings
by placing the full filename and suffix between quotes.
.SH NATIVE BINARY FILES
For binary native \fBGMT\fP files the size of the \fBGMT\fP grdheader block is \fIhsize\fP = 896 bytes, and the total size of the file
is \fIhsize\fP + \fInx\fP * \fIny\fP * \fIitem_size\fP, where \fIitem_size\fP is the size in bytes of each element (1, 2, 4).  Bit grids
are stored using 4-byte integers, each holding 32 bits, so for these files the size equation is modified by
using ceil (\fInx\fP / 32) * 4 instead of \fInx\fP.
Note that these files are platform-dependent. Files written on Little Endian machines (e.g. PCs) can not be
read on Big Endian machines (e.g. most workstations).
For header and grid details, see Appendix B.
.SH GRID VALUES PRECISION
Regardless of the precision of the input data, GMT programs that create
gridded files will internally hold the grids in 4-byte floating point
arrays.  This is done to conserve memory and futhermore most if not all
real data can be stored using 4-byte floating point values.  Data with
higher precision (i.e., double precision values) will loose that precision
once GMT operates on the grid or writes out new grids.  To limit loss
of precision when processing data you should always consider normalizing
the data prior to processing.
.SH EXAMPLES
To extract the second layer from a 3-dimensional grid named temp from a COARDS-compliant netCDF file
climate.grd:
.br
.sp
\fBgrdreformat\fP climate.grd?temp[1] temp.grd \fB-V\fP
.br
.sp
To create a 4-byte native floating point grid from the COARDS-compliant netCDF file data.grd:
.br
.sp
\fBgrdreformat\fP data.grd ras_data.b4=bf \fB\-V\fP
.br
.sp
To make a 2-byte short integer file, scale it by 10, subtract 32000, setting
NaNs to -9999, do
.br
.sp
\fBgrdreformat\fP values.grd shorts.i2=bs/10/-32000/-9999 \fB\-V\fP
.br
.sp
To create a Sun standard 8-bit rasterfile for a subset of the data file image.grd,
assuming the range in image.grd is 0-1 and we need 0-255, run
.br
.sp
\fBgrdreformat\fP image.grd \fB\-R\fP-60/-40/-40/-30 image.ras8=rb/255/0 \fB\-V\fP
.br
.sp
To convert etopo2.grd to etopo2.i2 that can be used by \fBgrdraster\fP, try
.br
.sp
\fBgrdreformat\fP etopo2.grd etopo2.i2=bs \fB\-N \-V\fP
.SH "SEE ALSO"
.IR GMT (l),
.IR grdmath (l)
