.TH GMT l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
GMT \- The Generic Mapping Tools data processing and display software package
.SH INTRODUCTION
\fBGMT\fP is a collection of public-domain Unix tools that allows you to manipulate x,y
and x,y,z data sets (filtering, trend fitting, gridding, projecting, etc.)
and produce \fIPostScript\fP illustrations ranging from simple x-y plots, via
contour maps, to artificially illuminated surfaces and 3-d perspective
views in black/white or 24bit color.  Linear, log10, and power scaling is supported in
addition to 25 common map projections.  The processing and display routines within \fBGMT\fP
are completely general and will handle any (x,y) or (x,y,z) data as input.
.SH SYNOPSIS
\fBGMT\fP is also a wrapper script that can start any of the programs:
.br
.sp
\fBGMT\fP module module-options
.br
.sp
where module is the name of a \fBGMT\fP program and the options are those that pertain to
that particular program.
.SH GMT OVERVIEW
The following is a summary of all the programs supplied with \fBGMT\fP and
a very short description of their purpose. Detailed information about each program can
be found in the separate manual pages.
.br
.sp
\fBblockmean\fP		L2 (x,y,z) data filter/decimator
.br
\fBblockmedian\fP	L1 (x,y,z) data filter/decimator
.br
\fBblockmode\fP		Mode (x,y,z) data filter/decimator
.br
\fBfilter1d\fP		Filter 1-D data sets (time series)
.br
\fBfitcircle\fP		Finds the best-fitting great circle to a set of points
.br
\fBgmt2rgb\fP		Convert Sun rasterfile or grid to r, g, b grids
.br
\fBgmtconvert\fP	Convert between ASCII and binary 1-D tables
.br
\fBgmtdefaults\fP	List the current default settings
.br
\fBgmtmath\fP		Mathematical operations on data tables
.br
\fBgmtset\fP		Set individual default parameters
.br
\fBgmtselect\fP		Extract data subsets based on spatial criteria
.br
\fBgrdfilter\fP		Filter 2-D data sets in the space domain
.br
\fBgrd2cpt\fP		Make a color palette table from a grdfile
.br
\fBgrd2xyz\fP		Conversion from 2-D gridded file to table data
.br
\fBgrdblend\fP		Blend several partially over-lapping grdfiles onto one grid
.br
\fBgrdclip\fP		Limit the z-range in gridded data
.br
\fBgrdcontour\fP	Contouring of 2-D gridded data
.br
\fBgrdcut\fP		Cut a sub-region from a grd file
.br
\fBgrdedit\fP		Modify header information in a 2-D gridded file
.br
\fBgrdfft\fP		Operate on grdfiles in the frequency domain
.br
\fBgrdgradient\fP	Compute directional gradient from grdfiles
.br
\fBgrdhisteq\fP		Histogram equalization for grdfiles
.br
\fBgrdimage\fP		Produce images from 2-D gridded data
.br
\fBgrdinfo\fP		Get information about grd files
.br
\fBgrdlandmask\fP	Create mask grdfile from shoreline data base
.br
\fBgrdmask\fP		Reset nodes outside a clip path to a constant
.br
\fBgrdmath\fP		Mathematical operations on grdfiles
.br
\fBgrdpaste\fP		Paste together grdfiles along a common edge
.br
\fBgrdproject\fP	Project gridded data onto a new coordinate system
.br
\fBgrdreformat\fP	Converting between different grdfile formats
.br
\fBgrdsample\fP		Resample a 2-D gridded data set onto a new grid
.br
\fBgrdtrend\fP		Fits polynomial trends to grdfiles
.br
\fBgrdtrack\fP		Sampling of 2-D data set along 1-D track
.br
\fBgrdvector\fP		Plot vector fields from grdfiles
.br
\fBgrdview\fP		3-D perspective imaging of 2-D gridded data
.br
\fBgrdvolume\fP		Volume calculations from 2-D gridded data
.br
\fBmakecpt\fP		Make \fBGMT\fP color palette tables
.br
\fBmapproject\fP	Forward or inverse map projections of table data
.br
\fBminmax\fP		Find extreme values in data tables
.br
\fBnearneighbor\fP	Nearest-neighbor gridding scheme
.br
\fBproject\fP		Project data onto lines/great circles
.br
\fBpsbasemap\fP		Create a basemap plot
.br
\fBpsclip\fP		Use polygon files to define clipping paths
.br
\fBpscoast\fP		Plot coastlines and filled continents on maps
.br
\fBpscontour\fP		Contour xyz-data by triangulation
.br
\fBpshistogram\fP	Plot a histogram
.br
\fBpsimage\fP		Plot images (EPS or Sun raster files) on maps
.br
\fBpslegend\fP		Plot legend on maps
.br
\fBpsmask\fP		Create overlay to mask out regions on maps
.br
\fBpsrose\fP		Plot sector or rose diagrams
.br
\fBpsscale\fP		Plot grayscale or colorscale on maps
.br
\fBpstext\fP		Plot textstrings on maps
.br
\fBpswiggle\fP		Draw time-series along track on maps
.br
\fBpsxy\fP			Plot symbols, polygons, and lines on maps
.br
\fBpsxyz\fP		Plot symbols, polygons, and lines in 3-D
.br
\fBsample1d\fP		Resampling of 1-D table data sets
.br
\fBspectrum1d\fP	Compute various spectral estimates from time-series
.br
\fBsplitxyz\fP		Split xyz-files into several segments
.br
\fBsurface\fP		A continuous curvature gridding algorithm
.br
\fBtrend1d\fP		Fits polynomial or Fourier trends to y = f(x) data
.br
\fBtrend2d\fP		Fits polynomial trends to z = f(x,y) data
.br
\fBtriangulate\fP	Perform optimal Delaunay triangulation and gridding
.br
\fBxyz2grd\fP		Convert equidistant xyz data to a 2-D grd file
.br
.SH "SEE ALSO"
Look up the individual man pages for details.  By default, these pages are
in \fB$GMTHOME\fP/man/manl, depending on your installation settings.
Information is also available on the \fBGMT\fP home page gmt.soest.hawaii.edu
or locally under \fB$GMTHOME\fP/www/gmt/gmt_services.html
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
