/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.SpanningTreeVisitor;

class RankAssigmentSolver
extends SpanningTreeVisitor {
    DirectedGraph graph;
    EdgeList spanningTree;
    boolean searchDirection;

    RankAssigmentSolver() {
    }

    int depthFirstCutValue(Edge edge, int count) {
        Edge e;
        Node n = this.getTreeTail(edge);
        this.setTreeMin(n, count);
        int cutvalue = 0;
        int multiplier = edge.target == n ? 1 : -1;
        EdgeList list = n.outgoing;
        int i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (e.tree && e != edge) {
                count = this.depthFirstCutValue(e, count);
                cutvalue += (e.cut - e.weight) * multiplier;
            } else {
                cutvalue -= e.weight * multiplier;
            }
            ++i;
        }
        list = n.incoming;
        i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (e.tree && e != edge) {
                count = this.depthFirstCutValue(e, count);
                cutvalue -= (e.cut - e.weight) * multiplier;
            } else {
                cutvalue += e.weight * multiplier;
            }
            ++i;
        }
        edge.cut = cutvalue;
        if (cutvalue < 0) {
            this.spanningTree.add(edge);
        }
        this.setTreeMax(n, count);
        return count + 1;
    }

    Edge enter(Node branch) {
        Edge result = null;
        int minSlack = Integer.MAX_VALUE;
        boolean incoming = this.getParentEdge((Node)branch).target != branch;
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node n = this.searchDirection ? this.graph.nodes.getNode(i) : this.graph.nodes.getNode(this.graph.nodes.size() - 1 - i);
            if (this.subtreeContains(branch, n)) {
                EdgeList edges = incoming ? n.incoming : n.outgoing;
                int j = 0;
                while (j < edges.size()) {
                    Edge e = edges.getEdge(j);
                    if (!this.subtreeContains(branch, e.opposite(n)) && !e.tree && e.getSlack() < minSlack) {
                        result = e;
                        minSlack = e.getSlack();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    int getTreeMax(Node n) {
        return n.workingInts[1];
    }

    int getTreeMin(Node n) {
        return n.workingInts[0];
    }

    void initCutValues() {
        Edge e;
        Node root = this.graph.nodes.getNode(0);
        this.spanningTree = new EdgeList();
        this.setTreeMin(root, 1);
        this.setTreeMax(root, 1);
        int i = 0;
        while (i < root.outgoing.size()) {
            e = root.outgoing.getEdge(i);
            if (this.getSpanningTreeChildren(root).contains(e)) {
                this.setTreeMax(root, this.depthFirstCutValue(e, this.getTreeMax(root)));
            }
            ++i;
        }
        i = 0;
        while (i < root.incoming.size()) {
            e = root.incoming.getEdge(i);
            if (this.getSpanningTreeChildren(root).contains(e)) {
                this.setTreeMax(root, this.depthFirstCutValue(e, this.getTreeMax(root)));
            }
            ++i;
        }
    }

    Edge leave() {
        Edge result = null;
        int minCut = 0;
        int weight = -1;
        int i = 0;
        while (i < this.spanningTree.size()) {
            Edge e = this.spanningTree.getEdge(i);
            if (e.cut < minCut) {
                result = e;
                minCut = result.cut;
                weight = result.weight;
            } else if (e.cut == minCut && e.weight > weight) {
                result = e;
                weight = result.weight;
            }
            ++i;
        }
        return result;
    }

    void networkSimplexLoop() {
        Edge leave;
        int count = 0;
        while ((leave = this.leave()) != null && count < 900) {
            ++count;
            Node leaveTail = this.getTreeTail(leave);
            Node leaveHead = this.getTreeHead(leave);
            Edge enter = this.enter(leaveTail);
            if (enter == null) break;
            this.getSpanningTreeChildren(leaveHead).remove(leave);
            this.setParentEdge(leaveTail, null);
            leave.tree = false;
            this.spanningTree.remove(leave);
            Node enterTail = enter.source;
            if (!this.subtreeContains(leaveTail, enterTail)) {
                enterTail = enter.target;
            }
            Node enterHead = enter.opposite(enterTail);
            this.updateSubgraph(enterTail);
            this.getSpanningTreeChildren(enterHead).add(enter);
            this.setParentEdge(enterTail, enter);
            enter.tree = true;
            this.repairCutValues(enter);
            Node commonAncestor = enterHead;
            while (!this.subtreeContains(commonAncestor, leaveHead)) {
                this.repairCutValues(this.getParentEdge(commonAncestor));
                commonAncestor = this.getTreeParent(commonAncestor);
            }
            while (leaveHead != commonAncestor) {
                this.repairCutValues(this.getParentEdge(leaveHead));
                leaveHead = this.getTreeParent(leaveHead);
            }
            this.updateMinMax(commonAncestor, this.getTreeMin(commonAncestor));
            this.tightenEdge(enter);
        }
    }

    void repairCutValues(Edge edge) {
        Edge e;
        this.spanningTree.remove(edge);
        Node n = this.getTreeTail(edge);
        int cutvalue = 0;
        int multiplier = edge.target == n ? 1 : -1;
        EdgeList list = n.outgoing;
        int i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            cutvalue = e.tree && e != edge ? (cutvalue += (e.cut - e.weight) * multiplier) : (cutvalue -= e.weight * multiplier);
            ++i;
        }
        list = n.incoming;
        i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            cutvalue = e.tree && e != edge ? (cutvalue -= (e.cut - e.weight) * multiplier) : (cutvalue += e.weight * multiplier);
            ++i;
        }
        edge.cut = cutvalue;
        if (cutvalue < 0) {
            this.spanningTree.add(edge);
        }
    }

    void setTreeMax(Node n, int value) {
        n.workingInts[1] = value;
    }

    void setTreeMin(Node n, int value) {
        n.workingInts[0] = value;
    }

    boolean subtreeContains(Node parent, Node child) {
        return parent.workingInts[0] <= child.workingInts[1] && child.workingInts[1] <= parent.workingInts[1];
    }

    void tightenEdge(Edge edge) {
        Node tail = this.getTreeTail(edge);
        int delta = edge.getSlack();
        if (tail == edge.target) {
            delta = -delta;
        }
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node n = this.graph.nodes.getNode(i);
            if (this.subtreeContains(tail, n)) {
                n.rank += delta;
            }
            ++i;
        }
    }

    int updateMinMax(Node root, int count) {
        this.setTreeMin(root, count);
        EdgeList edges = this.getSpanningTreeChildren(root);
        int i = 0;
        while (i < edges.size()) {
            count = this.updateMinMax(this.getTreeTail(edges.getEdge(i)), count);
            ++i;
        }
        this.setTreeMax(root, count);
        return count + 1;
    }

    void updateSubgraph(Node root) {
        Edge flip = this.getParentEdge(root);
        if (flip != null) {
            Node rootParent = this.getTreeParent(root);
            this.getSpanningTreeChildren(rootParent).remove(flip);
            this.updateSubgraph(rootParent);
            this.setParentEdge(root, null);
            this.setParentEdge(rootParent, flip);
            this.repairCutValues(flip);
            this.getSpanningTreeChildren(root).add(flip);
        }
    }

    public void visit(DirectedGraph graph) {
        this.graph = graph;
        this.initCutValues();
        this.networkSimplexLoop();
        if (graph.forestRoot == null) {
            graph.nodes.normalizeRanks();
        } else {
            this.normalizeForest();
        }
    }

    private void normalizeForest() {
        NodeList tree = new NodeList();
        this.graph.nodes.resetFlags();
        this.graph.forestRoot.flag = true;
        EdgeList rootEdges = this.graph.forestRoot.outgoing;
        Stack<Node> stack = new Stack<Node>();
        int i = 0;
        while (i < rootEdges.size()) {
            Node node = rootEdges.getEdge((int)i).target;
            node.flag = true;
            stack.push(node);
            while (!stack.isEmpty()) {
                node = (Node)stack.pop();
                tree.add(node);
                Iterator neighbors = node.iteratorNeighbors();
                while (neighbors.hasNext()) {
                    Node neighbor = (Node)neighbors.next();
                    if (neighbor.flag) continue;
                    neighbor.flag = true;
                    stack.push(neighbor);
                }
            }
            tree.normalizeRanks();
            tree.clear();
            ++i;
        }
    }
}

