% ATAND ATAND Inverse Tangent Degrees Function
% 
% Usage
% 
% Computes the inverse tangent of the argument, but returns
% the argument in degrees instead of radians (as is the case
% for atan. The syntax for its use is
% 
%    y = atand(x)
% 
function y = atand(x)
  if (nargin == 0 || ~isnumeric(x) || ~isreal(x))
    error('atand expects a real numeric input');
  end
  y = rad2deg(atan(x));
