%
% Function run_tests
%
%  Runs the complete set of tests for FreeMat
%  This file is autogenerated by helpgen (the help compiler)
%  Any changes will be lost!
function run_tests
   myloc = which('run_tests');
   [pth,name,sfx] = fileparts(myloc);
   cd(pth);
   testlist = filelist('bbtest_*.m');
   testlist = [testlist;filelist('wbtest_*.m')];
   testlist = [testlist;filelist('test_*.m')];
   cdir = pwd;
   failed = {};
   for i=1:numel(testlist);
     cd(cdir);
     save run_tests.dat cdir testlist failed
     success = eval(testlist{i}(1:end-2));
     cd(cdir);
     load run_tests.dat
     if (isempty(success) || ~success) failed = [failed,testlist(i)]; end;
     printf('Completed test %s\n',testlist{i}(1:end-2));
     close all
   end
   printf('****************************************\n');
   printf('*  Test Summary                        *\n');
   printf('****************************************\n');
   printf('\n');
   printf('Number of tests: %d\n',numel(testlist));
   printf('Failed tests: %d\n',numel(failed));
   for i=1:numel(failed)
      printf('   Test %s failed\n',failed{i});
   end

function list = filelist(pattern)
   q = dir(pattern);
   list = {};
   for i=1:numel(q)
      if (~q(i).isdir)
         list = [list;{q(i).name}];
      end
   end
      