% BITCMP BITCMP Bitwise Boolean Complement Operation
% 
% Usage
% 
% Performs a bitwise binary complement operation on the argument and
% returns the result.  The syntax for its use is
% 
%    y = bitcmp(a)
% 
% where a is an unsigned integer arrays.  This version of the command
% uses as many bits as required by the type of a.  For example, if 
% a is an uint8 type, then the complement is formed using 8 bits.
% The second form of bitcmp allows you to specify the number of bits
% to use, 
% 
%    y = bitcmp(a,n)
% 
% in which case the complement is taken with respect to n bits. 
function y = bitcmp(a,n)
    if (nargin == 1)
        if (isa(a,'int8') || (isa(a,'uint8')))
            n = 8;
        elseif (isa(a,'int16') || (isa(a,'uint16')))
            n = 16;
        elseif (isa(a,'int32') || (isa(a,'uint32')))
            n = 32;
        else
            n = 32;
        end
    end
    y = cast(bin2int(~int2bin(a,n)),typeof(a));
  
  
