% COSH COSH Hyperbolic Cosine Function
% 
% Usage
% 
% Computes the hyperbolic cosine of the argument.
% The syntax for its use is
% 
%    y = cosh(x)
% 
function y = cosh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('cosh expects a numeric input');
  end
  y = (exp(x)+exp(-x))/2;
  
