% ATANH  ATANH Inverse Hyperbolic Tangent Function
% 
% 
% Usage
%  
%  Computes the inverse hyperbolic tangent of its argument.  The general
%  syntax for its use is
%  
%    y = atanh(x)
%  
%  where x is an n-dimensional array of numerical type.
%  


function y = atanh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('atanh expects a single, numeric input');
  end
  y = 0.5*log((1+x)./(1-x));
  
