/* A Bison parser, made by GNU Bison 2.1.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENT = 258,
     NUMERIC = 259,
     ENDQSTMNT = 260,
     ENDSTMNT = 261,
     LE = 262,
     GE = 263,
     EQ = 264,
     DOTTIMES = 265,
     DOTRDIV = 266,
     DOTLDIV = 267,
     DOTPOWER = 268,
     DOTTRANSPOSE = 269,
     STRING = 270,
     SPECIALCALL = 271,
     END = 272,
     IF = 273,
     FUNCTION = 274,
     FOR = 275,
     BREAK = 276,
     MAGICEND = 277,
     WHILE = 278,
     ELSE = 279,
     ELSEIF = 280,
     SWITCH = 281,
     CASE = 282,
     OTHERWISE = 283,
     CONTINUE = 284,
     TRY = 285,
     CATCH = 286,
     FIELD = 287,
     REFLPAREN = 288,
     REFRPAREN = 289,
     PERSISTENT = 290,
     KEYBOARD = 291,
     RETURN = 292,
     VARARGIN = 293,
     VARARGOUT = 294,
     GLOBAL = 295,
     QUIT = 296,
     RETALL = 297,
     SOR = 298,
     SAND = 299,
     NE = 300,
     NOT = 301,
     NEG = 302,
     POS = 303
   };
#endif
/* Tokens.  */
#define IDENT 258
#define NUMERIC 259
#define ENDQSTMNT 260
#define ENDSTMNT 261
#define LE 262
#define GE 263
#define EQ 264
#define DOTTIMES 265
#define DOTRDIV 266
#define DOTLDIV 267
#define DOTPOWER 268
#define DOTTRANSPOSE 269
#define STRING 270
#define SPECIALCALL 271
#define END 272
#define IF 273
#define FUNCTION 274
#define FOR 275
#define BREAK 276
#define MAGICEND 277
#define WHILE 278
#define ELSE 279
#define ELSEIF 280
#define SWITCH 281
#define CASE 282
#define OTHERWISE 283
#define CONTINUE 284
#define TRY 285
#define CATCH 286
#define FIELD 287
#define REFLPAREN 288
#define REFRPAREN 289
#define PERSISTENT 290
#define KEYBOARD 291
#define RETURN 292
#define VARARGIN 293
#define VARARGOUT 294
#define GLOBAL 295
#define QUIT 296
#define RETALL 297
#define SOR 298
#define SAND 299
#define NE 300
#define NOT 301
#define NEG 302
#define POS 303




/* Copy the first part of user declarations.  */
#line 1 "../../../libs/libFreeMat/Parser.yxx"

/*
 * Copyright (c) 2002-2006 Samit Basu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "AST.hpp"
#include "WalkTree.hpp"
#include "FunctionDef.hpp"
#include "ParserInterface.hpp"
#include "Exception.hpp"

#define YYDEBUG 1
#define YYSTYPE ParseRHS

#define MSGBUFLEN 2048
static char msgBuffer[MSGBUFLEN];

#include "LexerInterface.hpp"

//extern char* yytext;
extern int yylex(void);

extern int yydebug;
extern const char *parsing_filename;

bool interactiveMode;

#ifdef WIN32
#define snprintf _snprintf
#endif

namespace FreeMat {
  static ASTPtr mainAST;
  static MFunctionDef *mainMDef;

  void yyerror(const char *s) {
     return;
  }

  void chainFunction(MFunctionDef *r) {
     r->nextFunction = NULL;
     r->prevFunction = NULL;
     if (mainMDef == NULL)
	mainMDef = r;
     else {
	r->localFunction = true;
        r->nextFunction = mainMDef->nextFunction;
	if (r->nextFunction)
	  r->nextFunction->prevFunction = r;
	mainMDef->nextFunction = r;
	r->prevFunction = mainMDef;
     }
  }

  std::string decodeline(ParseRHS val) {
    int tokenID;
    int linenumber, colnumber;
    if (val.isToken) 
      tokenID = val.v.i;
    else
      tokenID = val.v.p->context();
    linenumber = tokenID & 0xFFFF;
    char buffer[256];
    sprintf(buffer,"%d",linenumber);
    return(std::string(buffer));
  }
  
  int yyxpt(std::string xStr, ParseRHS val) {
    char buffer[256];
    int addone = 1;
    int tokenID;
    int linenumber, colnumber;
    if (val.isToken) 
      tokenID = val.v.i;
    else
      tokenID = val.v.p->context();
    linenumber = tokenID & 0xFFFF;
    colnumber = tokenID >> 16;
    if (!interactiveMode)
      snprintf(msgBuffer,MSGBUFLEN,
      "Expecting %s\n\tat line %d, column %d of file %s",
       xStr.c_str(),linenumber,colnumber,parsing_filename);
    else
      snprintf(msgBuffer,MSGBUFLEN,"Expecting %s",xStr.c_str());
    throw Exception(msgBuffer);
    return 0;
  }
}

using namespace FreeMat;



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
typedef int YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 219 of yacc.c.  */
#line 302 "../../../libs/libFreeMat/Parser.cxx"

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T) && (defined (__STDC__) || defined (__cplusplus))
# include <stddef.h> /* INFRINGES ON USER NAME SPACE */
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if defined (__STDC__) || defined (__cplusplus)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     define YYINCLUDED_STDLIB_H
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if (! defined (malloc) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if (! defined (free) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifdef __cplusplus
}
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  99
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2634

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  74
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  49
/* YYNRULES -- Number of rules. */
#define YYNRULES  226
/* YYNRULES -- Number of states. */
#define YYNSTATES  340

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   303

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    68,     2,     2,    46,    60,
      61,    62,    53,    51,    66,    52,    73,    54,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    50,    67,
      47,    63,    48,     2,    70,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    64,    55,    65,    59,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    71,    45,    72,    69,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      49,    56,    57,    58
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     7,     8,    10,    19,    27,    33,
      38,    46,    53,    56,    60,    65,    72,    76,    81,    87,
      95,    97,   100,   103,   106,   111,   114,   117,   121,   126,
     128,   132,   134,   137,   139,   142,   145,   148,   151,   153,
     155,   156,   158,   160,   162,   164,   166,   168,   170,   172,
     174,   176,   178,   180,   182,   184,   186,   189,   192,   195,
     198,   201,   204,   207,   210,   213,   216,   219,   221,   224,
     227,   229,   231,   233,   235,   240,   245,   248,   249,   256,
     263,   265,   267,   269,   271,   273,   275,   277,   278,   280,
     282,   285,   290,   293,   294,   300,   306,   312,   316,   318,
     324,   329,   333,   336,   340,   342,   348,   351,   357,   363,
     366,   372,   376,   379,   382,   383,   385,   387,   390,   393,
     396,   399,   400,   403,   407,   411,   420,   426,   435,   443,
     450,   456,   460,   464,   466,   470,   474,   478,   482,   486,
     490,   494,   498,   502,   506,   510,   514,   518,   522,   526,
     530,   534,   538,   542,   546,   550,   554,   558,   562,   566,
     570,   574,   578,   582,   586,   590,   594,   598,   602,   606,
     610,   613,   616,   619,   622,   626,   630,   634,   638,   641,
     644,   648,   652,   655,   657,   659,   661,   664,   666,   670,
     673,   678,   683,   689,   692,   696,   701,   706,   712,   715,
     718,   720,   723,   727,   730,   734,   738,   742,   745,   750,
     752,   754,   759,   764,   767,   770,   772,   776,   778,   782,
     784,   788,   790,   792,   794,   796,   798
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      75,     0,    -1,    81,    -1,    77,    -1,    -1,     1,    -1,
      19,    78,     3,    61,    79,    62,    96,    81,    -1,    19,
       3,    61,    79,    62,    96,    81,    -1,    19,    78,     3,
      96,    81,    -1,    19,     3,    96,    81,    -1,    19,    78,
       3,    61,    62,    96,    81,    -1,    19,     3,    61,    62,
      96,    81,    -1,    19,     1,    -1,    19,     3,     1,    -1,
      19,     3,    61,     1,    -1,    19,     3,    61,    79,    62,
       1,    -1,    19,    78,     1,    -1,    19,    78,     3,     1,
      -1,    19,    78,     3,    61,     1,    -1,    19,    78,     3,
      61,    79,    62,     1,    -1,    76,    -1,    77,    76,    -1,
      39,    63,    -1,     3,    63,    -1,    64,    79,    65,    63,
      -1,     3,     1,    -1,    64,     1,    -1,    64,    79,     1,
      -1,    64,    79,    65,     1,    -1,    80,    -1,    79,   121,
      80,    -1,     3,    -1,    46,     3,    -1,    82,    -1,    81,
      82,    -1,    83,     5,    -1,    83,     6,    -1,    83,    66,
      -1,   110,    -1,   112,    -1,    -1,   111,    -1,   101,    -1,
      91,    -1,    90,    -1,   103,    -1,   104,    -1,    94,    -1,
      92,    -1,    89,    -1,    88,    -1,    86,    -1,    85,    -1,
      84,    -1,    41,    -1,    42,    -1,     3,     4,    -1,    15,
      15,    -1,     3,    15,    -1,     3,     3,    -1,    84,    15,
      -1,    84,     3,    -1,    84,     4,    -1,    35,    87,    -1,
      35,     1,    -1,    40,    87,    -1,    40,     1,    -1,     3,
      -1,    87,     3,    -1,    87,     1,    -1,    37,    -1,    36,
      -1,    29,    -1,    21,    -1,    30,    81,    93,    17,    -1,
      30,    81,    93,     1,    -1,    31,    81,    -1,    -1,    26,
     112,    95,    97,   100,    17,    -1,    26,   112,    95,    97,
     100,     1,    -1,    66,    -1,     6,    -1,     5,    -1,    67,
      -1,    68,    -1,     6,    -1,     5,    -1,    -1,    98,    -1,
      99,    -1,    98,    99,    -1,    27,   112,    95,    81,    -1,
      28,    81,    -1,    -1,    20,   102,    95,    81,    17,    -1,
      20,   102,    95,    81,     1,    -1,    61,     3,    63,   112,
      62,    -1,     3,    63,   112,    -1,     3,    -1,    61,     3,
      63,   112,     1,    -1,    61,     3,    63,     1,    -1,    61,
       3,     1,    -1,    61,     1,    -1,     3,    63,     1,    -1,
       1,    -1,    23,   112,    95,    81,    17,    -1,    23,     1,
      -1,    23,   112,    95,    81,     1,    -1,    18,   105,   106,
     109,    17,    -1,    18,     1,    -1,    18,   105,   106,   109,
       1,    -1,   112,    95,    81,    -1,   112,    95,    -1,   112,
       1,    -1,    -1,   107,    -1,   108,    -1,   107,   108,    -1,
      25,   105,    -1,    25,     1,    -1,    24,    81,    -1,    -1,
      24,     1,    -1,   114,    63,   112,    -1,   114,    63,     1,
      -1,    64,   119,    65,    63,     3,    61,   117,    62,    -1,
      64,   119,    65,    63,     3,    -1,    64,   119,    65,    63,
       3,    61,   117,     1,    -1,    64,   119,    65,    63,     3,
      61,     1,    -1,    64,   119,    65,    63,     3,     1,    -1,
      64,   119,    65,    63,     1,    -1,   112,    50,   112,    -1,
     112,    50,     1,    -1,   113,    -1,   112,    51,   112,    -1,
     112,    51,     1,    -1,   112,    52,   112,    -1,   112,    52,
       1,    -1,   112,    53,   112,    -1,   112,    53,     1,    -1,
     112,    54,   112,    -1,   112,    54,     1,    -1,   112,    55,
     112,    -1,   112,    55,     1,    -1,   112,    45,   112,    -1,
     112,    45,     1,    -1,   112,    46,   112,    -1,   112,    46,
       1,    -1,   112,    43,   112,    -1,   112,    43,     1,    -1,
     112,    44,   112,    -1,   112,    44,     1,    -1,   112,    47,
     112,    -1,   112,    47,     1,    -1,   112,     7,   112,    -1,
     112,     7,     1,    -1,   112,    48,   112,    -1,   112,    48,
       1,    -1,   112,     8,   112,    -1,   112,     8,     1,    -1,
     112,     9,   112,    -1,   112,     9,     1,    -1,   112,    49,
     112,    -1,   112,    49,     1,    -1,   112,    10,   112,    -1,
     112,    10,     1,    -1,   112,    11,   112,    -1,   112,    11,
       1,    -1,   112,    12,   112,    -1,   112,    12,     1,    -1,
      52,   112,    -1,    51,   112,    -1,    69,   112,    -1,    69,
       1,    -1,   112,    59,   112,    -1,   112,    59,     1,    -1,
     112,    13,   112,    -1,   112,    13,     1,    -1,   112,    60,
      -1,   112,    14,    -1,    61,   112,    62,    -1,    61,   112,
       1,    -1,    61,     1,    -1,     4,    -1,    15,    -1,    22,
      -1,    70,     3,    -1,   114,    -1,    64,   119,    65,    -1,
      64,     1,    -1,    64,   120,   119,    65,    -1,    64,   119,
     120,    65,    -1,    64,   120,   119,   120,    65,    -1,    64,
      65,    -1,    71,   118,    72,    -1,    71,   120,   118,    72,
      -1,    71,   118,   120,    72,    -1,    71,   120,   118,   120,
      72,    -1,    71,    72,    -1,    71,     1,    -1,     3,    -1,
     114,   115,    -1,    61,   117,    62,    -1,    61,    62,    -1,
      61,   117,     1,    -1,    71,   117,    72,    -1,    71,   117,
       1,    -1,    73,     3,    -1,    73,    61,   112,    62,    -1,
     112,    -1,    50,    -1,    54,     3,    63,   112,    -1,    54,
       3,    63,     1,    -1,    54,     3,    -1,    54,     1,    -1,
     116,    -1,   117,    66,   116,    -1,   122,    -1,   118,   120,
     122,    -1,   122,    -1,   119,   120,   122,    -1,     6,    -1,
       5,    -1,    66,    -1,    68,    -1,   112,    -1,   122,   121,
     112,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   143,   143,   144,   144,   145,   149,   159,   168,   177,
     185,   194,   202,   203,   205,   206,   207,   208,   210,   211,
     215,   216,   220,   221,   222,   223,   224,   225,   226,   230,
     231,   235,   235,   246,   247,   251,   255,   259,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   287,   288,   289,   290,
     291,   292,   293,   306,   307,   311,   312,   316,   317,   318,
     322,   326,   330,   333,   337,   339,   344,   345,   349,   354,
     360,   360,   360,   360,   360,   364,   364,   369,   370,   374,
     377,   383,   389,   392,   398,   401,   406,   407,   408,   410,
     411,   412,   413,   414,   415,   419,   422,   423,   428,   432,
     433,   437,   440,   443,   447,   448,   452,   455,   461,   464,
     467,   470,   471,   475,   476,   480,   484,   488,   490,   492,
     494,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   554,   555,   556,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     573,   574,   578,   579,   580,   581,   582,   583,   584,   588,
     589,   590,   591,   592,   593,   597,   598,   602,   603,   607,
     608,   612,   612,   616,   616,   620,   621
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENT", "NUMERIC", "ENDQSTMNT",
  "ENDSTMNT", "LE", "GE", "EQ", "DOTTIMES", "DOTRDIV", "DOTLDIV",
  "DOTPOWER", "DOTTRANSPOSE", "STRING", "SPECIALCALL", "END", "IF",
  "FUNCTION", "FOR", "BREAK", "MAGICEND", "WHILE", "ELSE", "ELSEIF",
  "SWITCH", "CASE", "OTHERWISE", "CONTINUE", "TRY", "CATCH", "FIELD",
  "REFLPAREN", "REFRPAREN", "PERSISTENT", "KEYBOARD", "RETURN", "VARARGIN",
  "VARARGOUT", "GLOBAL", "QUIT", "RETALL", "SOR", "SAND", "'|'", "'&'",
  "'<'", "'>'", "NE", "':'", "'+'", "'-'", "'*'", "'/'", "'\\\\'", "NOT",
  "NEG", "POS", "'^'", "'''", "'('", "')'", "'='", "'['", "']'", "','",
  "';'", "'#'", "'~'", "'@'", "'{'", "'}'", "'.'", "$accept", "program",
  "functionDef", "functionDefList", "returnDeclaration", "argumentList",
  "argument", "statementList", "statement", "statementType", "specialCall",
  "persistentStatement", "globalStatement", "identList", "returnStatement",
  "keyboardStatement", "continueStatement", "breakStatement",
  "tryStatement", "optionalCatch", "switchStatement",
  "optionalEndStatement", "newLine", "caseBlock", "caseList",
  "caseStatement", "otherwiseClause", "forStatement", "forIndexExpression",
  "whileStatement", "ifStatement", "conditionedStatement", "elseIfBlock",
  "elseIfStatementList", "elseIfStatement", "elseStatement",
  "assignmentStatement", "multiFunctionCall", "expr", "terminal",
  "symbRefList", "symbRef", "indexElement", "indexList", "cellDef",
  "matrixDef", "rowSeperator", "columnSep", "rowDef", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   124,    38,    60,    62,   300,
      58,    43,    45,    42,    47,    92,   301,   302,   303,    94,
      39,    40,    41,    61,    91,    93,    44,    59,    35,   126,
      64,   123,   125,    46
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    74,    75,    75,    75,    75,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      77,    77,    78,    78,    78,    78,    78,    78,    78,    79,
      79,    80,    80,    81,    81,    82,    82,    82,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    84,    84,    84,    84,
      84,    84,    84,    85,    85,    86,    86,    87,    87,    87,
      88,    89,    90,    91,    92,    92,    93,    93,    94,    94,
      95,    95,    95,    95,    95,    96,    96,    97,    97,    98,
      98,    99,   100,   100,   101,   101,   102,   102,   102,   102,
     102,   102,   102,   102,   102,   103,   103,   103,   104,   104,
     104,   105,   105,   105,   106,   106,   107,   107,   108,   108,
     109,   109,   109,   110,   110,   111,   111,   111,   111,   111,
     111,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   113,   113,   113,   113,   113,   113,   113,
     113,   113,   113,   113,   113,   113,   113,   113,   113,   113,
     114,   114,   115,   115,   115,   115,   115,   115,   115,   116,
     116,   116,   116,   116,   116,   117,   117,   118,   118,   119,
     119,   120,   120,   121,   121,   122,   122
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     0,     1,     8,     7,     5,     4,
       7,     6,     2,     3,     4,     6,     3,     4,     5,     7,
       1,     2,     2,     2,     4,     2,     2,     3,     4,     1,
       3,     1,     2,     1,     2,     2,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     2,
       1,     1,     1,     1,     4,     4,     2,     0,     6,     6,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     4,     2,     0,     5,     5,     5,     3,     1,     5,
       4,     3,     2,     3,     1,     5,     2,     5,     5,     2,
       5,     3,     2,     2,     0,     1,     1,     2,     2,     2,
       2,     0,     2,     3,     3,     8,     5,     8,     7,     6,
       5,     3,     3,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     2,     2,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     1,     1,     1,     2,     1,     3,     2,
       4,     4,     5,     2,     3,     4,     4,     5,     2,     2,
       1,     2,     3,     2,     3,     3,     3,     2,     4,     1,
       1,     4,     4,     2,     2,     1,     3,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     5,   200,   183,   184,     0,     0,     0,    73,   185,
       0,     0,    72,    40,     0,    71,    70,     0,    54,    55,
       0,     0,     0,     0,     0,     0,     0,     0,    20,     3,
      40,    33,     0,    53,    52,    51,    50,    49,    44,    43,
      48,    47,    42,    45,    46,    38,    41,    39,   133,   187,
      59,    56,    58,    57,   109,   200,   184,     0,   114,     0,
     187,    12,     0,     0,     0,     0,   104,    98,     0,     0,
     106,     0,     0,    40,    64,    67,     0,    66,     0,   171,
     170,   182,     0,   189,   222,   221,   193,   225,     0,     0,
     219,   173,   172,   186,   199,   198,     0,     0,   217,     1,
      21,    34,    35,    36,    37,    61,    62,    60,     0,     0,
       0,     0,     0,     0,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     178,     0,     0,     0,     0,   201,     0,     0,   121,   115,
     116,   113,    82,    81,    80,    83,    84,   112,    13,    86,
      85,     0,    23,    40,    22,    26,    31,     0,     0,    29,
      16,     0,     0,   102,     0,    40,    40,    87,    40,     0,
      69,    68,   181,   180,   188,     0,     0,   223,   224,     0,
     194,     0,     0,   155,   154,   159,   158,   161,   160,   165,
     164,   167,   166,   169,   168,   177,   176,   149,   148,   151,
     150,   145,   144,   147,   146,   153,   152,   157,   156,   163,
     162,   132,   131,   135,   134,   137,   136,   139,   138,   141,
     140,   143,   142,   175,   174,   210,     0,   203,   209,   215,
       0,   124,   123,     0,   207,     0,   188,   119,   118,     0,
       0,   117,   111,    14,     0,     0,    40,    32,    27,     0,
       0,    17,     0,    40,   103,    97,   101,     0,     0,     0,
       0,    93,    88,    89,    40,    75,    74,     0,   191,   220,
     190,     0,   226,   196,   218,   195,     0,   214,   213,   204,
     202,     0,   206,   205,     0,   122,    40,   110,   108,    40,
       0,    28,    24,    30,    18,     0,     0,    40,   100,     0,
      95,    94,   107,   105,     0,    40,     0,    90,   130,     0,
     192,   197,     0,   216,   208,    40,    15,    40,    40,     0,
      99,    96,    40,    40,    79,    78,   129,     0,   212,   211,
      40,    40,    19,    40,    91,   128,     0,    40,   127,   125
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    27,    28,    29,    65,   158,   159,    30,    31,    32,
      33,    34,    35,    76,    36,    37,    38,    39,    40,   169,
      41,   147,   153,   261,   262,   263,   306,    42,    69,    43,
      44,    58,   138,   139,   140,   240,    45,    46,    47,    48,
      60,   135,   229,   230,    96,    88,    89,   179,    90
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -150
static const short int yypact[] =
{
     346,  -150,   212,  -150,    30,   230,   135,   147,  -150,  -150,
    1301,  2123,  -150,  1996,   170,  -150,  -150,   259,  -150,  -150,
    2123,  2123,  1316,  1285,  1344,    47,   802,    66,  -150,    58,
     759,  -150,   201,   234,  -150,  -150,  -150,  -150,  -150,  -150,
    -150,  -150,  -150,  -150,  -150,  -150,  -150,  2374,  -150,   -15,
    -150,  -150,  -150,  -150,  -150,  -150,  -150,  1285,    37,  2190,
     157,  -150,   156,    88,    54,   271,  -150,    89,   276,    35,
    -150,  2216,  2216,  1065,  -150,  -150,    33,  -150,    46,   126,
     126,  -150,  2278,  -150,  -150,  -150,  -150,  2374,   191,  2123,
     217,  -150,   126,  -150,  -150,  -150,    10,  2123,   217,  -150,
    -150,  -150,  -150,  -150,  -150,  -150,  -150,  -150,  1360,  1375,
    1403,  1419,  1434,  1462,  1478,  -150,  1493,  1521,  1537,  1552,
    1580,  1596,  1611,  1639,  1655,  1670,  1698,  1714,  1729,  1757,
    -150,  2020,  1773,  2046,    82,  -150,   198,  1788,    60,    37,
    -150,  -150,  -150,  -150,  -150,  -150,  -150,  1937,   287,  -150,
    -150,   178,  -150,  1996,  -150,  -150,  -150,    87,    13,  -150,
    -150,   208,  1816,  -150,    41,  1996,  1996,    69,  1996,    36,
    -150,  -150,  -150,  -150,    92,  2072,   215,  -150,  -150,  2123,
    -150,   787,    19,  -150,  2523,  -150,  2523,  -150,  2523,  -150,
     126,  -150,   126,  -150,   126,  -150,   126,  -150,  2428,  -150,
    2444,  -150,  2498,  -150,  2512,  -150,  2523,  -150,  2523,  -150,
    2523,  -150,  2574,  -150,  1860,  -150,  1860,  -150,   126,  -150,
     126,  -150,   126,  -150,   126,  -150,   292,  -150,  2374,  -150,
       9,  -150,  2374,     8,  -150,  2123,  -150,  -150,  -150,  1006,
      42,  -150,  1937,  -150,   127,    -1,   405,  -150,  -150,    68,
      26,  -150,   179,  1996,  -150,  2374,  -150,  1832,   864,   935,
    2123,   130,    69,  -150,  1124,  -150,  -150,   295,  -150,   217,
    -150,  2098,  2374,  -150,   217,  -150,  1875,  -150,   101,  -150,
    -150,  2046,  -150,  -150,  2354,  -150,  1183,  -150,  -150,  1996,
     242,  -150,  -150,  -150,  -150,   127,     2,   464,  -150,  2298,
    -150,  -150,  -150,  -150,  2216,  1996,    43,  -150,  -150,    27,
    -150,  -150,  1847,  -150,  -150,   523,  -150,  1996,  1996,   265,
    -150,  -150,  1996,  1242,  -150,  -150,  -150,   141,  -150,  2374,
     582,   641,  -150,  1996,  1937,  -150,    21,   700,  -150,  -150
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -150,  -150,   138,  -150,  -150,  -125,   -66,    22,    62,  -150,
    -150,  -150,  -150,   172,  -150,  -150,  -150,  -150,  -150,  -150,
    -150,   -68,  -149,  -150,  -150,   -64,  -150,  -150,  -150,  -150,
    -150,    57,  -150,  -150,    83,  -150,  -150,  -150,    -3,  -150,
       0,  -150,   -80,  -127,   129,   -26,     1,  -147,   -21
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -127
static const short int yytable[] =
{
      49,   165,    59,   166,   167,    98,   233,    71,    72,   282,
     279,   250,   253,    49,   248,    84,    85,    79,    80,    82,
      87,    92,   338,    87,    84,    85,   245,    97,   326,   156,
      49,   136,  -126,  -126,   170,    73,   171,   265,   -63,   -63,
     142,   143,   256,   287,   324,    53,   131,   170,   132,   171,
      93,   -65,   -65,   266,    87,   155,   133,   156,   134,   288,
     325,   290,   137,   176,   319,   177,    99,   178,   177,   291,
     178,   280,   157,    49,   281,   281,    98,     6,   249,   177,
     283,   178,   180,   339,   239,   234,    87,   281,   327,   175,
     247,   275,   101,  -126,    87,   289,   260,   181,   250,   -63,
     157,   144,   145,   146,   257,   184,   186,   188,   190,   192,
     194,   196,   -65,   198,   200,   202,   204,   206,   208,   210,
     212,   214,   216,   218,   220,   222,   224,   296,   228,   232,
     228,   292,   149,   150,    59,   101,    61,   175,    62,   114,
     115,   317,   335,   235,    55,     3,   318,    49,    66,   250,
      67,   154,   162,    49,   269,   267,    56,   148,   305,   255,
     274,   149,   150,     9,   312,    49,    49,   100,    49,   242,
     333,    74,    87,    75,    63,   246,   272,   271,    87,   243,
     294,   156,   156,   276,   293,   129,   130,   258,   259,    78,
     264,   225,    20,    21,   238,   226,    84,    85,   307,    64,
     336,   313,    22,    84,    85,    57,   102,   103,    68,   251,
      24,    25,    26,   149,   150,    50,    51,   151,   131,   152,
      84,    85,   241,     0,   157,   157,   182,    52,   133,     0,
     134,    54,   284,    55,     3,     0,   322,   105,   106,    49,
     244,   295,    49,   316,     0,    56,    49,   149,   150,   107,
     269,     0,     9,    49,   299,   274,   174,   304,    49,    49,
      77,   286,    75,   236,    49,     0,   332,   104,    87,   252,
     149,   150,   160,    87,   161,   297,     0,   163,   228,   164,
     270,    20,    21,   177,     0,   178,    49,     0,   -25,    49,
     -25,    22,     0,   277,    57,   278,   308,    49,   309,    24,
      25,    26,     0,     0,   101,    49,     0,     0,   101,   329,
       0,   315,     0,     0,     0,    49,     0,    49,    49,     0,
     101,   101,    49,    49,   228,     0,   101,   323,     0,     0,
      49,    49,     0,    49,    49,     0,     0,    49,     0,   330,
     331,     0,     0,     0,   334,     0,    -4,     1,   101,     2,
       3,   -40,   -40,     0,     0,   337,     0,     0,     0,   101,
       0,     4,     0,     0,     5,     6,     7,     8,     9,    10,
       0,     0,    11,     0,     0,    12,    13,   101,     0,     0,
       0,    14,    15,    16,     0,   101,    17,    18,    19,     0,
       0,     0,   101,   101,     0,     0,   101,    20,    21,   101,
       0,     0,     0,     0,     0,    -9,     0,    22,     2,     3,
      23,     0,   -40,     0,     0,    24,    25,    26,     0,     0,
       4,     0,     0,     5,    -9,     7,     8,     9,    10,     0,
       0,    11,     0,     0,    12,    13,     0,     0,     0,     0,
      14,    15,    16,     0,     0,    17,    18,    19,     0,     0,
       0,     0,     0,     0,     0,     0,    20,    21,     0,     0,
       0,     0,     0,     0,    -8,     0,    22,     2,     3,    23,
       0,     0,     0,     0,    24,    25,    26,     0,     0,     4,
       0,     0,     5,    -8,     7,     8,     9,    10,     0,     0,
      11,     0,     0,    12,    13,     0,     0,     0,     0,    14,
      15,    16,     0,     0,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,    20,    21,     0,     0,     0,
       0,     0,     0,   -11,     0,    22,     2,     3,    23,     0,
       0,     0,     0,    24,    25,    26,     0,     0,     4,     0,
       0,     5,   -11,     7,     8,     9,    10,     0,     0,    11,
       0,     0,    12,    13,     0,     0,     0,     0,    14,    15,
      16,     0,     0,    17,    18,    19,     0,     0,     0,     0,
       0,     0,     0,     0,    20,    21,     0,     0,     0,     0,
       0,     0,    -7,     0,    22,     2,     3,    23,     0,     0,
       0,     0,    24,    25,    26,     0,     0,     4,     0,     0,
       5,    -7,     7,     8,     9,    10,     0,     0,    11,     0,
       0,    12,    13,     0,     0,     0,     0,    14,    15,    16,
       0,     0,    17,    18,    19,     0,     0,     0,     0,     0,
       0,     0,     0,    20,    21,     0,     0,     0,     0,     0,
       0,   -10,     0,    22,     2,     3,    23,     0,     0,     0,
       0,    24,    25,    26,     0,     0,     4,     0,     0,     5,
     -10,     7,     8,     9,    10,     0,     0,    11,     0,     0,
      12,    13,     0,     0,     0,     0,    14,    15,    16,     0,
       0,    17,    18,    19,     0,     0,     0,     0,     0,     0,
       0,     0,    20,    21,     0,     0,     0,     0,     0,     0,
      -6,     0,    22,     2,     3,    23,     0,     0,     0,     0,
      24,    25,    26,     0,     0,     4,     0,     0,     5,    -6,
       7,     8,     9,    10,     0,     0,    11,     0,     0,    12,
      13,     0,     0,     0,     0,    14,    15,    16,     0,     0,
      17,    18,    19,     0,     0,     0,     0,     0,     0,     0,
       0,    20,    21,     0,     0,     0,     0,     0,     0,    -2,
       0,    22,     2,     3,    23,     0,     0,     0,     0,    24,
      25,    26,     0,     0,     4,     0,     0,     5,     0,     7,
       8,     9,    10,     0,     0,    11,     0,     0,    12,    13,
      55,     3,     0,     0,    14,    15,    16,     0,     0,    17,
      18,    19,    56,    94,     0,    55,     3,    84,    85,     9,
      20,    21,     0,     0,     0,     0,     0,    56,     0,     0,
      22,     0,     0,    23,     9,     0,     0,     0,    24,    25,
      26,     0,     0,     0,     0,     0,     0,     0,    20,    21,
       0,     0,     0,     0,     0,     0,     0,     0,    22,     0,
       0,    57,     0,    20,    21,     0,    24,    25,    26,   273,
       0,     0,     0,    22,     0,   300,    57,     2,     3,   -40,
     -40,    24,    25,    26,    95,     0,     0,     0,     0,     4,
       0,   301,     5,     0,     7,     8,     9,    10,     0,     0,
      11,     0,     0,    12,    13,     0,     0,     0,     0,    14,
      15,    16,     0,     0,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,    20,    21,     0,     0,     0,
       0,     0,     0,     0,     0,    22,     0,     0,    23,     0,
     -40,     0,     0,    24,    25,    26,   302,     0,     2,     3,
     -40,   -40,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,   303,     5,     0,     7,     8,     9,    10,     0,
       0,    11,     0,     0,    12,    13,     0,     0,     0,     0,
      14,    15,    16,     0,     0,    17,    18,    19,     0,     0,
       0,     0,     0,     0,     0,     0,    20,    21,     0,     0,
       0,     0,     0,     0,     0,     0,    22,     0,     0,    23,
       0,   -40,     0,     0,    24,    25,    26,   285,     0,     2,
       3,   -40,   -40,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     5,     0,     7,     8,     9,    10,
       0,     0,    11,     0,     0,    12,    13,     0,     0,     0,
       0,    14,    15,    16,     0,     0,    17,    18,    19,     0,
       0,     0,     0,     0,     0,     0,     0,    20,    21,     0,
       0,     0,     0,     0,     0,     0,   -77,    22,     2,     3,
      23,     0,   -40,     0,     0,    24,    25,    26,     0,     0,
       4,     0,   -77,     5,     0,     7,     8,     9,    10,     0,
       0,    11,     0,     0,    12,    13,   168,     0,     0,     0,
      14,    15,    16,     0,     0,    17,    18,    19,     0,     0,
       0,     0,     0,     0,     0,     0,    20,    21,     0,     0,
       0,     0,     0,     0,     0,   -76,    22,     2,     3,    23,
       0,     0,     0,     0,    24,    25,    26,     0,     0,     4,
       0,   -76,     5,     0,     7,     8,     9,    10,     0,     0,
      11,     0,     0,    12,    13,     0,     0,     0,     0,    14,
      15,    16,     0,     0,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,    20,    21,     0,     0,     0,
       0,     0,     0,     0,  -120,    22,     2,     3,    23,     0,
       0,     0,     0,    24,    25,    26,     0,     0,     4,     0,
    -120,     5,     0,     7,     8,     9,    10,     0,     0,    11,
       0,     0,    12,    13,     0,     0,     0,     0,    14,    15,
      16,     0,     0,    17,    18,    19,     0,     0,     0,     0,
       0,     0,     0,     0,    20,    21,     0,     0,     0,     0,
       0,     0,     0,   -92,    22,     2,     3,    23,     0,     0,
       0,     0,    24,    25,    26,     0,     0,     4,     0,   -92,
       5,     0,     7,     8,     9,    10,     0,     0,    11,     0,
       0,    12,    13,     0,     0,     0,     0,    14,    15,    16,
       0,     0,    17,    18,    19,     0,    83,     0,    55,     3,
      84,    85,     0,    20,    21,     0,     0,     0,     0,     0,
      56,     0,    70,    22,    55,     3,    23,     9,     0,     0,
       0,    24,    25,    26,     0,     0,    56,    81,     0,    55,
       3,     0,     0,     9,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,    20,    21,     9,     0,
       0,     0,     0,     0,     0,    91,    22,    55,     3,    57,
      86,     0,    20,    21,    24,    25,    26,     0,     0,    56,
       0,   183,    22,    55,     3,    57,     9,    20,    21,     0,
      24,    25,    26,     0,     0,    56,   185,    22,    55,     3,
      57,     0,     9,     0,     0,    24,    25,    26,     0,     0,
      56,     0,     0,     0,     0,    20,    21,     9,     0,     0,
       0,     0,     0,     0,   187,    22,    55,     3,    57,     0,
       0,    20,    21,    24,    25,    26,     0,     0,    56,     0,
     189,    22,    55,     3,    57,     9,    20,    21,     0,    24,
      25,    26,     0,     0,    56,   191,    22,    55,     3,    57,
       0,     9,     0,     0,    24,    25,    26,     0,     0,    56,
       0,     0,     0,     0,    20,    21,     9,     0,     0,     0,
       0,     0,     0,   193,    22,    55,     3,    57,     0,     0,
      20,    21,    24,    25,    26,     0,     0,    56,     0,   195,
      22,    55,     3,    57,     9,    20,    21,     0,    24,    25,
      26,     0,     0,    56,   197,    22,    55,     3,    57,     0,
       9,     0,     0,    24,    25,    26,     0,     0,    56,     0,
       0,     0,     0,    20,    21,     9,     0,     0,     0,     0,
       0,     0,   199,    22,    55,     3,    57,     0,     0,    20,
      21,    24,    25,    26,     0,     0,    56,     0,   201,    22,
      55,     3,    57,     9,    20,    21,     0,    24,    25,    26,
       0,     0,    56,   203,    22,    55,     3,    57,     0,     9,
       0,     0,    24,    25,    26,     0,     0,    56,     0,     0,
       0,     0,    20,    21,     9,     0,     0,     0,     0,     0,
       0,   205,    22,    55,     3,    57,     0,     0,    20,    21,
      24,    25,    26,     0,     0,    56,     0,   207,    22,    55,
       3,    57,     9,    20,    21,     0,    24,    25,    26,     0,
       0,    56,   209,    22,    55,     3,    57,     0,     9,     0,
       0,    24,    25,    26,     0,     0,    56,     0,     0,     0,
       0,    20,    21,     9,     0,     0,     0,     0,     0,     0,
     211,    22,    55,     3,    57,     0,     0,    20,    21,    24,
      25,    26,     0,     0,    56,     0,   213,    22,    55,     3,
      57,     9,    20,    21,     0,    24,    25,    26,     0,     0,
      56,   215,    22,    55,     3,    57,     0,     9,     0,     0,
      24,    25,    26,     0,     0,    56,     0,     0,     0,     0,
      20,    21,     9,     0,     0,     0,     0,     0,     0,   217,
      22,    55,     3,    57,     0,     0,    20,    21,    24,    25,
      26,     0,     0,    56,     0,   219,    22,    55,     3,    57,
       9,    20,    21,     0,    24,    25,    26,     0,     0,    56,
     221,    22,    55,     3,    57,     0,     9,     0,     0,    24,
      25,    26,     0,     0,    56,     0,     0,     0,     0,    20,
      21,     9,     0,     0,     0,     0,     0,     0,   223,    22,
      55,     3,    57,     0,     0,    20,    21,    24,    25,    26,
       0,     0,    56,     0,   231,    22,    55,     3,    57,     9,
      20,    21,     0,    24,    25,    26,     0,     0,    56,   237,
      22,    55,     3,    57,     0,     9,     0,     0,    24,    25,
      26,     0,     0,    56,     0,     0,     0,     0,    20,    21,
       9,     0,     0,     0,     0,     0,     0,   254,    22,    55,
       3,    57,     0,     0,    20,    21,    24,    25,    26,     0,
       0,    56,     0,   298,    22,    55,     3,    57,     9,    20,
      21,     0,    24,    25,    26,     0,     0,    56,   328,    22,
      55,     3,    57,     0,     9,     0,     0,    24,    25,    26,
       0,     0,    56,     0,     0,     0,     0,    20,    21,     9,
     111,   112,   113,   114,   115,     0,     0,    22,    55,     3,
      57,     0,     0,    20,    21,    24,    25,    26,     0,     0,
      56,     0,     0,    22,     0,     0,    57,     9,    20,    21,
       0,    24,    25,    26,     0,     0,     0,     0,    22,     0,
       0,    57,     0,   126,   127,   128,    24,    25,    26,   129,
     130,     0,     0,     0,     0,     0,    20,    21,     0,     0,
       0,     0,     0,     0,     0,     0,    22,     0,     0,    57,
       2,     3,   -40,   -40,    24,    25,    26,   311,     0,     0,
       0,     0,     4,     0,     0,     5,     0,     7,     8,     9,
      10,     0,     0,    11,     0,     0,    12,    13,     0,     0,
       0,     0,    14,    15,    16,     0,     0,    17,    18,    19,
       0,     0,     0,     0,     0,     0,     0,     0,    20,    21,
       0,     0,     0,     0,     0,     0,     0,     0,    22,     2,
       3,    23,     0,   -40,     0,     0,    24,    25,    26,     0,
       0,     4,     0,     0,     5,     0,     7,     8,     9,    10,
       0,     0,    11,    55,     3,    12,    13,     0,     0,     0,
       0,    14,    15,    16,     0,    56,    17,    18,    19,     0,
       0,     0,     9,     0,     0,     0,     0,    20,    21,    55,
       3,     0,     0,     0,     0,     0,     0,    22,     0,     0,
      23,    56,     0,     0,     0,    24,    25,    26,     9,     0,
     225,    20,    21,     0,   226,    55,     3,     0,     0,     0,
       0,    22,   227,     0,    57,     0,     0,    56,     0,    24,
      25,    26,     0,     0,     9,     0,   225,    20,    21,     0,
     226,    55,     3,     0,     0,     0,     0,    22,     0,     0,
      57,     0,     0,    56,     0,    24,    25,    26,     0,     0,
       9,     0,     0,    20,    21,     0,    55,     3,     0,     0,
       0,     0,     0,    22,     0,     0,    57,   268,    56,     0,
       0,    24,    25,    26,     0,     9,     0,     0,     0,    20,
      21,     0,     0,     0,     0,     0,     0,     0,     0,    22,
       0,     0,    57,   310,     0,     0,     0,    24,    25,    26,
       0,     0,     0,     0,    20,    21,     0,     0,     0,     0,
       0,     0,     0,     0,    22,     0,     0,    57,     0,     0,
       0,   141,    24,    25,    26,   142,   143,   108,   109,   110,
     111,   112,   113,   114,   115,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   142,   143,   108,   109,   110,   111,   112,   113,   114,
     115,     0,     0,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,     0,     0,     0,   129,
     130,     0,     0,     0,     0,     0,   144,   145,   146,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,     0,     0,     0,   129,   130,     0,     0,   172,
       0,     0,   144,   145,   146,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,   320,
       0,     0,     0,     0,     0,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,     0,     0,     0,   129,   130,     0,
     173,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,     0,     0,     0,   129,   130,     0,
     321,   108,   109,   110,   111,   112,   113,   114,   115,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   108,   109,   110,   111,   112,   113,   114,   115,     0,
       0,     0,     0,     0,     0,     0,     0,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
       0,     0,     0,   129,   130,     0,   314,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
       0,     0,     0,   129,   130,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,   108,   109,   110,   111,   112,   113,   114,   115,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,     0,     0,     0,   129,   130,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
       0,     0,     0,   129,   130,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,   108,
     109,   110,   111,   112,   113,   114,   115,     0,     0,     0,
       0,     0,     0,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,     0,     0,     0,   129,   130,   120,
     121,   122,   123,   124,   125,   126,   127,   128,     0,     0,
       0,   129,   130,   123,   124,   125,   126,   127,   128,     0,
       0,     0,   129,   130,   111,   112,   113,   114,   115,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   124,   125,   126,   127,   128,
       0,     0,     0,   129,   130
};

static const short int yycheck[] =
{
       0,    69,     5,    71,    72,    26,   133,    10,    11,     1,
       1,   158,   161,    13,     1,     5,     6,    20,    21,    22,
      23,    24,     1,    26,     5,     6,   151,    26,     1,     3,
      30,    57,     5,     6,     1,    13,     3,     1,     5,     6,
       5,     6,     1,     1,     1,    15,    61,     1,    63,     3,
       3,     5,     6,    17,    57,     1,    71,     3,    73,    17,
      17,    62,    25,    89,    62,    66,     0,    68,    66,     1,
      68,    62,    46,    73,    66,    66,    97,    19,    65,    66,
      72,    68,    72,    62,    24,     3,    89,    66,    61,    88,
       3,    72,    30,    66,    97,   244,    27,    96,   245,    66,
      46,    66,    67,    68,    63,   108,   109,   110,   111,   112,
     113,   114,    66,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   252,   131,   132,
     133,    63,     5,     6,   137,    73,     1,   136,     3,    13,
      14,   290,     1,    61,     3,     4,   295,   147,     1,   296,
       3,    63,    63,   153,   175,    63,    15,     1,    28,   162,
     181,     5,     6,    22,    63,   165,   166,    29,   168,   147,
     319,     1,   175,     3,    39,   153,   179,   176,   181,     1,
       1,     3,     3,   182,   250,    59,    60,   165,   166,    17,
     168,    50,    51,    52,   137,    54,     5,     6,   262,    64,
     327,   281,    61,     5,     6,    64,     5,     6,    61,     1,
      69,    70,    71,     5,     6,     3,     4,    61,    61,    63,
       5,     6,   139,    -1,    46,    46,    97,    15,    71,    -1,
      73,     1,   235,     3,     4,    -1,   304,     3,     4,   239,
      62,    62,   242,     1,    -1,    15,   246,     5,     6,    15,
     271,    -1,    22,   253,   257,   276,    65,   260,   258,   259,
       1,   239,     3,    65,   264,    -1,     1,    66,   271,    61,
       5,     6,     1,   276,     3,   253,    -1,     1,   281,     3,
      65,    51,    52,    66,    -1,    68,   286,    -1,     1,   289,
       3,    61,    -1,     1,    64,     3,     1,   297,     3,    69,
      70,    71,    -1,    -1,   242,   305,    -1,    -1,   246,   312,
      -1,   289,    -1,    -1,    -1,   315,    -1,   317,   318,    -1,
     258,   259,   322,   323,   327,    -1,   264,   305,    -1,    -1,
     330,   331,    -1,   333,   334,    -1,    -1,   337,    -1,   317,
     318,    -1,    -1,    -1,   322,    -1,     0,     1,   286,     3,
       4,     5,     6,    -1,    -1,   333,    -1,    -1,    -1,   297,
      -1,    15,    -1,    -1,    18,    19,    20,    21,    22,    23,
      -1,    -1,    26,    -1,    -1,    29,    30,   315,    -1,    -1,
      -1,    35,    36,    37,    -1,   323,    40,    41,    42,    -1,
      -1,    -1,   330,   331,    -1,    -1,   334,    51,    52,   337,
      -1,    -1,    -1,    -1,    -1,     0,    -1,    61,     3,     4,
      64,    -1,    66,    -1,    -1,    69,    70,    71,    -1,    -1,
      15,    -1,    -1,    18,    19,    20,    21,    22,    23,    -1,
      -1,    26,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,
      35,    36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,     0,    -1,    61,     3,     4,    64,
      -1,    -1,    -1,    -1,    69,    70,    71,    -1,    -1,    15,
      -1,    -1,    18,    19,    20,    21,    22,    23,    -1,    -1,
      26,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    35,
      36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,     0,    -1,    61,     3,     4,    64,    -1,
      -1,    -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,
      -1,    18,    19,    20,    21,    22,    23,    -1,    -1,    26,
      -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    35,    36,
      37,    -1,    -1,    40,    41,    42,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,     0,    -1,    61,     3,     4,    64,    -1,    -1,
      -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,    -1,
      18,    19,    20,    21,    22,    23,    -1,    -1,    26,    -1,
      -1,    29,    30,    -1,    -1,    -1,    -1,    35,    36,    37,
      -1,    -1,    40,    41,    42,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,     0,    -1,    61,     3,     4,    64,    -1,    -1,    -1,
      -1,    69,    70,    71,    -1,    -1,    15,    -1,    -1,    18,
      19,    20,    21,    22,    23,    -1,    -1,    26,    -1,    -1,
      29,    30,    -1,    -1,    -1,    -1,    35,    36,    37,    -1,
      -1,    40,    41,    42,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
       0,    -1,    61,     3,     4,    64,    -1,    -1,    -1,    -1,
      69,    70,    71,    -1,    -1,    15,    -1,    -1,    18,    19,
      20,    21,    22,    23,    -1,    -1,    26,    -1,    -1,    29,
      30,    -1,    -1,    -1,    -1,    35,    36,    37,    -1,    -1,
      40,    41,    42,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,     0,
      -1,    61,     3,     4,    64,    -1,    -1,    -1,    -1,    69,
      70,    71,    -1,    -1,    15,    -1,    -1,    18,    -1,    20,
      21,    22,    23,    -1,    -1,    26,    -1,    -1,    29,    30,
       3,     4,    -1,    -1,    35,    36,    37,    -1,    -1,    40,
      41,    42,    15,     1,    -1,     3,     4,     5,     6,    22,
      51,    52,    -1,    -1,    -1,    -1,    -1,    15,    -1,    -1,
      61,    -1,    -1,    64,    22,    -1,    -1,    -1,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    64,    -1,    51,    52,    -1,    69,    70,    71,    72,
      -1,    -1,    -1,    61,    -1,     1,    64,     3,     4,     5,
       6,    69,    70,    71,    72,    -1,    -1,    -1,    -1,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    -1,    -1,
      26,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    35,
      36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,    64,    -1,
      66,    -1,    -1,    69,    70,    71,     1,    -1,     3,     4,
       5,     6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    -1,
      -1,    26,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,
      35,    36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,    64,
      -1,    66,    -1,    -1,    69,    70,    71,     1,    -1,     3,
       4,     5,     6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    18,    -1,    20,    21,    22,    23,
      -1,    -1,    26,    -1,    -1,    29,    30,    -1,    -1,    -1,
      -1,    35,    36,    37,    -1,    -1,    40,    41,    42,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    61,     3,     4,
      64,    -1,    66,    -1,    -1,    69,    70,    71,    -1,    -1,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    -1,
      -1,    26,    -1,    -1,    29,    30,    31,    -1,    -1,    -1,
      35,    36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    61,     3,     4,    64,
      -1,    -1,    -1,    -1,    69,    70,    71,    -1,    -1,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    -1,    -1,
      26,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    35,
      36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    61,     3,     4,    64,    -1,
      -1,    -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,
      17,    18,    -1,    20,    21,    22,    23,    -1,    -1,    26,
      -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    35,    36,
      37,    -1,    -1,    40,    41,    42,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    61,     3,     4,    64,    -1,    -1,
      -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    -1,    -1,    26,    -1,
      -1,    29,    30,    -1,    -1,    -1,    -1,    35,    36,    37,
      -1,    -1,    40,    41,    42,    -1,     1,    -1,     3,     4,
       5,     6,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      15,    -1,     1,    61,     3,     4,    64,    22,    -1,    -1,
      -1,    69,    70,    71,    -1,    -1,    15,     1,    -1,     3,
       4,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    -1,    51,    52,    22,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    61,     3,     4,    64,
      65,    -1,    51,    52,    69,    70,    71,    -1,    -1,    15,
      -1,     1,    61,     3,     4,    64,    22,    51,    52,    -1,
      69,    70,    71,    -1,    -1,    15,     1,    61,     3,     4,
      64,    -1,    22,    -1,    -1,    69,    70,    71,    -1,    -1,
      15,    -1,    -1,    -1,    -1,    51,    52,    22,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    61,     3,     4,    64,    -1,
      -1,    51,    52,    69,    70,    71,    -1,    -1,    15,    -1,
       1,    61,     3,     4,    64,    22,    51,    52,    -1,    69,
      70,    71,    -1,    -1,    15,     1,    61,     3,     4,    64,
      -1,    22,    -1,    -1,    69,    70,    71,    -1,    -1,    15,
      -1,    -1,    -1,    -1,    51,    52,    22,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    61,     3,     4,    64,    -1,    -1,
      51,    52,    69,    70,    71,    -1,    -1,    15,    -1,     1,
      61,     3,     4,    64,    22,    51,    52,    -1,    69,    70,
      71,    -1,    -1,    15,     1,    61,     3,     4,    64,    -1,
      22,    -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,
      -1,    -1,    -1,    51,    52,    22,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    61,     3,     4,    64,    -1,    -1,    51,
      52,    69,    70,    71,    -1,    -1,    15,    -1,     1,    61,
       3,     4,    64,    22,    51,    52,    -1,    69,    70,    71,
      -1,    -1,    15,     1,    61,     3,     4,    64,    -1,    22,
      -1,    -1,    69,    70,    71,    -1,    -1,    15,    -1,    -1,
      -1,    -1,    51,    52,    22,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    61,     3,     4,    64,    -1,    -1,    51,    52,
      69,    70,    71,    -1,    -1,    15,    -1,     1,    61,     3,
       4,    64,    22,    51,    52,    -1,    69,    70,    71,    -1,
      -1,    15,     1,    61,     3,     4,    64,    -1,    22,    -1,
      -1,    69,    70,    71,    -1,    -1,    15,    -1,    -1,    -1,
      -1,    51,    52,    22,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    61,     3,     4,    64,    -1,    -1,    51,    52,    69,
      70,    71,    -1,    -1,    15,    -1,     1,    61,     3,     4,
      64,    22,    51,    52,    -1,    69,    70,    71,    -1,    -1,
      15,     1,    61,     3,     4,    64,    -1,    22,    -1,    -1,
      69,    70,    71,    -1,    -1,    15,    -1,    -1,    -1,    -1,
      51,    52,    22,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      61,     3,     4,    64,    -1,    -1,    51,    52,    69,    70,
      71,    -1,    -1,    15,    -1,     1,    61,     3,     4,    64,
      22,    51,    52,    -1,    69,    70,    71,    -1,    -1,    15,
       1,    61,     3,     4,    64,    -1,    22,    -1,    -1,    69,
      70,    71,    -1,    -1,    15,    -1,    -1,    -1,    -1,    51,
      52,    22,    -1,    -1,    -1,    -1,    -1,    -1,     1,    61,
       3,     4,    64,    -1,    -1,    51,    52,    69,    70,    71,
      -1,    -1,    15,    -1,     1,    61,     3,     4,    64,    22,
      51,    52,    -1,    69,    70,    71,    -1,    -1,    15,     1,
      61,     3,     4,    64,    -1,    22,    -1,    -1,    69,    70,
      71,    -1,    -1,    15,    -1,    -1,    -1,    -1,    51,    52,
      22,    -1,    -1,    -1,    -1,    -1,    -1,     1,    61,     3,
       4,    64,    -1,    -1,    51,    52,    69,    70,    71,    -1,
      -1,    15,    -1,     1,    61,     3,     4,    64,    22,    51,
      52,    -1,    69,    70,    71,    -1,    -1,    15,     1,    61,
       3,     4,    64,    -1,    22,    -1,    -1,    69,    70,    71,
      -1,    -1,    15,    -1,    -1,    -1,    -1,    51,    52,    22,
      10,    11,    12,    13,    14,    -1,    -1,    61,     3,     4,
      64,    -1,    -1,    51,    52,    69,    70,    71,    -1,    -1,
      15,    -1,    -1,    61,    -1,    -1,    64,    22,    51,    52,
      -1,    69,    70,    71,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    64,    -1,    53,    54,    55,    69,    70,    71,    59,
      60,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,    64,
       3,     4,     5,     6,    69,    70,    71,    72,    -1,    -1,
      -1,    -1,    15,    -1,    -1,    18,    -1,    20,    21,    22,
      23,    -1,    -1,    26,    -1,    -1,    29,    30,    -1,    -1,
      -1,    -1,    35,    36,    37,    -1,    -1,    40,    41,    42,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,     3,
       4,    64,    -1,    66,    -1,    -1,    69,    70,    71,    -1,
      -1,    15,    -1,    -1,    18,    -1,    20,    21,    22,    23,
      -1,    -1,    26,     3,     4,    29,    30,    -1,    -1,    -1,
      -1,    35,    36,    37,    -1,    15,    40,    41,    42,    -1,
      -1,    -1,    22,    -1,    -1,    -1,    -1,    51,    52,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      64,    15,    -1,    -1,    -1,    69,    70,    71,    22,    -1,
      50,    51,    52,    -1,    54,     3,     4,    -1,    -1,    -1,
      -1,    61,    62,    -1,    64,    -1,    -1,    15,    -1,    69,
      70,    71,    -1,    -1,    22,    -1,    50,    51,    52,    -1,
      54,     3,     4,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      64,    -1,    -1,    15,    -1,    69,    70,    71,    -1,    -1,
      22,    -1,    -1,    51,    52,    -1,     3,     4,    -1,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    64,    65,    15,    -1,
      -1,    69,    70,    71,    -1,    22,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    64,    65,    -1,    -1,    -1,    69,    70,    71,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    64,    -1,    -1,
      -1,     1,    69,    70,    71,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    -1,    -1,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    -1,    -1,    -1,    59,
      60,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    -1,    -1,    59,    60,    -1,    -1,     1,
      -1,    -1,    66,    67,    68,     7,     8,     9,    10,    11,
      12,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,     7,     8,     9,    10,    11,
      12,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    -1,    -1,    -1,    59,    60,    -1,
      62,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    -1,    -1,    -1,    59,    60,    -1,
      62,     7,     8,     9,    10,    11,    12,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     7,     8,     9,    10,    11,    12,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      -1,    -1,    -1,    59,    60,    -1,    62,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      -1,    -1,    -1,    59,    60,     7,     8,     9,    10,    11,
      12,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     7,     8,     9,    10,    11,    12,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    -1,    -1,    -1,    59,    60,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      -1,    -1,    -1,    59,    60,     7,     8,     9,    10,    11,
      12,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,     7,
       8,     9,    10,    11,    12,    13,    14,    -1,    -1,    -1,
      -1,    -1,    -1,    10,    11,    12,    13,    14,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    -1,    -1,    -1,    59,    60,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      -1,    59,    60,    50,    51,    52,    53,    54,    55,    -1,
      -1,    -1,    59,    60,    10,    11,    12,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    -1,    -1,    59,    60
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,     3,     4,    15,    18,    19,    20,    21,    22,
      23,    26,    29,    30,    35,    36,    37,    40,    41,    42,
      51,    52,    61,    64,    69,    70,    71,    75,    76,    77,
      81,    82,    83,    84,    85,    86,    88,    89,    90,    91,
      92,    94,   101,   103,   104,   110,   111,   112,   113,   114,
       3,     4,    15,    15,     1,     3,    15,    64,   105,   112,
     114,     1,     3,    39,    64,    78,     1,     3,    61,   102,
       1,   112,   112,    81,     1,     3,    87,     1,    87,   112,
     112,     1,   112,     1,     5,     6,    65,   112,   119,   120,
     122,     1,   112,     3,     1,    72,   118,   120,   122,     0,
      76,    82,     5,     6,    66,     3,     4,    15,     7,     8,
       9,    10,    11,    12,    13,    14,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    59,
      60,    61,    63,    71,    73,   115,   119,    25,   106,   107,
     108,     1,     5,     6,    66,    67,    68,    95,     1,     5,
       6,    61,    63,    96,    63,     1,     3,    46,    79,    80,
       1,     3,    63,     1,     3,    95,    95,    95,    31,    93,
       1,     3,     1,    62,    65,   120,   119,    66,    68,   121,
      72,   120,   118,     1,   112,     1,   112,     1,   112,     1,
     112,     1,   112,     1,   112,     1,   112,     1,   112,     1,
     112,     1,   112,     1,   112,     1,   112,     1,   112,     1,
     112,     1,   112,     1,   112,     1,   112,     1,   112,     1,
     112,     1,   112,     1,   112,    50,    54,    62,   112,   116,
     117,     1,   112,   117,     3,    61,    65,     1,   105,    24,
     109,   108,    81,     1,    62,    79,    81,     3,     1,    65,
     121,     1,    61,    96,     1,   112,     1,    63,    81,    81,
      27,    97,    98,    99,    81,     1,    17,    63,    65,   122,
      65,   120,   112,    72,   122,    72,   120,     1,     3,     1,
      62,    66,     1,    72,   112,     1,    81,     1,    17,    96,
      62,     1,    63,    80,     1,    62,    79,    81,     1,   112,
       1,    17,     1,    17,   112,    28,   100,    99,     1,     3,
      65,    72,    63,   116,    62,    81,     1,    96,    96,    62,
       1,    62,    95,    81,     1,    17,     1,    61,     1,   112,
      81,    81,     1,    96,    81,     1,   117,    81,     1,    62
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr,					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname[yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      size_t yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

#endif /* YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 143 "../../../libs/libFreeMat/Parser.yxx"
    {mainAST = (yyvsp[0]).v.p;}
    break;

  case 5:
#line 145 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("statement list or function definition",(yyvsp[0]));}
    break;

  case 6:
#line 149 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->returnVals = (yyvsp[-6]).v.p->toStringList();
     r->name = (yyvsp[-5]).v.p->text;
     r->arguments = (yyvsp[-3]).v.p->toStringList();
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 7:
#line 159 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->name = (yyvsp[-5]).v.p->text;
     r->arguments = (yyvsp[-3]).v.p->toStringList();
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 8:
#line 168 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->returnVals = (yyvsp[-3]).v.p->toStringList();
     r->name = (yyvsp[-2]).v.p->text;
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 9:
#line 177 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->name = (yyvsp[-2]).v.p->text;
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 10:
#line 185 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->returnVals = (yyvsp[-5]).v.p->toStringList();
     r->name = (yyvsp[-4]).v.p->text;
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 11:
#line 194 "../../../libs/libFreeMat/Parser.yxx"
    {
     MFunctionDef *r;
     r = new MFunctionDef();
     r->name = (yyvsp[-4]).v.p->text;
     r->code = (yyvsp[0]).v.p;
     r->fileName = parsing_filename;
     chainFunction(r);
   }
    break;

  case 12:
#line 202 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("legal function name or return declaration after 'function'",(yyvsp[-1]));}
    break;

  case 13:
#line 203 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("argument list or statement list after identifier '") + 
	(yyvsp[-1]).v.p->text + "'",(yyvsp[-1]));}
    break;

  case 14:
#line 205 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("(possibly empty) argument list after '('",(yyvsp[-1]));}
    break;

  case 15:
#line 206 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("statement list after ')'",(yyvsp[-1]));}
    break;

  case 16:
#line 207 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("function name for function declared",(yyvsp[-2]));}
    break;

  case 17:
#line 208 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("argument list or statement list following function name :") + 
	(yyvsp[-1]).v.p->text,(yyvsp[-1]));}
    break;

  case 18:
#line 210 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("(possibly empty) argument list after '('",(yyvsp[-1]));}
    break;

  case 19:
#line 211 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("statement list after ')'",(yyvsp[-1]));}
    break;

  case 22:
#line 220 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 23:
#line 221 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 24:
#line 222 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p;}
    break;

  case 25:
#line 223 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an '=' symbol after identifier in return declaration",(yyvsp[-1]));}
    break;

  case 26:
#line 224 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("a valid list of return arguments in return declaration",(yyvsp[-1]));}
    break;

  case 27:
#line 225 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("matching ']' in return declaration for '['",(yyvsp[-2]));}
    break;

  case 28:
#line 226 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an '=' symbol after return declaration",(yyvsp[-1]));}
    break;

  case 29:
#line 230 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[0]).v.p;}
    break;

  case 30:
#line 231 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 32:
#line 235 "../../../libs/libFreeMat/Parser.yxx"
    {
	(yyval).v.p = (yyvsp[0]).v.p;
	char *b = (char*) malloc(strlen((yyvsp[0]).v.p->text)+2);
	b[0] = '&';
	strcpy(b+1,(yyvsp[0]).v.p->text);
	(yyval).v.p->text = b;
  }
    break;

  case 33:
#line 246 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_BLOCK,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());}
    break;

  case 34:
#line 247 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 35:
#line 251 "../../../libs/libFreeMat/Parser.yxx"
    {
  	    (yyval).v.p = new AST(OP_QSTATEMENT,NULL,(yyvsp[0]).v.i);
	    (yyval).v.p->down = (yyvsp[-1]).v.p;
	 }
    break;

  case 36:
#line 255 "../../../libs/libFreeMat/Parser.yxx"
    {
	    (yyval).v.p = new AST(OP_RSTATEMENT,NULL,(yyvsp[0]).v.i);
            (yyval).v.p->down = (yyvsp[-1]).v.p;
	 }
    break;

  case 37:
#line 259 "../../../libs/libFreeMat/Parser.yxx"
    {
	    (yyval).v.p = new AST(OP_RSTATEMENT,NULL,(yyvsp[0]).v.i);
	    (yyval).v.p->down = (yyvsp[-1]).v.p;
	 }
    break;

  case 40:
#line 268 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(null_node,"",-1);}
    break;

  case 56:
#line 287 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SCALL,(yyvsp[-1]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.p->context());}
    break;

  case 57:
#line 288 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SCALL,(yyvsp[-1]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.p->context());}
    break;

  case 58:
#line 289 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SCALL,(yyvsp[-1]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.p->context());}
    break;

  case 59:
#line 290 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SCALL,(yyvsp[-1]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.p->context()); }
    break;

  case 60:
#line 291 "../../../libs/libFreeMat/Parser.yxx"
    {(yyvsp[-1]).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 61:
#line 292 "../../../libs/libFreeMat/Parser.yxx"
    {(yyvsp[-1]).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 62:
#line 293 "../../../libs/libFreeMat/Parser.yxx"
    {(yyvsp[-1]).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 63:
#line 306 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p); }
    break;

  case 64:
#line 307 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("list of variables to be tagged as persistent",(yyvsp[-1]));}
    break;

  case 65:
#line 311 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 66:
#line 312 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("list of variables to be tagged as global",(yyvsp[-1]));}
    break;

  case 68:
#line 317 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 69:
#line 318 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("list of valid identifiers",(yyvsp[0]));}
    break;

  case 74:
#line 338 "../../../libs/libFreeMat/Parser.yxx"
    { (yyval).v.p = (yyvsp[-3]).v.p; (yyval).v.p->addChild((yyvsp[-2]).v.p); if ((yyvsp[-1]).v.p != NULL) (yyval).v.p->addChild((yyvsp[-1]).v.p);}
    break;

  case 75:
#line 340 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("matching 'end' to 'try' clause from line ") + decodeline((yyvsp[-3])),(yyvsp[0]));}
    break;

  case 76:
#line 344 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[0]).v.p;}
    break;

  case 77:
#line 345 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = NULL;}
    break;

  case 78:
#line 349 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-5]).v.p; (yyval).v.p->addChild((yyvsp[-4]).v.p); 
	  if ((yyvsp[-2]).v.p != NULL) (yyval).v.p->addChild((yyvsp[-2]).v.p); 
	  if ((yyvsp[-1]).v.p != NULL) (yyval).v.p->addChild((yyvsp[-1]).v.p);
	}
    break;

  case 79:
#line 354 "../../../libs/libFreeMat/Parser.yxx"
    {
          yyxpt(std::string("matching 'end' to 'switch' clause from line ") + decodeline((yyvsp[-5])),(yyvsp[0]));
        }
    break;

  case 87:
#line 369 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = NULL;}
    break;

  case 89:
#line 374 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = new AST(OP_CASEBLOCK,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());
	}
    break;

  case 90:
#line 377 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);
	}
    break;

  case 91:
#line 383 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-3]).v.p; (yyval).v.p->addChild((yyvsp[-2]).v.p); (yyval).v.p->addChild((yyvsp[0]).v.p);
	}
    break;

  case 92:
#line 389 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[0]).v.p;
	}
    break;

  case 93:
#line 392 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = NULL;
	}
    break;

  case 94:
#line 398 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-4]).v.p; (yyval).v.p->addChild((yyvsp[-3]).v.p); (yyval).v.p->addChild((yyvsp[-1]).v.p);
	}
    break;

  case 95:
#line 402 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("'end' to match 'for' statement from line ") + decodeline((yyvsp[-4])),(yyvsp[0]));}
    break;

  case 96:
#line 406 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-3]).v.p; (yyval).v.p->addChild((yyvsp[-1]).v.p);}
    break;

  case 97:
#line 407 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 98:
#line 408 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[0]).v.p; 
	      (yyval).v.p->addChild(new AST(OP_RHS,new AST(id_node,(yyvsp[0]).v.p->text,(yyvsp[0]).v.p->context()),(yyvsp[0]).v.p->context())); }
    break;

  case 99:
#line 410 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("matching right parenthesis",(yyvsp[-4]));}
    break;

  case 100:
#line 411 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("indexing expression",(yyvsp[-1]));}
    break;

  case 101:
#line 412 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("equals operator after loop index",(yyvsp[-1]));}
    break;

  case 102:
#line 413 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("identifier that is the loop variable",(yyvsp[-1]));}
    break;

  case 103:
#line 414 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("indexing expression",(yyvsp[-1]));}
    break;

  case 104:
#line 415 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("identifier or assignment (id = expr) after 'for' ",(yyvsp[0]));}
    break;

  case 105:
#line 419 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-4]).v.p; (yyval).v.p->addChild((yyvsp[-3]).v.p); (yyval).v.p->addChild((yyvsp[-1]).v.p);
	}
    break;

  case 106:
#line 422 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("test expression after 'while'",(yyvsp[-1]));}
    break;

  case 107:
#line 424 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("'end' to match 'while' statement from line ") + decodeline((yyvsp[-4])),(yyvsp[0]));}
    break;

  case 108:
#line 428 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-4]).v.p; (yyval).v.p->addChild((yyvsp[-3]).v.p); if ((yyvsp[-2]).v.p != NULL) (yyval).v.p->addChild((yyvsp[-2]).v.p); 
	  if ((yyvsp[-1]).v.p != NULL) (yyval).v.p->addChild((yyvsp[-1]).v.p);
	}
    break;

  case 109:
#line 432 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("condition expression for 'if'",(yyvsp[-1]));}
    break;

  case 110:
#line 433 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt(std::string("'end' to match 'if' statement from line ") + decodeline((yyvsp[-4])),(yyvsp[0]));}
    break;

  case 111:
#line 437 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = new AST(OP_CSTAT,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-2]).v.p->context());
	}
    break;

  case 112:
#line 440 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = new AST(OP_CSTAT,(yyvsp[-1]).v.p,(yyvsp[-1]).v.p->context());
	}
    break;

  case 113:
#line 443 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("valid list of statements after condition",(yyvsp[0]));}
    break;

  case 114:
#line 447 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = NULL;}
    break;

  case 116:
#line 452 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = new AST(OP_ELSEIFBLOCK,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());
	}
    break;

  case 117:
#line 455 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);
	}
    break;

  case 118:
#line 461 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[0]).v.p;
	}
    break;

  case 119:
#line 464 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("test condition for 'elseif' clause",(yyvsp[-1]));}
    break;

  case 120:
#line 467 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyval).v.p = (yyvsp[0]).v.p;
	}
    break;

  case 121:
#line 470 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = NULL;}
    break;

  case 122:
#line 471 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("statement list for 'else' clause",(yyvsp[-1]));}
    break;

  case 123:
#line 475 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_ASSIGN,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 124:
#line 476 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("expression in assignment",(yyvsp[-1]));}
    break;

  case 125:
#line 480 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyvsp[-3]).v.p->addChild(new AST(OP_PARENS,(yyvsp[-1]).v.p,(yyvsp[-2]).v.i));
	  (yyval).v.p = new AST(OP_MULTICALL,(yyvsp[-6]).v.p,(yyvsp[-3]).v.p,(yyvsp[-7]).v.i);
	}
    break;

  case 126:
#line 484 "../../../libs/libFreeMat/Parser.yxx"
    {
	  (yyvsp[0]).v.p->addChild(new AST(OP_PARENS,NULL,-1));
	  (yyval).v.p = new AST(OP_MULTICALL,(yyvsp[-3]).v.p,(yyvsp[0]).v.p,(yyvsp[-4]).v.i);
	}
    break;

  case 127:
#line 489 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("matching right parenthesis",(yyvsp[-2]));}
    break;

  case 128:
#line 491 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("indexing list",(yyvsp[-1]));}
    break;

  case 129:
#line 493 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("left parenthesis",(yyvsp[-1]));}
    break;

  case 130:
#line 495 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("identifier",(yyvsp[-1]));}
    break;

  case 131:
#line 499 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_COLON,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 132:
#line 500 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after ':'",(yyvsp[-1]));}
    break;

  case 134:
#line 502 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_PLUS,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 135:
#line 503 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '+'",(yyvsp[-1]));}
    break;

  case 136:
#line 504 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SUBTRACT,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 137:
#line 505 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '-'",(yyvsp[-1]));}
    break;

  case 138:
#line 506 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_TIMES,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 139:
#line 507 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '*'",(yyvsp[-1]));}
    break;

  case 140:
#line 508 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_RDIV,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 141:
#line 509 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '/'",(yyvsp[-1]));}
    break;

  case 142:
#line 510 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_LDIV,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 143:
#line 511 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '\\'",(yyvsp[-1]));}
    break;

  case 144:
#line 512 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_OR,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 145:
#line 513 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '|'",(yyvsp[-1]));}
    break;

  case 146:
#line 514 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_AND,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 147:
#line 515 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '&'",(yyvsp[-1]));}
    break;

  case 148:
#line 516 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SOR,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 149:
#line 517 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '||'",(yyvsp[-1]));}
    break;

  case 150:
#line 518 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SAND,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 151:
#line 519 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '&&'",(yyvsp[-1]));}
    break;

  case 152:
#line 520 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_LT,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 153:
#line 521 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '<'",(yyvsp[-1]));}
    break;

  case 154:
#line 522 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_LEQ,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 155:
#line 523 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '<='",(yyvsp[-1]));}
    break;

  case 156:
#line 524 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_GT,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 157:
#line 525 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '>'",(yyvsp[-1]));}
    break;

  case 158:
#line 526 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_GEQ,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 159:
#line 527 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '>='",(yyvsp[-1]));}
    break;

  case 160:
#line 528 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_EQ,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 161:
#line 529 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '=='",(yyvsp[-1]));}
    break;

  case 162:
#line 530 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_NEQ,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 163:
#line 531 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '~='",(yyvsp[-1]));}
    break;

  case 164:
#line 532 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT_TIMES,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 165:
#line 533 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '.*'",(yyvsp[-1]));}
    break;

  case 166:
#line 534 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT_RDIV,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 167:
#line 535 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after './'",(yyvsp[-1]));}
    break;

  case 168:
#line 536 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT_LDIV,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 169:
#line 537 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '.\\'",(yyvsp[-1]));}
    break;

  case 170:
#line 538 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_NEG,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 171:
#line 539 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[0]).v.p;}
    break;

  case 172:
#line 540 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_NOT,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 173:
#line 541 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after logical not",(yyvsp[0]));}
    break;

  case 174:
#line 542 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_POWER,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 175:
#line 543 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '^'",(yyvsp[-1]));}
    break;

  case 176:
#line 544 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT_POWER,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 177:
#line 545 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after '.^'",(yyvsp[-1]));}
    break;

  case 178:
#line 546 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_TRANSPOSE,(yyvsp[-1]).v.p,(yyvsp[0]).v.i);}
    break;

  case 179:
#line 547 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT_TRANSPOSE,(yyvsp[-1]).v.p,(yyvsp[0]).v.i);}
    break;

  case 180:
#line 548 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 181:
#line 549 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("a right parenthesis after expression to match this one",(yyvsp[-2]));}
    break;

  case 182:
#line 550 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("an expression after left parenthesis",(yyvsp[-1]));}
    break;

  case 186:
#line 557 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_ADDRESS,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 187:
#line 558 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_RHS,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());}
    break;

  case 188:
#line 559 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 189:
#line 560 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("a matrix definition followed by a right bracket",(yyvsp[-1]));}
    break;

  case 190:
#line 561 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 191:
#line 562 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p;}
    break;

  case 192:
#line 563 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p;}
    break;

  case 193:
#line 564 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_EMPTY,NULL,(yyvsp[-1]).v.i);}
    break;

  case 194:
#line 565 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 195:
#line 566 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p;}
    break;

  case 196:
#line 567 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p;}
    break;

  case 197:
#line 568 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p;}
    break;

  case 198:
#line 569 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_EMPTY_CELL,NULL,(yyvsp[-1]).v.i);}
    break;

  case 199:
#line 570 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("a cell-array definition followed by a right brace",(yyvsp[-1]));}
    break;

  case 201:
#line 574 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-1]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 202:
#line 578 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_PARENS,(yyvsp[-1]).v.p,(yyvsp[-2]).v.i); }
    break;

  case 203:
#line 579 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_PARENS,NULL,(yyvsp[-1]).v.i); }
    break;

  case 204:
#line 580 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("matching right parenthesis",(yyvsp[-2]));}
    break;

  case 205:
#line 581 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_BRACES,(yyvsp[-1]).v.p,(yyvsp[-2]).v.i); }
    break;

  case 206:
#line 582 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("matching right brace",(yyvsp[-2]));}
    break;

  case 207:
#line 583 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOT,(yyvsp[0]).v.p,(yyvsp[-1]).v.i); }
    break;

  case 208:
#line 584 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_DOTDYN,(yyvsp[-1]).v.p,(yyvsp[-3]).v.i);}
    break;

  case 210:
#line 589 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_ALL,NULL,(yyvsp[0]).v.i);}
    break;

  case 211:
#line 590 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_KEYWORD,(yyvsp[-2]).v.p,(yyvsp[0]).v.p,(yyvsp[-3]).v.i);}
    break;

  case 212:
#line 591 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("expecting expression after '=' in keyword assignment",(yyvsp[-1]));}
    break;

  case 213:
#line 592 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_KEYWORD,(yyvsp[0]).v.p,(yyvsp[-1]).v.i);}
    break;

  case 214:
#line 593 "../../../libs/libFreeMat/Parser.yxx"
    {yyxpt("expecting keyword identifier after '/' in keyword assignment",(yyvsp[-1]));}
    break;

  case 216:
#line 598 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addPeer((yyvsp[0]).v.p);}
    break;

  case 217:
#line 602 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_BRACES,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());}
    break;

  case 218:
#line 603 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 219:
#line 607 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_BRACKETS,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());}
    break;

  case 220:
#line 608 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;

  case 225:
#line 620 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = new AST(OP_SEMICOLON,(yyvsp[0]).v.p,(yyvsp[0]).v.p->context());}
    break;

  case 226:
#line 621 "../../../libs/libFreeMat/Parser.yxx"
    {(yyval).v.p = (yyvsp[-2]).v.p; (yyval).v.p->addChild((yyvsp[0]).v.p);}
    break;


      default: break;
    }

/* Line 1126 of yacc.c.  */
#line 3104 "../../../libs/libFreeMat/Parser.cxx"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  YY_("syntax error, unexpected %s");
	  YY_("syntax error, unexpected %s, expecting %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yytnamerr (0, yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = YY_(yyformat);
	  yysize1 = yysize + yystrlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp += yytnamerr (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    {
	      yyerror (YY_("syntax error"));
	      goto yyexhaustedlab;
	    }
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (YY_("syntax error"));
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK;
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 624 "../../../libs/libFreeMat/Parser.yxx"


namespace FreeMat {

#ifdef YYBYACC  
  int yyparse();
#endif

  void resetParser() {
    mainAST = NULL;
    mainMDef = NULL;
  }
  
  ASTPtr getParsedScriptBlock() {
    return mainAST;
  }
  
  MFunctionDef* getParsedFunctionDef() {
    return mainMDef;
  }
  
  ParserState parseState() {
    if (mainAST != NULL) 
      return ScriptBlock;
    else
      return FuncDef;
  }
  
  ParserState parseString(char *txt) {
/*     yydebug = 1; 	*/
    resetParser();
    interactiveMode = true;
    setLexBuffer(txt);
    yyparse();
    return parseState();
  }
  
  ParserState parseFile(FILE *fp, const char* fname) {
//    yydebug = 1; 
    resetParser();
    interactiveMode = false;
    parsing_filename = fname;
    setLexFile(fp);
    yyparse();
    return parseState();
  }
  
}

