/*
 * Copyright (c) 2002-2006 Samit Basu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef __LUDecompose_hpp__
#define __LUDecompose_hpp__

#include "Array.hpp"

namespace FreeMat {
  void floatLU(int nrows, int ncols, float *l, float *u,
	       int *p, float *a);
  void complexLU(int nrows, int ncols, float *l, float *u,
	       int *p, float *a);
  void doubleLU(int nrows, int ncols, double *l, double *u,
		int *p, double *a);
  void dcomplexLU(int nrows, int ncols, double *l, double *u,
		  int *p, double *a);
  ArrayVector LUDecompose(int nargout, Array A);
}

#endif
