/////////////////////////////////////////////////////////////////////////////
// Name:        mediaenc.h
// Purpose:     Media Encoder Interface
// Author:      Alex Thuering
// Created:     24.02.2007
// RCS-ID:      $Id: mediaenc.h,v 1.2 2008/04/28 21:15:51 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_ENCODER_H
#define WX_MEDIA_ENCODER_H

#include <wx/image.h>

enum VideoFormat {
	vfNONE = 0,
	vfPAL,
	vfNTSC,
	vfCOPY
};

enum AudioFormat {
	afNONE = 0,
	afMP2,
	afAC3,
	afCOPY
};

enum SubtitleFormat {
	sfNONE = 0,
	sfCOPY,
	sfDVD
};

class wxMediaEncoder {
  public:
	virtual ~wxMediaEncoder() {}
	virtual bool BeginEncode(const wxString& fileName, VideoFormat videoFormat,
			AudioFormat audioFormat, int videoBitrate = 6000) = 0;
	virtual bool EncodeImage(wxImage image, int frames = 1) = 0;
	virtual void EndEncode() = 0;
};

#endif // WX_MEDIA_ENCODER_H
