#ifndef INCLUDE_WINCANVAS_H
#define INCLUDE_WINCANVAS_H

#include "../src-common/cfdg.h"
#include "../src-common/aggCanvas.h"
#include "stdafx.h"

class CChildFrame;

namespace Gdiplus {
	class Bitmap;
    struct ColorPalette;
};

class WinCanvas : public aggCanvas
{
public:
    WinCanvas(CChildFrame* cw, aggCanvas::PixelFormat pixfmt, 
        int width, int height, agg::rgba bkgrnd);
    WinCanvas(const WinCanvas&);				// declare but do not implement
    WinCanvas& operator=(const WinCanvas&);		// declare but do not implement
    ~WinCanvas();

    static void Shutdown();
    static void StartUp();
    static bool GdiPlusInitialized;
    static Gdiplus::Bitmap* AppBitmap;
    
    int mStride;
    aggCanvas::PixelFormat mPixelFormat;
	char* mBM;
    bool mChanged;
    bool mDone;
    Gdiplus::Color mBackground;
    Gdiplus::Color mBackgroundOpaque;
    
    void start(bool clear, const agg::rgba& bk, int, int);
    void end();
    
    
    void DoError();

    Gdiplus::Bitmap* MakeBitmap(bool cropped);
    
protected:
    static ULONG_PTR GdiPToken;
    static Gdiplus::GdiplusStartupInput GdiPStartInput;
    static Gdiplus::GdiplusStartupOutput GdiPStartOutput;
    static Gdiplus::ColorPalette* GrayPalette;
    CChildFrame* mFrame;
};

#endif // INCLUDE_WINCANVAS_H