// RenderOptions.cpp : implementation file
//

#include "stdafx.h"
#include "ContextFree.h"
#include "RenderOptions.h"
#include "RenderSize.h"

extern CContextFreeApp theApp;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRenderOptions dialog


CRenderOptions::CRenderOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CRenderOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRenderOptions)
	mEnablePartial = TRUE;
	mOpenRender = TRUE;
	mStartDoc = Welcome;
	mImageVariationAppend = FALSE;
	mImageCrop = TRUE;
	mMaximize = TRUE;
	mBorderSize = 0;
	mEmbedCFDG = FALSE;
	mJPEGQuality = 0;
	//}}AFX_DATA_INIT
    getProfile();
}


void CRenderOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRenderOptions)
	DDX_Control(pDX, IDC_BORDER_SLIDER, mBorderSliderCtrl);
	DDX_Check(pDX, IDC_PARTIAL, mEnablePartial);
	DDX_Check(pDX, IDC_OPEN_RENDER, mOpenRender);
	DDX_Radio(pDX, IDC_START_WELCOME, mStartDoc);
	DDX_Check(pDX, IDC_IMAGE_APPEND, mImageVariationAppend);
	DDX_Check(pDX, IDC_IMAGE_CROP, mImageCrop);
	DDX_Check(pDX, IDC_RENDER_MAXIMIZE, mMaximize);
	DDX_Slider(pDX, IDC_BORDER_SLIDER, mBorderSize);
	DDX_Check(pDX, IDC_EMBED_CFDG_DEF, mEmbedCFDG);
	DDX_Text(pDX, IDC_JPEG_QUAL_DEF, mJPEGQuality);
	DDV_MinMaxUInt(pDX, mJPEGQuality, 0, 100);
	//}}AFX_DATA_MAP
}

void CRenderOptions::OnOK()
{
    CDialog::OnOK();
    theApp.setPrefProgressive(mEnablePartial);
    theApp.setPrefRenderOnOpen(mOpenRender);
    theApp.setPrefStartup(mStartDoc);
    theApp.setPrefAppendVariation(mImageVariationAppend);
    theApp.setPrefCrop(mImageCrop);
    theApp.setPrefMaxTab(mMaximize);
    theApp.setPrefBorderWidth(mBorderSize);
    theApp.setPrefEmbedCFDG(mEmbedCFDG);
    theApp.setPrefJPEGqual(mJPEGQuality);

}

BOOL CRenderOptions::OnInitDialog()
{
    getProfile();

    CDialog::OnInitDialog();

    mBorderSliderCtrl.SetTic(33);
    mBorderSliderCtrl.SetTic(66);

    return TRUE;
}

void CRenderOptions::getProfile()
{
    mEnablePartial = theApp.getPrefProgressive();
    mOpenRender = theApp.getPrefRenderOnOpen();
    mStartDoc = theApp.getPrefStartup();
	mImageVariationAppend = theApp.getPrefAppendVariation();
	mImageCrop = theApp.getPrefCrop();
	mMaximize = theApp.getPrefMaxTab();
    mBorderSize = theApp.getPrefBorderWidth();
    mEmbedCFDG = theApp.getPrefEmbedCFDG();
    mJPEGQuality = theApp.getPrefJPEGqual();
}

BEGIN_MESSAGE_MAP(CRenderOptions, CDialog)
	//{{AFX_MSG_MAP(CRenderOptions)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
    //ON_COMMAND(IDOK, OnOK)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRenderOptions message handlers
